/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.midlet;

import com.sonyericsson.picasaweb.controller.ApplicationListener;
import com.sonyericsson.picasaweb.controller.MainController;
import com.sonyericsson.picasaweb.invocation.InvocationHandler;
import com.sonyericsson.picasaweb.log.ConsoleLogWriter;
import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.log.LogWriter;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.action.ActionHandlerMap;
import com.sonyericsson.picasaweb.service.action.AddActionHandler;
import com.sonyericsson.picasaweb.service.action.CancelActionHandler;
import com.sonyericsson.picasaweb.service.action.CapabilitiesActionHandler;
import com.sonyericsson.picasaweb.service.action.DownloadActionHandler;
import com.sonyericsson.picasaweb.service.action.GetActionHandler;
import com.sonyericsson.picasaweb.service.action.InfoActionHandler;
import com.sonyericsson.picasaweb.service.action.ListActionHandler;
import com.sonyericsson.picasaweb.service.action.RemoveActionHandler;
import com.sonyericsson.picasaweb.service.action.SignInActionHandler;
import com.sonyericsson.picasaweb.service.action.SignOutActionHandler;
import com.sonyericsson.picasaweb.service.action.UpdateActionHandler;
import com.sonyericsson.picasaweb.service.action.UploadActionHandler;
import com.sonyericsson.picasaweb.service.config.Config;
import com.sonyericsson.picasaweb.service.job.JobManager;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Registry;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class PicasaWebMidlet
extends MIDlet
implements ApplicationListener {
    private static final int DEFAULT_TIMEOUT = 100000;
    private boolean started = false;
    private MainController controller;
    private AuthorizationStore authStore;
    private JobManager jobManager;

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        Log.info(this, "destroyApp called, unconditional = " + unconditional);
        this.controller.stop();
    }

    protected void pauseApp() {
        Log.info(this, "pauseApp called");
    }

    protected void startApp() throws MIDletStateChangeException {
        if (!this.started) {
            this.started = true;
            int logLevel = 0;
            String property = null;
            int timeout = 100000;
            Log.setWriter(this.getLogWriter());
            property = this.getAppProperty("log-level");
            if (property != null) {
                if (property.equalsIgnoreCase("none")) {
                    logLevel = 0;
                } else if (property.equalsIgnoreCase("error")) {
                    logLevel = 1;
                } else if (property.equalsIgnoreCase("warning")) {
                    logLevel = 2;
                } else if (property.equalsIgnoreCase("info")) {
                    logLevel = 3;
                } else if (property.equalsIgnoreCase("trace")) {
                    logLevel = 4;
                }
                Log.setLevel(logLevel);
                Log.trace("Log-level value set to '" + property + "'");
            }
            if ((property = this.getAppProperty("timeout")) != null) {
                timeout = Integer.parseInt(property);
                Log.trace("Timeout value set to " + timeout);
            }
            if ((property = this.getAppProperty("thumbnail-size")) != null) {
                Config.setThumbNailSize(Integer.parseInt(property));
            }
            if ((property = this.getAppProperty("photo-download-size")) != null) {
                Config.setPhotoDownloadSize(Integer.parseInt(property));
            }
            if ((property = this.getAppProperty("photo-upload-size")) != null) {
                Config.setPhotoUploadSize(Integer.parseInt(property));
            }
            this.authStore = new AuthorizationStore();
            this.jobManager = new JobManager();
            ContentHandlerServer server = this.getServer();
            ActionHandlerMap actionHandlerMap = this.getActionHandlerMap();
            InvocationHandler invocHandler = new InvocationHandler(server, timeout);
            this.controller = new MainController(this, invocHandler, actionHandlerMap);
            this.controller.start();
        }
    }

    protected ActionHandlerMap getActionHandlerMap() {
        ActionHandlerMap map = new ActionHandlerMap();
        map.addHandler("info", new InfoActionHandler(this.authStore));
        map.addHandler("sign-in", new SignInActionHandler(this.authStore));
        map.addHandler("sign-out", new SignOutActionHandler(this.authStore));
        map.addHandler("capabilities", new CapabilitiesActionHandler());
        map.addHandler("list", new ListActionHandler(this.authStore));
        map.addHandler("get", new GetActionHandler(this.authStore));
        map.addHandler("add", new AddActionHandler(this.authStore));
        map.addHandler("update", new UpdateActionHandler(this.authStore));
        map.addHandler("remove", new RemoveActionHandler(this.authStore));
        map.addHandler("upload", new UploadActionHandler(this.authStore, this.jobManager));
        map.addHandler("download", new DownloadActionHandler(this.authStore, this.jobManager));
        map.addHandler("cancel", new CancelActionHandler(this.jobManager));
        return map;
    }

    protected ContentHandlerServer getServer() {
        ContentHandlerServer server = null;
        try {
            server = Registry.getServer((String)this.getClass().getName());
        }
        catch (ContentHandlerException contentHandlerException) {
            // empty catch block
        }
        return server;
    }

    protected LogWriter getLogWriter() {
        return new ConsoleLogWriter();
    }
}

