/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.model.Capability;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.codec.CapabilityCodec;
import com.sonyericsson.picasaweb.util.Attributes;

public class CapabilitiesActionHandler
implements ActionHandler {
    private static final int ALBUM_TITLE_MAX_LENGTH = 100;
    private static final int ALBUM_DESCRIPTION_MAX_LENGTH = 1000;
    private static final int CONTENT_TITLE_MAX_LENGTH = 100;
    private static final int CONTENT_DESCRIPTION_MAX_LENGTH = 1000;
    private static final int COMMENT_TEXT_MAX_LENGTH = 1000;

    private void addCapability(Attributes attr, Capability capability) {
        String value = CapabilityCodec.encodeCapability(capability);
        attr.set("capability:" + capability.getName(), value);
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        String type = inAttr.get("item:type");
        Capability capability = null;
        outAttr.set("item:type", type);
        if (type == null) {
            result = 4;
        } else if (type.equals("item")) {
            capability = new Capability("item:type", true);
            capability.addAllowedValue("item");
            capability.addAllowedValue("entry");
            capability.addAllowedValue("credentials");
            capability.addAllowedValue("album");
            capability.addAllowedValue("content");
            capability.addAllowedValue("comment");
            this.addCapability(outAttr, capability);
        } else if (type.equals("credentials")) {
            this.addCapability(outAttr, new Capability("user:login", true));
            this.addCapability(outAttr, new Capability("user:password", true));
            this.addCapability(outAttr, new Capability("captcha:id", false));
            this.addCapability(outAttr, new Capability("captcha:response", false));
        } else if (type.equals("album")) {
            this.addCapability(outAttr, new Capability("album:title", false, 100));
            this.addCapability(outAttr, new Capability("album:description", false, 1000));
            capability = new Capability("album:access", true);
            capability.addAllowedValue("public");
            capability.addAllowedValue("private");
            this.addCapability(outAttr, capability);
        } else if (type.equals("content")) {
            this.addCapability(outAttr, new Capability("content:title", false, 100));
            this.addCapability(outAttr, new Capability("content:description", false, 1000));
        } else if (type.equals("comment")) {
            this.addCapability(outAttr, new Capability("comment:text", true, 1000));
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

