/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.http.RemoveEntryRequest;
import com.sonyericsson.picasaweb.util.Attributes;

public class RemoveActionHandler
implements ActionHandler {
    private AuthorizationStore authStore;

    public RemoveActionHandler(AuthorizationStore authStore) {
        this.authStore = authStore;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        Attributes outAttr;
        ActionData actionData;
        int result;
        block3: {
            result = 0;
            actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            outAttr = new Attributes();
            String authToken = this.authStore.getUserInfo().getAuthToken();
            RemoveEntryRequest request = null;
            try {
                Entry entry = ActionUtil.fetchEntry(authToken, inAttr);
                String editUrl = entry.getEditUrl();
                if (editUrl == null) {
                    throw new ServiceException(11);
                }
                request = new RemoveEntryRequest(editUrl, authToken);
                ActionUtil.doHttpRequest(request);
            }
            catch (ServiceException se) {
                result = se.getResult();
                if (result != 5) break block3;
                this.authStore.setUserInfo(null);
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

