/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Album;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.model.Photo;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.codec.Codec;
import com.sonyericsson.picasaweb.service.http.UpdateAlbumRequest;
import com.sonyericsson.picasaweb.service.http.UpdatePhotoRequest;
import com.sonyericsson.picasaweb.util.Attributes;
import com.sonyericsson.picasaweb.util.HttpRequest;

public class UpdateActionHandler
implements ActionHandler {
    private AuthorizationStore authStore;

    public UpdateActionHandler(AuthorizationStore authStore) {
        this.authStore = authStore;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAction(Action action, ActionResponseListener responseListener) {
        Attributes outAttr;
        ActionData actionData;
        int result;
        block5: {
            result = 0;
            actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            outAttr = new Attributes();
            String authToken = this.authStore.getUserInfo().getAuthToken();
            Log.trace("UpdateActionHandler#handleAction");
            try {
                void var8_11;
                Object var8_8 = null;
                Entry entry = ActionUtil.fetchEntry(authToken, inAttr);
                String editUrl = entry.getEditUrl();
                if (editUrl == null) {
                    throw new ServiceException(11);
                }
                entry = Codec.decode(inAttr);
                if (entry instanceof Album) {
                    Album album = (Album)entry;
                    if (album.getId() == null || album.getTitle() == null) throw new ServiceException(4);
                    UpdateAlbumRequest updateAlbumRequest = new UpdateAlbumRequest(editUrl, authToken, album);
                } else {
                    if (!(entry instanceof Photo)) throw new ServiceException(2);
                    Photo photo = (Photo)entry;
                    if (photo.getId() == null) throw new ServiceException(4);
                    UpdatePhotoRequest updatePhotoRequest = new UpdatePhotoRequest(editUrl, authToken, photo);
                }
                Log.trace("UpdateActionHandler#handleAction: Making HTTP request to update " + entry.getType());
                ActionUtil.doHttpRequest((HttpRequest)var8_11);
            }
            catch (ServiceException serviceException) {
                result = serviceException.getResult();
                if (result != 5) break block5;
                this.authStore.setUserInfo(null);
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

