/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Album;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.service.codec.EntryCodec;
import com.sonyericsson.picasaweb.util.Attributes;

class AlbumCodec
extends EntryCodec {
    private static final String ATTR_TITLE = "album:title";
    private static final String ATTR_DESCRIPTION = "album:description";
    private static final String ATTR_ACCESS = "album:access";
    private static final String RESOURCE_COVER_IMAGE = "cover-image";

    AlbumCodec() {
    }

    protected Entry createEntry() {
        return new Album();
    }

    protected void decodeEntry(Attributes attr, Entry entry) {
        super.decodeEntry(attr, entry);
        Album album = (Album)entry;
        Log.trace("AlbumCodec.decodeEntry()");
        album.setTitle(EntryCodec.decodeAttribute(attr.get(ATTR_TITLE)));
        album.setDescription(EntryCodec.decodeAttribute(attr.get(ATTR_DESCRIPTION)));
        album.setAccess(attr.get(ATTR_ACCESS));
        EntryCodec.decodeResource(attr, RESOURCE_COVER_IMAGE, entry);
    }

    protected void encodeEntry(Entry entry, Attributes attr) {
        super.encodeEntry(entry, attr);
        Album album = (Album)entry;
        Log.trace("AlbumCodec.encodeEntry()");
        attr.set(ATTR_TITLE, EntryCodec.encodeAttribute(album.getTitle()));
        attr.set(ATTR_DESCRIPTION, EntryCodec.encodeAttribute(album.getDescription()));
        attr.set(ATTR_ACCESS, album.getAccess());
        EntryCodec.encodeResource(entry, RESOURCE_COVER_IMAGE, attr);
    }
}

