/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.ImageResource;
import com.sonyericsson.picasaweb.model.Resource;
import com.sonyericsson.picasaweb.service.codec.AttributeCodec;
import com.sonyericsson.picasaweb.util.StringMap;
import com.sonyericsson.picasaweb.util.StringUtil;
import java.io.UnsupportedEncodingException;

public class ResourceCodec {
    public static Resource decodeResource(String name, String value) {
        ImageResource resource = null;
        Log.trace("ResourceCodec.decodeResource()");
        try {
            StringMap params = StringUtil.decodeKeyValueString("url=" + value, "&", AttributeCodec.getInstance());
            String url = params.get("url");
            String type = params.get("type");
            int width = 0;
            int height = 0;
            try {
                width = Integer.parseInt(params.get("width"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                height = Integer.parseInt(params.get("height"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            resource = new ImageResource(name, url, type, width, height);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return resource;
    }

    public static String encodeResource(Resource resource) {
        String result = null;
        StringBuffer sb = new StringBuffer();
        AttributeCodec codec = AttributeCodec.getInstance();
        Log.trace("ResourceCodec.encodeResource()");
        try {
            sb.append(codec.encode(resource.getUrl()));
            String type = resource.getType();
            if (type != null && type.length() > 0) {
                sb.append("&type=").append(type);
            }
            if (resource instanceof ImageResource) {
                sb.append("&width=").append(String.valueOf(((ImageResource)resource).getWidth()));
                sb.append("&height=").append(String.valueOf(((ImageResource)resource).getHeight()));
            }
            result = sb.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

