/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.http;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.util.HttpRequest;
import com.sonyericsson.picasaweb.util.StringMap;
import com.sonyericsson.picasaweb.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SignInRequest
extends HttpRequest {
    public static final int AUTH_STATUS_AUTHORIZED = 0;
    public static final int AUTH_STATUS_BAD_AUTHENTICATION = 1;
    public static final int AUTH_STATUS_NOT_ACTIVE = 2;
    public static final int AUTH_STATUS_CAPTCHA_REQUIRED = 3;
    public static final int AUTH_STATUS_TEMPORARY_ERROR = 4;
    public static final int AUTH_STATUS_UNKNOWN_ERROR = 5;
    private byte[] bodyBytes;
    private String authToken;
    private String captchaToken;
    private String captchaURL;
    private int authStatus = 5;

    public SignInRequest(String username, String password) {
        this(username, password, null, null);
    }

    public SignInRequest(String username, String password, String captchaToken, String captchaResponse) {
        super("POST", "https://www.google.com/accounts/ClientLogin");
        StringBuffer sb = new StringBuffer();
        sb.append("Email=").append(username);
        sb.append("&Passwd=").append(password);
        sb.append("&service=lh2");
        sb.append("&accountType=GOOGLE");
        sb.append("&source=").append("SEMC-WebAlbum-1.00");
        if (captchaToken != null) {
            sb.append("&logintoken=").append(captchaToken);
        }
        if (captchaResponse != null) {
            sb.append("&logincaptcha=").append(captchaResponse);
        }
        String body = sb.toString();
        Log.trace(this, "Body = " + body);
        try {
            this.bodyBytes = body.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.headers.put("Content-Length", String.valueOf(this.bodyBytes.length));
    }

    public void writeBody(OutputStream os) throws IOException {
        os.write(this.bodyBytes);
    }

    public void readResponseBody(InputStream is) throws IOException {
        StringMap parameters = StringUtil.splitKeyValue(is, "\n");
        Log.trace(this, parameters.toString());
        if (this.responseCode == 200) {
            this.authToken = parameters.get("Auth");
            this.authStatus = this.authToken != null ? 0 : 5;
        } else if (this.responseCode == 403) {
            String error = parameters.get("Error");
            if (error.equals("CaptchaRequired")) {
                this.captchaToken = parameters.get("CaptchaToken");
                this.captchaURL = "https://www.google.com/accounts/" + parameters.get("CaptchaUrl");
                this.authStatus = 3;
            } else {
                this.authStatus = 1;
            }
        }
    }

    public int getAuthStatus() {
        return this.authStatus;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getCaptchaToken() {
        return this.captchaToken;
    }

    public String getCaptchaURL() {
        return this.captchaURL;
    }
}

