/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.http;

import com.sonyericsson.picasaweb.model.Photo;
import com.sonyericsson.picasaweb.model.Resource;
import com.sonyericsson.picasaweb.service.http.AuthenticatedRequest;
import com.sonyericsson.picasaweb.service.xml.XmlEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class UpdatePhotoRequest
extends AuthenticatedRequest {
    private Photo photo;

    public UpdatePhotoRequest(String editUrl, String authToken, Photo photo) {
        super("POST", editUrl, authToken);
        this.photo = photo;
        this.headers.put("X-HTTP-Method-Override", "PUT");
        this.headers.put("Content-Type", "application/atom+xml");
    }

    private void writeAtomEntry(OutputStream os) throws IOException {
        XmlEncoder enc = new XmlEncoder(os);
        enc.startElement("entry", "xmlns='http://www.w3.org/2005/Atom'");
        enc.addElement("title", null, this.getPhotoTitle());
        enc.addElement("summary", null, this.photo.getDescription());
        enc.addElement("category", "scheme=\"http://schemas.google.com/g/2005#kind\" term=\"http://schemas.google.com/photos/2007#photo\"");
        enc.endElement();
        enc.flush();
    }

    private String getPhotoTitle() {
        int lastSlashPos;
        String localUrl;
        Resource resource;
        String title = this.photo.getTitle();
        if (title == null && (resource = this.photo.getResource("content")) != null && (localUrl = resource.getLocalUrl()) != null && (lastSlashPos = localUrl.lastIndexOf(47)) >= 0) {
            title = localUrl.substring(lastSlashPos + 1);
        }
        if (title == null) {
            title = "unknown";
        }
        return title;
    }

    public void writeBody(OutputStream os) throws IOException {
        this.writeAtomEntry(os);
    }
}

