/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.http;

import com.sonyericsson.picasaweb.service.config.Config;
import com.sonyericsson.picasaweb.service.util.EntryUtil;

public abstract class UrlFactory {
    public static String createGetAlbumUrl(String albumId) {
        String url = null;
        String urlPart = EntryUtil.decodeAlbumId(albumId);
        if (urlPart != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("http://picasaweb.google.com/data/entry/api/user/default");
            sb.append(urlPart);
            sb.append("?imgmax=").append(Config.getPhotoDownloadSize()).append("u");
            sb.append("&thumbsize=").append(Config.getThumbNailSize()).append("u");
            url = sb.toString();
        }
        return url;
    }

    public static String createGetPhotoUrl(String photoId) {
        String url = null;
        String urlPart = EntryUtil.decodePhotoId(photoId);
        if (urlPart != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("http://picasaweb.google.com/data/entry/api/user/default");
            sb.append(urlPart);
            sb.append("?imgmax=").append(Config.getPhotoDownloadSize()).append("u");
            sb.append("&thumbsize=").append(Config.getThumbNailSize()).append("u");
            url = sb.toString();
        }
        return url;
    }

    public static String createGetCommentUrl(String commentId) {
        String url = null;
        String urlPart = EntryUtil.decodeCommentId(commentId);
        if (urlPart != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("http://picasaweb.google.com/data/entry/api/user/default");
            sb.append(urlPart);
            url = sb.toString();
        }
        return url;
    }

    public static String createListAlbumsUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append("http://picasaweb.google.com/data/feed/api/user/default");
        sb.append("?kind=album&thumbsize=");
        sb.append(Config.getThumbNailSize());
        sb.append("u");
        return sb.toString();
    }

    public static String createListPhotosUrl(String albumId) {
        String url = null;
        String urlPart = EntryUtil.decodeAlbumId(albumId);
        if (urlPart != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("http://picasaweb.google.com/data/feed/api/user/default");
            sb.append(urlPart);
            sb.append("?kind=photo");
            sb.append("&imgmax=").append(Config.getPhotoDownloadSize()).append("u");
            sb.append("&thumbsize=").append(Config.getThumbNailSize()).append("u");
            url = sb.toString();
        }
        return url;
    }

    public static String createListCommentsUrl(String photoId) {
        String url = null;
        String urlPart = EntryUtil.decodePhotoId(photoId);
        if (urlPart != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("http://picasaweb.google.com/data/feed/api/user/default");
            sb.append(urlPart);
            sb.append("?kind=comment");
            url = sb.toString();
        }
        return url;
    }

    public static String createGetUserUrl() {
        return "http://picasaweb.google.com/data/feed/api/user/default";
    }

    public static String createAddPhotoUrl(String albumId) {
        String url = null;
        String urlPart = EntryUtil.decodeAlbumId(albumId);
        if (urlPart != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("http://picasaweb.google.com/data/feed/api/user/default");
            sb.append(urlPart);
            url = sb.toString();
        }
        return url;
    }
}

