/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.controller;

import com.sonyericsson.picasaweb.controller.ApplicationListener;
import com.sonyericsson.picasaweb.invocation.InvocationAction;
import com.sonyericsson.picasaweb.invocation.InvocationHandler;
import com.sonyericsson.picasaweb.invocation.InvocationListener;
import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionHandlerMap;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import javax.microedition.content.Invocation;

public class MainController
implements InvocationListener,
ActionResponseListener {
    private ApplicationListener appListener;
    private InvocationHandler invocHandler;
    private ActionHandlerMap actionHandlerMap;

    public MainController(ApplicationListener appListener, InvocationHandler invocHandler, ActionHandlerMap actionHandlerMap) {
        this.appListener = appListener;
        this.invocHandler = invocHandler;
        this.actionHandlerMap = actionHandlerMap;
        invocHandler.setInvocationListener(this);
    }

    public void start() {
        Log.info(this, "Started");
        this.invocHandler.start();
    }

    public void stop() {
        Log.info(this, "Stopped");
        this.invocHandler.stop();
        this.appListener.notifyDestroyed();
    }

    public void inactivityNotify() {
        Log.info(this, "Inactivity reported, stopping");
        this.stop();
    }

    public void invocationRequestNotify(Invocation invocation) {
        InvocationAction action = new InvocationAction(invocation);
        ActionHandler actionHandler = this.actionHandlerMap.getHandler(action.getAction());
        if (actionHandler != null) {
            try {
                actionHandler.handleAction(action, this);
            }
            catch (Throwable t) {
                Log.warning("MainController caught a " + t.getClass().getName() + ": '" + t.getMessage() + "'");
                this.invocHandler.finishInvocation(invocation, 6);
            }
        } else {
            this.invocHandler.finishInvocation(invocation, 6);
        }
    }

    public void actionCompleteNotify(Action action) {
        this.invocHandler.finishInvocation(((InvocationAction)action).getInvocation(), 5);
    }

    public void actionProgressNotify(Action action) {
        this.invocHandler.reportInvocationProgress(((InvocationAction)action).getInvocation());
    }
}

