/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service;

public abstract class Result {
    public static final int OK = 0;
    public static final int CANCELLED = 1;
    public static final int INVALID_REQUEST = 2;
    public static final int NOT_SUPPORTED = 3;
    public static final int MANDATORY_INFORMATION_MISSING = 4;
    public static final int NOT_AUTHORIZED = 5;
    public static final int SERVICE_UNAVAILABLE = 6;
    public static final int SERVICE_ERROR = 7;
    public static final int COMMUNICATION_ERROR = 8;
    public static final int APPLICATION_ERROR = 9;
    public static final int FILESYSTEM_FULL = 10;
    public static final int UNKNOWN_ERROR = 11;
    private static final String[] resultStrings = new String[]{"ok", "cancelled", "invalid request", "not supported", "mandatory information missing", "not authorized", "service unavailable", "service error", "communication error", "application error", "filesystem full", "unknown error"};

    public static String toString(int result) {
        return resultStrings[result];
    }

    public static int fromHttpResponseCode(int responseCode) {
        int result = 0;
        switch (responseCode) {
            case 200: 
            case 201: {
                result = 0;
                break;
            }
            case 401: 
            case 403: {
                result = 5;
                break;
            }
            case 400: 
            case 404: {
                result = 2;
                break;
            }
            case 500: {
                result = 7;
                break;
            }
            default: {
                result = 11;
            }
        }
        return result;
    }
}

