/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Album;
import com.sonyericsson.picasaweb.model.Comment;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.codec.Codec;
import com.sonyericsson.picasaweb.service.http.AddAlbumRequest;
import com.sonyericsson.picasaweb.service.http.AddCommentRequest;
import com.sonyericsson.picasaweb.service.xml.AlbumParser;
import com.sonyericsson.picasaweb.service.xml.CommentParser;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.picasaweb.util.Attributes;
import com.sonyericsson.picasaweb.util.HttpRequest;

public class AddActionHandler
implements ActionHandler {
    private AuthorizationStore authStore;

    public AddActionHandler(AuthorizationStore authStore) {
        this.authStore = authStore;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAction(Action action, ActionResponseListener responseListener) {
        Attributes outAttr;
        ActionData actionData;
        int result;
        block6: {
            result = 0;
            actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            outAttr = new Attributes();
            String authToken = this.authStore.getUserInfo().getAuthToken();
            Log.trace("AddActionHandler#handleAction");
            try {
                Entry addedEntry;
                void var8_11;
                if (authToken == null) {
                    throw new ServiceException(5);
                }
                Object var8_8 = null;
                Entry entry = Codec.decode(inAttr);
                EntryParser parser = null;
                if (entry instanceof Album) {
                    Album album = (Album)entry;
                    if (album.getTitle() == null) throw new ServiceException(4);
                    parser = new AlbumParser(0, 1, "/entry");
                    AddAlbumRequest addAlbumRequest = new AddAlbumRequest(authToken, album, (AlbumParser)parser);
                } else {
                    if (!(entry instanceof Comment)) throw new ServiceException(2);
                    Comment comment = (Comment)entry;
                    if (comment.getPhotoId() == null || comment.getText() == null) throw new ServiceException(4);
                    parser = new CommentParser(0, 1, "/entry");
                    AddCommentRequest addCommentRequest = new AddCommentRequest(authToken, comment, (CommentParser)parser);
                }
                Log.trace("AddActionHandler#handleAction: Making HTTP request to add " + entry.getType());
                ActionUtil.doHttpRequest((HttpRequest)var8_11);
                if (parser != null && (addedEntry = parser.getFirstEntry()) != null) {
                    outAttr = Codec.encode(addedEntry);
                }
            }
            catch (ServiceException serviceException) {
                result = serviceException.getResult();
                if (result != 5) break block6;
                this.authStore.setUserInfo(null);
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

