/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.TransferItem;
import com.sonyericsson.picasaweb.service.action.TransferJobListener;
import com.sonyericsson.picasaweb.service.http.TransferRequest;
import com.sonyericsson.picasaweb.service.job.Job;

public abstract class TransferJob
extends Job {
    private TransferItem[] items;
    private int currentItemIndex;
    private TransferJobListener listener;
    protected boolean cancelled;
    protected String authToken;
    protected TransferRequest currentRequest;

    protected TransferJob(int id, String authToken, TransferItem[] items) {
        super(id);
        this.authToken = authToken;
        this.items = items;
    }

    public void setTransferJobListener(TransferJobListener listener) {
        this.listener = listener;
    }

    protected void reportProgress() {
        this.listener.transferProgressNotify(this.id, this.items);
    }

    protected TransferItem getCurrentItem() {
        return this.items[this.currentItemIndex];
    }

    public void cancel() {
        Log.trace("TransferJob#cancel");
        this.cancelled = true;
        if (this.currentRequest != null) {
            this.currentRequest.cancel();
        }
    }

    public void requestProgressNotify() {
        this.getCurrentItem().setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
        this.reportProgress();
    }

    public void run() {
        Log.trace("TransferJob#run: starting");
        this.currentItemIndex = 0;
        while (this.currentItemIndex < this.items.length) {
            if (this.items[this.currentItemIndex].getState() == 1) {
                if (this.cancelled) {
                    this.items[this.currentItemIndex].setState(3);
                } else {
                    Log.trace("TransferJob#run: transferring item " + this.currentItemIndex);
                    try {
                        this.transferCurrentItem();
                    }
                    catch (Throwable t) {
                        this.items[this.currentItemIndex].setState(4);
                        Log.warning("TransferJob#run: Unhandled error " + t.getClass().getName());
                    }
                }
            }
            ++this.currentItemIndex;
        }
        Log.trace("TransferJob#run: done");
        this.listener.transferCompleteNotify(this.id, this.items);
    }

    protected abstract void transferCurrentItem();
}

