/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.model.TransferItem;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.TransferJobListener;
import com.sonyericsson.picasaweb.util.Attributes;

public class TransferJobResponseHandler
implements TransferJobListener {
    private Action action;
    private ActionResponseListener responseListener;
    private static final String[] STATE_STRINGS = new String[]{"none", "waiting", "transferring", "cancelled", "failed", "completed"};

    public TransferJobResponseHandler(Action action, ActionResponseListener responseListener) {
        this.action = action;
        this.responseListener = responseListener;
    }

    private void encodeTransferItems(TransferItem[] items) {
        int i = 0;
        while (i < items.length) {
            ActionData childData = this.action.getChildData(i);
            this.encodeTransferItem(items[i], childData);
            ++i;
        }
    }

    protected void encodeTransferItem(TransferItem item, ActionData childData) {
        Attributes childOutAttr = new Attributes();
        childOutAttr.set("transfer-item:state", STATE_STRINGS[item.getState()]);
        childOutAttr.set("transfer-item:total-nr-bytes", String.valueOf(item.getTotalNrBytes()));
        childOutAttr.set("transfer-item:current-nr-bytes", String.valueOf(item.getCurrentNrBytes()));
        childData.setAttributes(childOutAttr);
    }

    public void transferProgressNotify(int transferId, TransferItem[] items) {
        this.encodeTransferItems(items);
        this.responseListener.actionProgressNotify(this.action);
    }

    public void transferCompleteNotify(int transferId, TransferItem[] items) {
        Attributes mainOutAttr = new Attributes();
        mainOutAttr.set("result", Result.toString(0));
        mainOutAttr.set("transfer:id", String.valueOf(transferId));
        this.action.getMainData().setAttributes(mainOutAttr);
        this.encodeTransferItems(items);
        this.responseListener.actionCompleteNotify(this.action);
    }
}

