/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.model.Photo;
import com.sonyericsson.picasaweb.model.Resource;
import com.sonyericsson.picasaweb.model.UploadItem;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.action.TransferJob;
import com.sonyericsson.picasaweb.service.config.Config;
import com.sonyericsson.picasaweb.service.http.RequestProgressListener;
import com.sonyericsson.picasaweb.service.http.UpdatePhotoRequest;
import com.sonyericsson.picasaweb.service.http.UploadPhotoRequest;
import com.sonyericsson.picasaweb.service.http.UrlFactory;
import com.sonyericsson.picasaweb.service.media.MediaUtil;
import com.sonyericsson.picasaweb.service.xml.PhotoParser;
import com.sonyericsson.picasaweb.util.HttpUtil;
import com.sonyericsson.picasaweb.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.media.MediaException;

public class UploadJob
extends TransferJob
implements RequestProgressListener {
    private static final int UPLOAD_PROGRESS_INTERVAL = 10240;
    private String baseDir;

    protected UploadJob(int id, String authToken, UploadItem[] items, String baseDir) {
        super(id, authToken, items);
        this.baseDir = baseDir;
    }

    /*
     * Loose catch block
     */
    private void uploadPhoto(Photo photo) {
        block30: {
            String tempUrl;
            InputStream is;
            FileConnection fc;
            UploadItem item;
            block29: {
                item = (UploadItem)this.getCurrentItem();
                fc = null;
                is = null;
                tempUrl = null;
                try {
                    int maxWidthOrHeight;
                    Log.trace("UploadJob#uploadPhoto: Starting upload");
                    String albumId = photo.getAlbumId();
                    if (albumId == null) {
                        throw new ServiceException(4);
                    }
                    String requestUrl = UrlFactory.createAddPhotoUrl(albumId);
                    Resource resource = photo.getResource("content");
                    if (resource == null) {
                        throw new ServiceException(2);
                    }
                    String localUrl = resource.getLocalUrl();
                    if (localUrl == null) {
                        throw new ServiceException(2);
                    }
                    String contentType = HttpUtil.getContentTypeFromUrl(localUrl);
                    if (MediaUtil.resizePhoto(localUrl, contentType, maxWidthOrHeight = Math.min(1600, Config.getPhotoUploadSize()), tempUrl = this.createTempUrl(localUrl))) {
                        localUrl = tempUrl;
                    }
                    int fileSize = IOUtil.getFileSize(localUrl);
                    item.setTotalNrBytes(fileSize);
                    fc = (FileConnection)Connector.open((String)localUrl);
                    is = fc.openInputStream();
                    PhotoParser entryParser = new PhotoParser(0, 1, "/entry");
                    Log.trace("UploadJob#uploadPhoto: making request");
                    this.currentRequest = new UploadPhotoRequest(requestUrl, this.authToken, is, contentType, entryParser);
                    this.currentRequest.setListener(this, 10240);
                    if (this.cancelled) {
                        this.currentRequest.cancel();
                    } else {
                        ActionUtil.doHttpRequest(this.currentRequest);
                    }
                    if (this.currentRequest.isCancelled()) break block29;
                    try {
                        String editUrl = entryParser.getFirstEntry().getEditUrl();
                        UpdatePhotoRequest upr = new UpdatePhotoRequest(editUrl, this.authToken, photo);
                        ActionUtil.doHttpRequest(upr);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    item.setState(5);
                }
                catch (IOException e) {
                    item.setState(4);
                    Log.logException(e);
                    IOUtil.closeInputStream(is);
                    IOUtil.closeConnection(fc);
                    if (this.currentRequest != null) {
                        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                        if (this.currentRequest.isCancelled()) {
                            item.setState(3);
                        }
                        this.currentRequest = null;
                    }
                    if (tempUrl != null) {
                        IOUtil.deleteFile(tempUrl);
                    }
                    break block30;
                }
                catch (ServiceException e) {
                    item.setState(4);
                    Log.logException(e);
                    break block30;
                }
                catch (MediaException e) {
                    item.setState(4);
                    Log.logException((Exception)((Object)e));
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    IOUtil.closeInputStream(is);
                    IOUtil.closeConnection(fc);
                    if (this.currentRequest != null) {
                        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                        if (this.currentRequest.isCancelled()) {
                            item.setState(3);
                        }
                        this.currentRequest = null;
                    }
                    if (tempUrl != null) {
                        IOUtil.deleteFile(tempUrl);
                    }
                    break block30;
                }
                {
                    finally {
                        IOUtil.closeInputStream(is);
                        IOUtil.closeConnection(fc);
                        if (this.currentRequest != null) {
                            item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                            if (this.currentRequest.isCancelled()) {
                                item.setState(3);
                            }
                            this.currentRequest = null;
                        }
                        if (tempUrl != null) {
                            IOUtil.deleteFile(tempUrl);
                        }
                    }
                }
            }
            IOUtil.closeInputStream(is);
            IOUtil.closeConnection((Connection)fc);
            if (this.currentRequest != null) {
                item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                if (this.currentRequest.isCancelled()) {
                    item.setState(3);
                }
                this.currentRequest = null;
            }
            if (tempUrl != null) {
                IOUtil.deleteFile(tempUrl);
            }
        }
    }

    private String createTempUrl(String localUrl) {
        return String.valueOf(ActionUtil.getTempDir(this.baseDir)) + "/temp" + System.currentTimeMillis();
    }

    protected void transferCurrentItem() {
        UploadItem item = (UploadItem)this.getCurrentItem();
        Entry entry = item.getEntry();
        item.setState(2);
        this.reportProgress();
        this.uploadPhoto((Photo)entry);
    }
}

