/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.model.Capability;
import com.sonyericsson.picasaweb.service.codec.AttributeCodec;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public class CapabilityCodec {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encodeCapability(Capability capability) {
        String result = null;
        Enumeration en = capability.getAllowedValues();
        AttributeCodec codec = AttributeCodec.getInstance();
        StringBuffer sb = new StringBuffer();
        try {
            while (true) {
                if (!en.hasMoreElements()) {
                    int maxValueLength;
                    sb.append("&mandatory=").append(String.valueOf(capability.isMandatory()));
                    String defaultValue = capability.getDefaultValue();
                    if (defaultValue != null) {
                        sb.append("&default-value=").append(codec.encode(defaultValue));
                    }
                    if ((maxValueLength = capability.getMaxValueLength()) < 0) return sb.toString();
                    sb.append("&max-value-length=").append(codec.encode(String.valueOf(maxValueLength)));
                    return sb.toString();
                }
                String value = (String)en.nextElement();
                try {
                    sb.append(codec.encode(value));
                    if (!en.hasMoreElements()) continue;
                    sb.append(";");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

