/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.xml;

import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.model.ImageResource;
import com.sonyericsson.picasaweb.model.Photo;
import com.sonyericsson.picasaweb.service.util.EntryUtil;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.picasaweb.util.HttpUtil;
import org.xml.sax.Attributes;

public class PhotoParser
extends EntryParser {
    public PhotoParser(int startIndex, int endIndex, String entryPath) {
        super(startIndex, endIndex, entryPath);
    }

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.currentEntry != null) {
            if (this.isCurrentPath(String.valueOf(this.entryPath) + "/media:group/media:thumbnail")) {
                String url = attributes.getValue("url");
                String width = attributes.getValue("width");
                String height = attributes.getValue("height");
                ImageResource resource = new ImageResource("thumbnail", url, HttpUtil.getContentTypeFromUrl(url), Integer.parseInt(width), Integer.parseInt(height));
                this.currentEntry.addResource(resource);
            } else if (this.isCurrentPath(String.valueOf(this.entryPath) + "/media:group/media:content")) {
                String url = attributes.getValue("url");
                String width = attributes.getValue("width");
                String height = attributes.getValue("height");
                ImageResource resource = new ImageResource("content", url, HttpUtil.getContentTypeFromUrl(url), Integer.parseInt(width), Integer.parseInt(height));
                this.currentEntry.addResource(resource);
            }
        }
    }

    public void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.currentEntry != null) {
            if (this.isCurrentPath(String.valueOf(this.entryPath) + "/title")) {
                ((Photo)this.currentEntry).setTitle(new String(ch, start, length));
            } else if (this.isCurrentPath(String.valueOf(this.entryPath) + "/summary")) {
                ((Photo)this.currentEntry).setDescription(new String(ch, start, length));
            }
        }
    }

    protected Entry createEntry() {
        return new Photo();
    }

    protected String getEntryId(String urlPart) {
        return EntryUtil.encodePhotoId(urlPart);
    }
}

