/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.util;

import com.sonyericsson.picasaweb.util.StringCodec;
import java.io.UnsupportedEncodingException;

public class URLCodec
implements StringCodec {
    private static URLCodec instance = null;

    private URLCodec() {
    }

    public static URLCodec getInstance() {
        if (instance == null) {
            instance = new URLCodec();
        }
        return instance;
    }

    public String decode(String s) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    c = ' ';
                    break;
                }
                case '%': {
                    c = (char)Byte.parseByte(s.substring(i + 1, 2), 16);
                    if (c > '\u007f') {
                        throw new UnsupportedEncodingException();
                    }
                    i += 2;
                    break;
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public String encode(String s) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                throw new UnsupportedEncodingException();
            }
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '$' || c == '-' || c == '_' || c == '.' || c == '+' || c == '!' || c == '*' || c == '\'' || c == '(' || c == ')' || c == ',') {
                sb.append(c);
            } else {
                sb.append('%');
                sb.append(Integer.toHexString(c).toUpperCase());
            }
            ++i;
        }
        return sb.toString();
    }
}

