/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.DownloadItem;
import com.sonyericsson.picasaweb.model.Resource;
import com.sonyericsson.picasaweb.model.TransferItem;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.action.TransferJob;
import com.sonyericsson.picasaweb.service.http.DownloadRequest;
import com.sonyericsson.picasaweb.service.http.RequestProgressListener;
import com.sonyericsson.picasaweb.util.IOUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class DownloadJob
extends TransferJob
implements RequestProgressListener {
    private static final int DOWNLOAD_PROGRESS_INTERVAL = 10240;

    public DownloadJob(int id, String authToken, DownloadItem[] items) {
        super(id, authToken, items);
    }

    private void downloadFile(String url, String localUrl) {
        block17: {
            DownloadItem item = (DownloadItem)this.getCurrentItem();
            FileConnection fc = null;
            OutputStream os = null;
            Log.trace("DownloadJob#downloadFile: Downloading from " + url + " to " + localUrl);
            try {
                try {
                    fc = (FileConnection)Connector.open((String)localUrl);
                    if (fc.exists()) {
                        fc.delete();
                    }
                    fc.create();
                    ActionUtil.deleteDownloadMarker(localUrl);
                    os = fc.openOutputStream();
                    this.currentRequest = new DownloadRequest(url, this.authToken, os);
                    this.currentRequest.setListener(this, 10240);
                    try {
                        if (this.cancelled) {
                            this.currentRequest.cancel();
                        } else {
                            ActionUtil.doHttpRequest(this.currentRequest);
                        }
                        if (!this.currentRequest.isCancelled()) {
                            ActionUtil.createDownloadMarker(localUrl);
                            item.setState(5);
                        }
                    }
                    catch (ServiceException e) {
                        item.setState(4);
                        Log.logException(e);
                    }
                }
                catch (IOException e) {
                    item.setState(4);
                    Log.logException(e);
                    IOUtil.closeOutputStream(os);
                    IOUtil.closeConnection((Connection)fc);
                    if (this.currentRequest != null) {
                        item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                        if (this.currentRequest.isCancelled()) {
                            item.setState(3);
                        }
                        this.currentRequest = null;
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeOutputStream(os);
                IOUtil.closeConnection((Connection)fc);
                if (this.currentRequest != null) {
                    item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                    item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                    if (this.currentRequest.isCancelled()) {
                        item.setState(3);
                    }
                    this.currentRequest = null;
                }
                throw throwable;
            }
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            if (this.currentRequest != null) {
                item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                if (this.currentRequest.isCancelled()) {
                    item.setState(3);
                }
                this.currentRequest = null;
            }
        }
    }

    protected void transferCurrentItem() {
        DownloadItem item = (DownloadItem)this.getCurrentItem();
        Resource resource = item.getResource();
        String url = resource.getUrl();
        String localUrl = resource.getLocalUrl();
        item.setState(2);
        this.reportProgress();
        this.downloadFile(url, localUrl);
    }

    public void requestProgressNotify() {
        TransferItem item = this.getCurrentItem();
        item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
        this.reportProgress();
    }
}

