/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.model.EntryList;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.codec.Codec;
import com.sonyericsson.picasaweb.service.http.DownloadRequest;
import com.sonyericsson.picasaweb.service.http.UrlFactory;
import com.sonyericsson.picasaweb.service.xml.AlbumParser;
import com.sonyericsson.picasaweb.service.xml.CommentParser;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.picasaweb.service.xml.PhotoParser;
import com.sonyericsson.picasaweb.service.xml.XmlException;
import com.sonyericsson.picasaweb.util.Attributes;
import com.sonyericsson.picasaweb.util.HttpUtil;
import com.sonyericsson.picasaweb.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class ListActionHandler
implements ActionHandler {
    private AuthorizationStore authStore;

    public ListActionHandler(AuthorizationStore authStore) {
        this.authStore = authStore;
    }

    private EntryList getEntryList(ActionData actionData) throws ServiceException {
        EntryList list;
        int endIndex;
        int startIndex;
        Attributes inAttr = actionData.getAttributes();
        String baseDir = actionData.getUrl();
        String authToken = this.authStore.getUserInfo().getAuthToken();
        String requestUrl = null;
        String localUrl = null;
        EntryParser entryParser = null;
        if (baseDir == null) {
            throw new ServiceException(4);
        }
        String cacheDir = ActionUtil.getCacheDir(baseDir);
        try {
            startIndex = Integer.parseInt(inAttr.get("list:start-entry"));
            endIndex = Integer.parseInt(inAttr.get("list:end-entry"));
        }
        catch (NumberFormatException e) {
            startIndex = 0;
            endIndex = Integer.MAX_VALUE;
        }
        String type = inAttr.get("item:type");
        if (type == null) {
            throw new ServiceException(4);
        }
        if (type.equals("album")) {
            requestUrl = UrlFactory.createListAlbumsUrl();
            entryParser = new AlbumParser(startIndex, endIndex, "/feed/entry");
        } else if (type.equals("content")) {
            String albumId = inAttr.get("album:id");
            if (albumId == null) {
                throw new ServiceException(4);
            }
            requestUrl = UrlFactory.createListPhotosUrl(albumId);
            entryParser = new PhotoParser(startIndex, endIndex, "/feed/entry");
        } else if (type.equals("comment")) {
            String photoId = inAttr.get("content:id");
            if (photoId == null) {
                throw new ServiceException(4);
            }
            requestUrl = UrlFactory.createListCommentsUrl(photoId);
            entryParser = new CommentParser(startIndex, endIndex, "/feed/entry");
        } else {
            throw new ServiceException(3);
        }
        if (requestUrl == null || entryParser == null) {
            throw new ServiceException(11);
        }
        localUrl = HttpUtil.hashUrlIntoLocalUrl(requestUrl, cacheDir);
        boolean doDownload = this.downloadNeeded(localUrl, inAttr.get("list:force-refresh"));
        if (doDownload) {
            this.downloadFeed(requestUrl, authToken, localUrl);
        }
        try {
            list = this.parseFeed(localUrl, entryParser);
        }
        catch (ServiceException se) {
            if (doDownload) {
                throw se;
            }
            Log.info("ListActionHandler: Could not parse cached feed, refreshing it");
            this.downloadFeed(requestUrl, authToken, localUrl);
            list = this.parseFeed(localUrl, entryParser);
        }
        return list;
    }

    private boolean downloadNeeded(String localUrl, String forceRefresh) {
        boolean downloadNeeded = false;
        if (forceRefresh != null && forceRefresh.toLowerCase().equals("true")) {
            downloadNeeded = true;
        } else if (!ActionUtil.hasDownloadMarker(localUrl)) {
            downloadNeeded = true;
        }
        return downloadNeeded;
    }

    private EntryList parseFeed(String localUrl, EntryParser entryParser) throws ServiceException {
        EntryList list = null;
        FileConnection fc = null;
        InputStream is = null;
        try {
            try {
                fc = (FileConnection)Connector.open((String)localUrl);
                is = fc.openInputStream();
                try {
                    entryParser.parse(is);
                    list = entryParser.getEntries();
                }
                catch (XmlException e) {
                    Log.logException(e);
                }
            }
            catch (IOException e) {
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeConnection(fc);
            throw throwable;
        }
        IOUtil.closeConnection((Connection)fc);
        if (list == null) {
            throw new ServiceException(11);
        }
        return list;
    }

    private void downloadFeed(String requestUrl, String authToken, String localUrl) throws ServiceException {
        FileConnection fc = null;
        OutputStream os = null;
        if (authToken == null) {
            throw new ServiceException(5);
        }
        try {
            try {
                fc = (FileConnection)Connector.open((String)localUrl);
                if (fc.exists()) {
                    fc.delete();
                }
                fc.create();
                ActionUtil.deleteDownloadMarker(localUrl);
                os = fc.openOutputStream();
                DownloadRequest dr = new DownloadRequest(requestUrl, authToken, os);
                ActionUtil.doHttpRequest(dr);
                ActionUtil.createDownloadMarker(localUrl);
            }
            catch (IOException e) {
                if (fc != null && fc.availableSize() < 1000L) {
                    throw new ServiceException(10);
                }
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            throw throwable;
        }
        IOUtil.closeOutputStream(os);
        IOUtil.closeConnection((Connection)fc);
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        Attributes outAttr;
        ActionData actionData;
        int result;
        block3: {
            result = 0;
            actionData = action.getMainData();
            outAttr = new Attributes();
            try {
                EntryList list = this.getEntryList(actionData);
                outAttr.set("list:entry-count", String.valueOf(list.getNrOfEntries()));
                outAttr.set("list:start-entry", String.valueOf(list.getStartIndex()));
                outAttr.set("list:end-entry", String.valueOf(list.getEndIndex()));
                Log.trace("Got " + list.getNrOfEntries() + " entries");
                int i = list.getStartIndex();
                while (i < list.getEndIndex()) {
                    Entry entry = list.getEntry(i);
                    ActionData childData = action.addChildData();
                    Log.trace("Encoding entry " + i);
                    Attributes partOutAttr = Codec.encode(entry);
                    childData.setAttributes(partOutAttr);
                    ++i;
                }
            }
            catch (ServiceException se) {
                result = se.getResult();
                if (result != 5) break block3;
                this.authStore.setUserInfo(null);
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

