/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.model.Photo;
import com.sonyericsson.picasaweb.model.Resource;
import com.sonyericsson.picasaweb.model.UploadItem;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.TransferJobResponseHandler;
import com.sonyericsson.picasaweb.service.action.UploadJob;
import com.sonyericsson.picasaweb.service.codec.Codec;
import com.sonyericsson.picasaweb.service.job.JobManager;
import com.sonyericsson.picasaweb.util.Attributes;

public class UploadActionHandler
implements ActionHandler {
    private AuthorizationStore authStore;
    private JobManager jobManager;

    public UploadActionHandler(AuthorizationStore authStore, JobManager jobManager) {
        this.authStore = authStore;
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        String baseDir = mainData.getUrl();
        String authToken = this.authStore.getUserInfo().getAuthToken();
        try {
            int transferId = 0;
            int count = action.getChildDataCount();
            UploadItem[] items = new UploadItem[count];
            if (baseDir == null) {
                throw new ServiceException(4);
            }
            if (authToken == null) {
                throw new ServiceException(5);
            }
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            int i = 0;
            while (i < count) {
                ActionData childData = action.getChildData(i);
                Entry entry = Codec.decode(childData.getAttributes());
                String localUrl = childData.getUrl();
                items[i] = new UploadItem(entry);
                if (entry instanceof Photo && localUrl != null) {
                    Resource resource = new Resource("content", null, null);
                    resource.setLocalURL(localUrl);
                    entry.addResource(resource);
                    items[i].setState(1);
                } else {
                    items[i].setState(4);
                }
                ++i;
            }
            UploadJob uj = new UploadJob(transferId, authToken, items, baseDir);
            uj.setTransferJobListener(new TransferJobResponseHandler(action, responseListener));
            this.jobManager.addJob(uj);
        }
        catch (ServiceException se) {
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            responseListener.actionCompleteNotify(action);
        }
    }
}

