/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.model.Resource;
import com.sonyericsson.picasaweb.service.codec.AttributeCodec;
import com.sonyericsson.picasaweb.service.codec.ResourceCodec;
import com.sonyericsson.picasaweb.util.Attributes;
import java.io.UnsupportedEncodingException;

abstract class EntryCodec {
    static final String ATTR_TYPE = "item:type";
    private static final String ATTR_ID = ":id";
    private static final String ATTR_TIMESTAMP = ":timestamp";
    private static final String ATTR_WEBPAGE_URL = ":webpage-url";
    private static final String ATTR_RSS_URL = ":rss-url";
    private static final String NS_RESOURCE = "resource:";

    EntryCodec() {
    }

    abstract Entry createEntry();

    void decodeEntry(Attributes attr, Entry entry) {
        String type = attr.get(ATTR_TYPE);
        Log.trace("EntryCodec.decodeEntry()");
        entry.setId(attr.get(String.valueOf(type) + ATTR_ID));
    }

    void encodeEntry(Entry entry, Attributes attr) {
        String type = entry.getType();
        Log.trace("EntryCodec.encodeEntry()");
        attr.set(ATTR_TYPE, type);
        attr.set(String.valueOf(type) + ATTR_ID, entry.getId());
        attr.set(String.valueOf(type) + ATTR_TIMESTAMP, String.valueOf(entry.getTimestamp()));
        attr.set(String.valueOf(type) + ATTR_WEBPAGE_URL, EntryCodec.encodeAttribute(entry.getWebPageUrl()));
        attr.set(String.valueOf(type) + ATTR_RSS_URL, EntryCodec.encodeAttribute(entry.getRssUrl()));
    }

    static void encodeResource(Entry entry, String name, Attributes attr) {
        Resource resource = entry.getResource(name);
        if (resource != null) {
            String value = ResourceCodec.encodeResource(resource);
            attr.set(NS_RESOURCE + name, value);
        }
    }

    static void decodeResource(Attributes attr, String name, Entry entry) {
        String value = attr.get(NS_RESOURCE + name);
        Resource resource = ResourceCodec.decodeResource(name, value);
        if (resource != null) {
            entry.addResource(resource);
        }
    }

    static final String encodeAttribute(String s) {
        String result = null;
        try {
            result = AttributeCodec.getInstance().encode(s);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    static final String decodeAttribute(String s) {
        String result = null;
        try {
            result = AttributeCodec.getInstance().decode(s);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

