/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.model.Photo;
import com.sonyericsson.picasaweb.service.codec.EntryCodec;
import com.sonyericsson.picasaweb.util.Attributes;

public class PhotoCodec
extends EntryCodec {
    private static final String ATTR_ALBUM_ID = "album:id";
    private static final String ATTR_TITLE = "content:title";
    private static final String ATTR_DESCRIPTION = "content:description";
    private static final String RESOURCE_THUMBNAIL = "thumbnail";
    private static final String RESOURCE_CONTENT = "content";

    protected Entry createEntry() {
        return new Photo();
    }

    protected void encodeEntry(Entry entry, Attributes attr) {
        super.encodeEntry(entry, attr);
        Photo photo = (Photo)entry;
        Log.trace("PhotoCodec.encodeEntry()");
        attr.set(ATTR_TITLE, EntryCodec.encodeAttribute(photo.getTitle()));
        attr.set(ATTR_DESCRIPTION, EntryCodec.encodeAttribute(photo.getDescription()));
        attr.set(ATTR_ALBUM_ID, photo.getAlbumId());
        EntryCodec.encodeResource(entry, RESOURCE_CONTENT, attr);
        EntryCodec.encodeResource(entry, RESOURCE_THUMBNAIL, attr);
    }

    protected void decodeEntry(Attributes attr, Entry entry) {
        super.decodeEntry(attr, entry);
        Photo photo = (Photo)entry;
        Log.trace("PhotoCodec.encodeEntry()");
        photo.setTitle(EntryCodec.decodeAttribute(attr.get(ATTR_TITLE)));
        photo.setDescription(EntryCodec.decodeAttribute(attr.get(ATTR_DESCRIPTION)));
        photo.setAlbumId(attr.get(ATTR_ALBUM_ID));
        EntryCodec.decodeResource(attr, RESOURCE_CONTENT, entry);
        EntryCodec.decodeResource(attr, RESOURCE_THUMBNAIL, entry);
    }
}

