/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.http;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.service.http.AuthenticatedRequest;
import com.sonyericsson.picasaweb.service.http.RequestProgressListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class TransferRequest
extends AuthenticatedRequest {
    private static final int BUF_SIZE = 1024;
    protected RequestProgressListener listener;
    protected boolean cancelled;
    protected int nrTransferredBytes;
    protected int progressInterval;
    private boolean completed;

    protected TransferRequest(String method, String url, String authToken) {
        super(method, url, authToken);
    }

    public void setListener(RequestProgressListener listener, int progressInterval) {
        this.listener = listener;
        this.progressInterval = progressInterval;
    }

    public void cancel() {
        if (!this.completed) {
            this.cancelled = true;
            Log.info("TransferRequest#cancel: Cancelled after " + this.nrTransferredBytes + " bytes");
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getNrTransferredBytes() {
        return this.nrTransferredBytes;
    }

    protected void copyStream(InputStream is, OutputStream os) throws IOException {
        int nrBytes = 0;
        byte[] bytes = new byte[1024];
        int nextProgressNotify = this.progressInterval;
        this.nrTransferredBytes = 0;
        Log.trace("TransferRequest#copyStream");
        while (!this.cancelled && (nrBytes = is.read(bytes)) > 0) {
            os.write(bytes, 0, nrBytes);
            this.nrTransferredBytes += nrBytes;
            if (this.listener == null || this.nrTransferredBytes < nextProgressNotify) continue;
            this.listener.requestProgressNotify();
            nextProgressNotify += this.progressInterval;
        }
        if (this.cancelled) {
            Log.info("TransferRequest#copyStream: transfer was cancelled");
        } else {
            this.completed = true;
        }
    }
}

