/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Stack;

public class XmlEncoder {
    private OutputStream os;
    private StringBuffer sb;
    private Stack elements = new Stack();

    public XmlEncoder(OutputStream os) {
        this.os = os;
    }

    private void ensureStringBuffer() {
        if (this.sb == null) {
            this.sb = new StringBuffer(512);
        }
    }

    private void flushIfNeeded() throws IOException {
        if (this.sb != null && this.sb.length() >= 256) {
            this.flush();
        }
    }

    private void indent() {
        int i = 0;
        while (i < this.elements.size() * 2) {
            this.sb.append(' ');
            ++i;
        }
    }

    private String encodePCData(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            String encodedChar = null;
            if (c > '\u007f') {
                encodedChar = "&#" + c + ";";
            } else {
                switch (c) {
                    case '&': {
                        encodedChar = "&amp;";
                        break;
                    }
                    case '<': {
                        encodedChar = "&lt;";
                        break;
                    }
                    case '>': {
                        encodedChar = "&gt;";
                        break;
                    }
                    case '\"': {
                        encodedChar = "&quot;";
                        break;
                    }
                    case '\'': {
                        encodedChar = "&apos;";
                    }
                }
            }
            if (encodedChar != null) {
                sb.append(encodedChar);
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public void startElement(String qName) throws IOException {
        this.startElement(qName, null);
    }

    public void startElement(String qName, String attributes) throws IOException {
        this.ensureStringBuffer();
        this.indent();
        this.elements.push(qName);
        this.sb.append('<').append(qName);
        if (attributes != null) {
            this.sb.append(' ').append(attributes);
        }
        this.sb.append('>');
        this.flushIfNeeded();
    }

    public void addPCDATA(String pcdata) throws IOException {
        this.ensureStringBuffer();
        this.sb.append(this.encodePCData(pcdata));
        this.flushIfNeeded();
    }

    public void endElement() throws IOException {
        this.ensureStringBuffer();
        String qName = (String)this.elements.pop();
        if (qName != null) {
            this.indent();
            this.sb.append("</").append(qName).append(">\n");
        }
    }

    public void addElement(String qName, String attributes) throws IOException {
        this.ensureStringBuffer();
        this.indent();
        this.sb.append('<').append(qName);
        if (attributes != null) {
            this.sb.append(' ').append(attributes);
        }
        this.sb.append("/>\n");
        this.flushIfNeeded();
    }

    public void addElement(String qName, String attributes, String pcdata) throws IOException {
        this.ensureStringBuffer();
        if (pcdata != null) {
            this.indent();
            this.sb.append('<').append(qName);
            if (attributes != null) {
                this.sb.append(' ').append(attributes);
            }
            this.sb.append(">");
            this.sb.append(this.encodePCData(pcdata));
            this.sb.append("</").append(qName).append(">\n");
            this.flushIfNeeded();
        } else {
            this.addElement(qName, attributes);
        }
    }

    public void flush() throws IOException {
        if (this.sb != null) {
            this.os.write(this.sb.toString().getBytes());
            this.sb = null;
        }
    }
}

