/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.util;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.util.ConnectionFactory;
import com.sonyericsson.picasaweb.util.DefaultConnectionFactory;
import com.sonyericsson.picasaweb.util.HttpRequest;
import com.sonyericsson.picasaweb.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.HttpConnection;

public abstract class HttpUtil {
    private static ConnectionFactory connectionFactory = new DefaultConnectionFactory();

    private static void setPrioritisedRequestHeader(HttpConnection conn, Hashtable headers, String property) throws IOException {
        String value = (String)headers.remove(property);
        if (value != null) {
            Log.trace("HttpUtil#setPrioritisedRequestHeader: '" + property + ": " + value + "'");
            conn.setRequestProperty(property, value);
        }
    }

    private static void setRequestHeaders(HttpConnection conn, HttpRequest request) throws IOException {
        Hashtable headers = request.getHeaders();
        if (headers != null) {
            Enumeration keys = headers.keys();
            HttpUtil.setPrioritisedRequestHeader(conn, headers, "Content-Type");
            HttpUtil.setPrioritisedRequestHeader(conn, headers, "Content-Length");
            HttpUtil.setPrioritisedRequestHeader(conn, headers, "MIME-Version");
            while (keys.hasMoreElements()) {
                String property = (String)keys.nextElement();
                String value = (String)headers.get(property);
                Log.trace("HttpUtil#setRequestHeaders: '" + property + ": " + value + "'");
                conn.setRequestProperty(property, value);
            }
        }
    }

    private static void writeBody(HttpConnection conn, HttpRequest request) throws IOException {
        OutputStream os = null;
        try {
            Log.trace("HttpUtil#writeBody : opening OutputStream");
            os = conn.openOutputStream();
            Log.trace("HttpUtil#writeBody : writing body");
            request.writeBody(os);
            Log.trace("HttpUtil#writeBody : body written");
        }
        finally {
            if (os != null) {
                try {
                    Log.trace("HttpUtil#writeBody : closing OutputStream");
                    os.close();
                }
                catch (IOException e) {
                    Log.logException(e);
                }
            }
        }
        Log.trace("HttpUtil#writeBody : done");
    }

    private static void readResponseBody(HttpConnection conn, HttpRequest request) throws IOException {
        InputStream is = null;
        try {
            is = conn.openInputStream();
            request.readResponseBody(is);
        }
        finally {
            IOUtil.closeInputStream(is);
        }
    }

    private static String hashMD5(String s) {
        String result = null;
        try {
            byte[] input = s.getBytes("UTF-8");
            byte[] output = new byte[16];
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input, 0, input.length);
            int outputLength = md.digest(output, 0, output.length);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < outputLength) {
                sb.append(Integer.toHexString(output[i] & 0xFF));
                ++i;
            }
            result = sb.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (DigestException digestException) {
            // empty catch block
        }
        return result;
    }

    public static void setConnectionFactory(ConnectionFactory factory) {
        connectionFactory = factory;
    }

    public static int copyStream(InputStream is, OutputStream os) throws IOException {
        int totalNrBytes = 0;
        int nrBytes = 0;
        byte[] bytes = new byte[1024];
        while ((nrBytes = is.read(bytes)) > 0) {
            os.write(bytes, 0, nrBytes);
            totalNrBytes += nrBytes;
        }
        return totalNrBytes;
    }

    private static void doRequest(HttpRequest request, boolean useOverrideMethod) throws IOException {
        HttpConnection conn = null;
        try {
            try {
                Log.trace("HttpUtil#doRequest: opening connection to " + request.getURL());
                conn = (HttpConnection)connectionFactory.open(request.getURL());
                String method = request.getMethod();
                if (useOverrideMethod) {
                    Log.trace("HttpUtil#doRequest: using X-HTTP-Method-Override, setting request method POST");
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("X-HTTP-Method-Override", method);
                } else {
                    Log.trace("HttpUtil#doRequest: setting request method " + method);
                    conn.setRequestMethod(method);
                }
                Log.trace("HttpUtil#doRequest: setting request headers");
                HttpUtil.setRequestHeaders(conn, request);
                Log.trace("HttpUtil#doRequest: writing body");
                HttpUtil.writeBody(conn, request);
                Log.trace("HttpUtil#doRequest: handling response");
                request.setResponse(conn.getResponseCode(), conn.getResponseMessage());
                try {
                    request.setContentLength(Integer.parseInt(conn.getHeaderField("Content-Length")));
                    Log.trace("HttpUtil#doRequest: Content-Length is " + request.getResponseContentLength());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Log.trace("HttpUtil#doRequest: reading response body");
                HttpUtil.readResponseBody(conn, request);
            }
            catch (IOException e) {
                Log.logException(e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeConnection(conn);
            throw throwable;
        }
        IOUtil.closeConnection((Connection)conn);
    }

    public static void doRequest(HttpRequest request) throws IOException {
        HttpUtil.doRequest(request, false);
        int responseCode = request.getResponseCode();
        String method = request.getMethod();
        if (responseCode == 400 && (method.equals("DELETE") || method.equals("PUT"))) {
            Log.warning("HttpUtil#doRequest: HTTP request failed, possibly due to method " + method + " not being supported, retrying with X-HTTP-Method-Override.");
            HttpUtil.doRequest(request, true);
        }
    }

    public static String hashUrlIntoLocalUrl(String url, String baseDir) {
        int lastSlashPos;
        int lastDotPos;
        StringBuffer sb = new StringBuffer();
        int startPos = 0;
        int endPos = url.length();
        int schemePos = url.indexOf("://");
        if (schemePos >= 0) {
            startPos = schemePos + 3;
        }
        if ((lastDotPos = url.lastIndexOf(46)) > (lastSlashPos = url.lastIndexOf(47))) {
            endPos = lastDotPos;
        }
        sb.append(baseDir);
        if (!baseDir.endsWith("/")) {
            sb.append('/');
        }
        sb.append(HttpUtil.hashMD5(url.substring(startPos, endPos)));
        sb.append(url.substring(endPos));
        return sb.toString();
    }

    public static String getContentTypeFromSuffix(String suffix) {
        String contentType = "";
        if (suffix.equalsIgnoreCase(".jpg") || suffix.equalsIgnoreCase(".jpeg")) {
            contentType = "image/jpeg";
        } else if (suffix.equalsIgnoreCase(".png")) {
            contentType = "image/png";
        } else if (suffix.equalsIgnoreCase(".bmp")) {
            contentType = "image/bmp";
        } else if (suffix.equalsIgnoreCase(".gif")) {
            contentType = "image/gif";
        } else if (suffix.equalsIgnoreCase(".mpg") || suffix.equalsIgnoreCase(".mpeg")) {
            contentType = "video/mpeg";
        }
        return contentType;
    }

    public static String getContentTypeFromUrl(String url) {
        int lastDotPos = url.lastIndexOf(46);
        if (lastDotPos >= 0) {
            return HttpUtil.getContentTypeFromSuffix(url.substring(lastDotPos));
        }
        return null;
    }
}

