/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.job;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.service.job.Job;
import java.util.NoSuchElementException;
import java.util.Vector;

public class JobManager
extends Thread {
    private Vector jobQueue = new Vector();
    private boolean running = false;
    private Job currentJob = null;

    private Job getNextJob() {
        Job nextJob = null;
        try {
            nextJob = (Job)this.jobQueue.firstElement();
            this.jobQueue.removeElement(nextJob);
        }
        catch (NoSuchElementException nsee) {
            nextJob = null;
        }
        return nextJob;
    }

    public synchronized void addJob(Job job) {
        Log.info("JobManager: Adding new job, id = " + job.getId());
        this.jobQueue.addElement(job);
        if (!this.running) {
            this.start();
        } else {
            this.notify();
        }
    }

    public synchronized boolean cancelJob(int id) {
        Log.info("JobManager: Cancelling job, id = " + id);
        if (this.currentJob != null && this.currentJob.getId() == id) {
            this.currentJob.cancel();
            return true;
        }
        int i = 0;
        while (i < this.jobQueue.size()) {
            if (((Job)this.jobQueue.elementAt(i)).getId() == id) {
                this.jobQueue.removeElementAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.trace("JobManager: starting");
        this.running = true;
        while (this.running) {
            Job nextJob = null;
            Log.trace("JobManager: running");
            JobManager jobManager = this;
            synchronized (jobManager) {
                nextJob = this.getNextJob();
                while (nextJob == null) {
                    Log.trace("JobManager: waiting for job");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    nextJob = this.getNextJob();
                }
                this.currentJob = nextJob;
            }
            Log.trace("JobManager: Starting job, id = " + nextJob.getId());
            nextJob.run();
        }
    }
}

