/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class OPPDRMCanvas
extends Canvas
implements OPPDRMConstants,
CommandListener,
Runnable {
    private static final String RECORDSTORE_NAME = "oppdrm";
    public static final int OPP_DRM_LOGO = 501;
    public static final int OPP_DRM_WELCOME = 502;
    public static final int OPP_DRM_NAG = 503;
    public static final int OPP_DRM_AD1 = 504;
    public static final int OPP_DRM_PURCHASE = 505;
    public static final int OPP_DRM_DEMORUN_PERIOD = 506;
    public static final int OPP_DRM_DEMORUN_EXPIRED = 507;
    public static final int OPP_DRM_USERMINENTRY = 508;
    Command startCmd = new Command("Start", 4, 1);
    Command purchaseCmd = new Command("Buy", 2, 2);
    Command buyCmd = new Command("Buy", 4, 2);
    Command resumeCmd = new Command("Resume", 4, 1);
    Command exitCmd = new Command("Exit", 7, 1);
    Command submitCmd = new Command("Submit", 4, 1);
    private static final int FRAME_RATE = 15;
    private int drmState;
    private int _drmMode = 500;
    private byte _demoRunCount = 0;
    private long _drmStartDate = -1L;
    private int _maxDaysModeLimit = 1;
    private int _maxDaysModeSingleNagTime = 45000;
    private boolean _oneTimeNagDone = false;
    private boolean _initialized = false;
    private boolean _alive = false;
    private boolean _running = false;
    private boolean _supportAds = false;
    private boolean _nagMode = false;
    private boolean _isExpired = false;
    private long _lastFrameTime = 0L;
    private long _demoRunPeriod = 30000L;
    private long _maxRunModeLimit = 5L;
    private int _drmPurchaseMode = 100;
    private String _jadMIN = null;
    private String _currentMessage = null;
    private int _respCode = -2;
    private HttpConnection _connection = null;
    private DataInputStream iStream = null;
    private Image _oppLogo = null;
    private int _logoCtr = 0;
    public static final int LSK = -100;
    public static final int RSK = -102;
    public static final int BACK = -103;
    private Display _display = null;
    private Displayable _myAppDisplayable = null;
    private OPPDRMWrapper _myMidlet = null;
    private static OPPDRMFont _myFont = new OPPDRMFont("delicious_drm_font");
    private static OPPDRMTextInput inputMIN = null;
    private Thread _thread = null;
    private int _keyPressed = -999;
    public static String _oppWelcomeText = "Welcome to the OPP DRM!\n\nYour application is running in Demo Mode.  Please select Start to run the demo.";
    public static String _oppNagText = "We hope you are enjoying this Demo!\nSelect Resume to continue or Purchase to buy a full license version.";
    public static String _oppAd1Text = "Keep your eyes out for this new release!";
    public static String _oppPurchaseText = "Thank you for your interest in purchasing this application.  You will receive a text message shortly with a link to the full version.  Please select Exit to close this application.";
    public static String _oppDemoExpiredText = "Your Demo Trial has expired.  Please select Purchase for the full version.";

    public OPPDRMCanvas(boolean supportAds) {
        this._supportAds = supportAds;
        this._logoCtr = this.getHeight() >> 1;
        this.drmState = 501;
    }

    public void initialize(Display display, OPPDRMWrapper midlet) {
        this._alive = true;
        this._initialized = true;
        this._myMidlet = midlet;
        this._display = display;
        try {
            this._oppLogo = Image.createImage((String)"/oppdrm_logo.png");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.resetDisplay();
        this.startThread();
        String jadProp = this._myMidlet.getAppProperty("OPP-DRM-MODE");
        if (jadProp != null) {
            this._drmMode = Integer.parseInt(jadProp);
        }
        if (this._drmMode == 501) {
            System.out.println("OPP DRM Running in DRM_MAX_RUN_MODE.");
            jadProp = this._myMidlet.getAppProperty("OPP-DRM-MAX-RUN-MODE-LIMIT");
            if (jadProp != null) {
                this._maxRunModeLimit = Integer.parseInt(jadProp);
            }
        }
        if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-TIME")) != null) {
            this._demoRunPeriod = Integer.parseInt(jadProp);
        }
        if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-INTRO-TEXT")) != null) {
            _oppWelcomeText = jadProp;
        }
        if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-INTERRUPT-TEXT")) != null) {
            _oppNagText = jadProp;
        }
        int tempInit = 0;
        jadProp = this._myMidlet.getAppProperty("OPP-DRM-AD-SUPPORT");
        if (jadProp != null) {
            tempInit = Integer.parseInt(jadProp);
            this._supportAds = tempInit != 0;
        }
        if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-AD-TEXT")) != null) {
            _oppAd1Text = jadProp;
        }
        if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-PURCHASE-TEXT")) != null) {
            _oppPurchaseText = jadProp;
        }
        if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-EXPIRED-TEXT")) != null) {
            _oppDemoExpiredText = jadProp;
        }
        if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-PURCHASE-MODE")) != null) {
            this._drmPurchaseMode = Integer.parseInt(jadProp);
        }
        if ((jadProp = this._myMidlet.getAppProperty("User-MIN")) != null) {
            this._jadMIN = jadProp;
        }
        this.loadDRMState();
        if (this._drmMode == 502) {
            System.out.println("OPP DRM Running in DRM_MAX_DAYS_MODE.");
            jadProp = this._myMidlet.getAppProperty("OPP-DRM-MAX-DAYS-MODE-LIMIT");
            if (jadProp != null) {
                this._maxDaysModeLimit = Integer.parseInt(jadProp);
            }
            if ((jadProp = this._myMidlet.getAppProperty("OPP-DRM-MAX-DAYS-MODE-NAG-TIME")) != null) {
                this._maxDaysModeSingleNagTime = Integer.parseInt(jadProp);
            }
            System.out.println("OPP DRM One Time Nag = " + this._maxDaysModeSingleNagTime);
            if (this._drmStartDate == -1L) {
                this._drmStartDate = System.currentTimeMillis();
                this.saveDRMState();
            } else if (System.currentTimeMillis() > this._drmStartDate + (long)(this._maxDaysModeLimit * 86400000)) {
                this.drmState = 507;
                this._isExpired = true;
                this.saveDRMState();
            }
        }
        System.out.println("IsExpired: " + this._isExpired);
        System.out.println("DRM Count: " + this._demoRunCount);
        this.updateSoftKeys();
    }

    public void resetDisplay() {
        this._display.setCurrent((Displayable)this);
        this.setCommandListener(this);
    }

    public void startThread() {
        while (this._running) {
            this.killThread();
        }
        this._thread = new Thread(this);
        this._thread.start();
    }

    public void killThread() {
        this._alive = false;
        Thread.yield();
    }

    public void run() {
        this._running = true;
        this._oneTimeNagDone = false;
        while (this._alive) {
            try {
                if (System.currentTimeMillis() - this._lastFrameTime > 66L) {
                    this.repaint();
                    this.serviceRepaints();
                    this._lastFrameTime = System.currentTimeMillis();
                }
                if (this._keyPressed != -999) {
                    try {
                        this.processKeyPress(this._keyPressed);
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    this._keyPressed = -999;
                }
                try {
                    Thread.sleep(10L);
                    if (this.drmState != 506) continue;
                    if (this._drmMode == 502) {
                        if (!this._oneTimeNagDone) {
                            this._demoRunPeriod = this._maxDaysModeSingleNagTime;
                            this._oneTimeNagDone = true;
                        } else {
                            this._alive = false;
                            continue;
                        }
                    }
                    Thread.sleep(this._demoRunPeriod);
                    if (this._supportAds) {
                        this.drmState = this._nagMode ? 503 : 504;
                        this._nagMode = !this._nagMode;
                    } else {
                        this.drmState = 503;
                    }
                    if (this._drmMode == 501) {
                        System.out.println("OPP DRM Running in DRM_MAX_RUN_MODE.");
                        if ((long)this._demoRunCount >= this._maxRunModeLimit - 1L) {
                            this.drmState = 507;
                            this._isExpired = true;
                        } else {
                            this._demoRunCount = (byte)(this._demoRunCount + 1);
                        }
                        this.saveDRMState();
                    }
                    this._display = Display.getDisplay((MIDlet)this._myMidlet);
                    this._myAppDisplayable = this._display.getCurrent();
                    this._myMidlet.pauseApp();
                    this.resetDisplay();
                    this.updateSoftKeys();
                }
                catch (InterruptedException e3) {
                }
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
        }
        System.out.println("OPPDRM - Main thread exiting.");
        this._running = false;
    }

    public void paint(Graphics g2) {
        int yPos = 0;
        String _currentMessage = null;
        g2.setColor(255, 255, 255);
        g2.fillRect(0, yPos, this.getWidth(), this.getHeight());
        switch (this.drmState) {
            case 501: {
                _currentMessage = null;
                g2.setColor(255, 255, 255);
                g2.fillRect(0, this._logoCtr, this.getWidth(), this._oppLogo.getHeight());
                this._logoCtr -= 5;
                if (this._logoCtr > 2) {
                    this.renderDRMLogoScreen(g2, this._logoCtr);
                    break;
                }
                this.drmState = this._isExpired ? 507 : 502;
                this.updateSoftKeys();
                break;
            }
            case 502: {
                _currentMessage = _oppWelcomeText;
                break;
            }
            case 503: {
                _currentMessage = _oppNagText;
                break;
            }
            case 504: {
                this.renderDRMAdScreen(g2);
                break;
            }
            case 505: {
                _currentMessage = _oppPurchaseText;
                break;
            }
            case 507: {
                _currentMessage = _oppDemoExpiredText;
                break;
            }
            case 508: {
                _currentMessage = null;
                this.renderDRMUserMinEntry(g2);
            }
        }
        yPos += 2;
        if (this._oppLogo != null && this.drmState != 501) {
            g2.drawImage(this._oppLogo, this.getWidth() >> 1, yPos, 17);
        }
        yPos += this._oppLogo.getHeight();
        if (_currentMessage != null) {
            OPPDRMString tempString = new OPPDRMString(_currentMessage, _myFont, this);
            tempString.draw(g2, 5, yPos, 17);
        }
    }

    private void renderDRMAdScreen(Graphics g2) {
        int yPos = this._oppLogo.getHeight() + 2 + 10;
        Image tempAd = null;
        try {
            tempAd = Image.createImage((String)"/oppdrm_ad1.png");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (tempAd != null) {
            g2.drawImage(tempAd, this.getWidth() >> 1, yPos, 17);
        }
        OPPDRMString tempString = new OPPDRMString(_oppAd1Text, _myFont, this);
        tempString.draw(g2, 5, yPos += tempAd.getHeight(), 17);
    }

    private void renderDRMLogoScreen(Graphics g2, int logoLocation) {
        if (this._oppLogo != null) {
            g2.drawImage(this._oppLogo, this.getWidth() >> 1, logoLocation, 17);
        }
        try {
            if (logoLocation == this.getHeight() >> 1) {
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int renderDRMUserMinEntry(Graphics g2) {
        int localY = this._oppLogo.getHeight() + 2 + 10;
        OPPDRMString tempString = new OPPDRMString("Please enter your phone number:", _myFont, this);
        localY += tempString.draw(g2, 5, localY, 17) - 15;
        if (inputMIN != null) {
            localY += inputMIN.draw(g2, (this.getWidth() >> 1) - _myFont.stringWidth("A") * 5, localY);
        } else {
            inputMIN = new OPPDRMTextInput("", _myFont, 10, this);
        }
        if (inputMIN.getLength() == 10) {
            this.updateSoftKeys();
        } else {
            this.removeCommand(this.submitCmd);
        }
        return localY;
    }

    public void commandAction(Command cmd, Displayable arg1) {
        this._keyPressed = cmd.getCommandType() == 4 ? -100 : -102;
    }

    public void keyPressed(int keyCode) {
        if (this.drmState != 508) {
            return;
        }
        this._keyPressed = keyCode;
    }

    public void keyReleased(int keyCode) {
    }

    public void processKeyPress(int inputKeyCode) {
        switch (this.drmState) {
            case 502: {
                if (inputKeyCode == -100) {
                    this._myMidlet.startClientApp();
                    if (this._myAppDisplayable == null) break;
                    this._display.setCurrent(this._myAppDisplayable);
                    break;
                }
                if (inputKeyCode != -102) break;
                this._myMidlet.destroyApp(true);
                break;
            }
            case 503: {
                if (inputKeyCode == -100) {
                    this._myMidlet.startClientApp();
                    if (this._myAppDisplayable == null) break;
                    this._display.setCurrent(this._myAppDisplayable);
                    break;
                }
                if (inputKeyCode != -102) break;
                this.doDRMPruchase();
                break;
            }
            case 504: {
                if (inputKeyCode != -100) break;
                this._myMidlet.startClientApp();
                break;
            }
            case 505: {
                if (inputKeyCode != -100) break;
                this._myMidlet.destroyApp(true);
                break;
            }
            case 508: {
                inputMIN.keyPressed(inputKeyCode);
                if (inputKeyCode != -100) break;
                this.executePurchase_DLAPIStyle(inputMIN.getValue());
                break;
            }
            case 507: {
                if (inputKeyCode == -100) {
                    System.out.println("Selected to purchase!");
                    this.doDRMPruchase();
                    break;
                }
                if (inputKeyCode != -102) break;
                this._myMidlet.destroyApp(true);
            }
        }
    }

    private void updateSoftKeys() {
        this.clearCmds();
        switch (this.drmState) {
            case 502: {
                this.addCommand(this.startCmd);
                this.addCommand(this.exitCmd);
                break;
            }
            case 503: {
                this.addCommand(this.resumeCmd);
                this.addCommand(this.purchaseCmd);
                break;
            }
            case 504: {
                this.addCommand(this.resumeCmd);
                break;
            }
            case 505: {
                this.addCommand(this.exitCmd);
                break;
            }
            case 508: {
                this.addCommand(this.submitCmd);
                break;
            }
            case 507: {
                this.addCommand(this.buyCmd);
                this.addCommand(this.exitCmd);
            }
        }
    }

    private void clearCmds() {
        try {
            this.removeCommand(this.startCmd);
            Thread.yield();
            this.removeCommand(this.exitCmd);
            Thread.yield();
            this.removeCommand(this.resumeCmd);
            Thread.yield();
            this.removeCommand(this.purchaseCmd);
            Thread.yield();
            this.removeCommand(this.submitCmd);
            Thread.yield();
            this.removeCommand(this.purchaseCmd);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void doDRMPruchase() {
        if (this._drmPurchaseMode == 102) {
            this.executePurchase_WAPStyle();
        } else if (!this.executePurchase_MOStyle()) {
            if (this._jadMIN != null) {
                this.executePurchase_DLAPIStyle(this._jadMIN);
            } else {
                this.drmState = 508;
                this.clearCmds();
            }
        } else {
            this.drmState = 505;
            this.updateSoftKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean executePurchase_MOStyle() {
        void var3_3;
        String offDeckTxtAddy = "sms://32852";
        String offDeckTxtBody = this._myMidlet.getAppProperty("OPP-OffDeck-Request");
        boolean status = false;
        MessageConnection rConn = null;
        try {
            rConn = (MessageConnection)Connector.open((String)"sms://32852");
            if (rConn != null) {
                TextMessage rMsg = (TextMessage)rConn.newMessage("text");
                rMsg.setPayloadText(offDeckTxtBody);
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            status = false;
        }
        finally {
            if (rConn != null) {
                try {
                    rConn.close();
                }
                catch (Throwable e3) {
                    status = false;
                }
            }
        }
        return (boolean)var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePurchase_DLAPIStyle(String userMIN) {
        String deepLink1 = this._myMidlet.getAppProperty("OPP-OffDeck-DLAPI-1");
        String deepLink2 = this._myMidlet.getAppProperty("OPP-OffDeck-DLAPI-2");
        String deepURL = deepLink1 + userMIN + deepLink2;
        try {
            System.out.println("Sending DLAPI : " + deepURL);
            this._connection = (HttpConnection)Connector.open((String)deepURL);
            this.drmState = 505;
            this.updateSoftKeys();
            if (this._connection != null) {
                this.iStream = this._connection.openDataInputStream();
                this._respCode = this._connection.getResponseCode();
            }
            if (this._connection != null) {
                this._connection.close();
            }
            this._connection = null;
        }
        catch (SecurityException securityException) {
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (this._connection != null) {
                    this._connection.close();
                }
                this._connection = null;
                if (this.iStream != null) {
                    this.iStream.close();
                }
                this.iStream = null;
            }
            catch (Exception e1) {
                this._connection = null;
                this.iStream = null;
            }
        }
    }

    public void executePurchase_WAPStyle() {
        String wapPurchaseLink = this._myMidlet.getAppProperty("Wap-Purchase-Link");
        if (wapPurchaseLink != null) {
            try {
                this._myMidlet.platformRequest(wapPurchaseLink);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._myMidlet.destroyApp(true);
    }

    public void setState(int nextState) {
        this.drmState = nextState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDRMState() {
        RecordStore rs = null;
        FilterOutputStream dos = null;
        ByteArrayOutputStream bos = null;
        RecordEnumeration en = null;
        try {
            System.out.println("OPPDRMCanvas: Saving DRM State.");
            rs = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)true);
            if (rs != null) {
                bos = new ByteArrayOutputStream();
                dos = new DataOutputStream(bos);
                ((DataOutputStream)dos).writeBoolean(this._isExpired);
                ((DataOutputStream)dos).writeByte(this._demoRunCount);
                ((DataOutputStream)dos).writeLong(this._drmStartDate);
                if (rs.getNumRecords() <= 0) {
                    rs.addRecord(bos.toByteArray(), 0, bos.toByteArray().length);
                } else {
                    int id = 0;
                    en = rs.enumerateRecords(null, null, false);
                    id = en.nextRecordId();
                    rs.setRecord(id, bos.toByteArray(), 0, bos.toByteArray().length);
                    if (en != null) {
                        en.destroy();
                    }
                    en = null;
                }
                if (bos != null) {
                    bos.close();
                }
                bos = null;
                if (dos != null) {
                    dos.close();
                }
                dos = null;
                rs.closeRecordStore();
                rs = null;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                if (en != null) {
                    en.destroy();
                }
                en = null;
            }
            catch (Exception e3) {
                en = null;
            }
            try {
                if (dos != null) {
                    dos.close();
                }
                dos = null;
            }
            catch (Exception e4) {
                dos = null;
            }
            try {
                if (bos != null) {
                    bos.close();
                }
                bos = null;
            }
            catch (Exception e5) {
                bos = null;
            }
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
                rs = null;
            }
            catch (Exception e6) {
                rs = null;
                e6.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDRMState() {
        RecordStore rs = null;
        FilterInputStream dis = null;
        ByteArrayInputStream bis = null;
        RecordEnumeration en = null;
        try {
            rs = RecordStore.openRecordStore((String)RECORDSTORE_NAME, (boolean)false);
            if (rs != null) {
                byte[] tmpByte = null;
                en = rs.enumerateRecords(null, null, false);
                if (en != null) {
                    tmpByte = en.nextRecord();
                }
                if (tmpByte != null && tmpByte.length > 0) {
                    bis = new ByteArrayInputStream(tmpByte);
                    dis = new DataInputStream(bis);
                    this._isExpired = ((DataInputStream)dis).readBoolean();
                    this._demoRunCount = ((DataInputStream)dis).readByte();
                    this._drmStartDate = ((DataInputStream)dis).readLong();
                }
                if (en != null) {
                    en.destroy();
                }
                en = null;
                if (dis != null) {
                    dis.close();
                }
                dis = null;
                if (bis != null) {
                    bis.close();
                }
                bis = null;
                rs.closeRecordStore();
                rs = null;
            } else {
                System.out.println("OPPDRMCanvas: RecordStore does not exist, it's our 1st time");
            }
        }
        catch (Exception e2) {
            System.out.println("OPPDRMCanvas: Exception while loading data from recordstore: " + e2.getMessage());
        }
        finally {
            try {
                if (en != null) {
                    en.destroy();
                }
                en = null;
            }
            catch (Exception e3) {
                en = null;
            }
            try {
                if (dis != null) {
                    dis.close();
                }
                dis = null;
            }
            catch (Exception e4) {
                dis = null;
            }
            try {
                if (bis != null) {
                    bis.close();
                }
                bis = null;
            }
            catch (Exception e5) {
                bis = null;
            }
            try {
                if (rs != null) {
                    rs.closeRecordStore();
                }
                rs = null;
            }
            catch (Exception e6) {
                rs = null;
            }
        }
    }
}

