/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class OPPDRMTextInput
implements OPPDRMConstants {
    private int _style = 0;
    private long _lastBlink = 0L;
    int _keyPressed = -999;
    int _position = 0;
    long _lastTouched = 0L;
    int _width = 30;
    int _initialWidth = 30;
    int _styleWidth = 30;
    OPPDRMFont _myFont = null;
    OPPDRMCanvas _myCanvas = null;
    int _height = 0;
    int _max = 99;
    StringBuffer _text = new StringBuffer();
    boolean _blink = false;
    boolean _selected = false;
    String[][] _charactersNumeric = new String[][]{{"0"}, {"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}, {"7"}, {"8"}, {"9"}, {""}, {""}};
    String[][] _charactersAlpha = null;
    String[][] _charactersAlphaNumeric = null;
    String[][] _characters = null;

    public OPPDRMTextInput(String text, OPPDRMFont font, int max, OPPDRMCanvas screen) {
        this._myFont = font;
        this._myCanvas = screen;
        this.initTextControl(text, 64, max);
    }

    private void initTextControl(String text, int style, int max) {
        this._text = new StringBuffer(text);
        this._style = style;
        if ((style & 0x80) != 0) {
            this._characters = this._charactersAlpha;
        } else if ((style & 0x100) != 0) {
            this._characters = this._charactersAlphaNumeric;
        } else if ((style & 0x40) != 0) {
            this._characters = this._charactersNumeric;
        }
        this._width = this._myFont.stringWidth("A") * 10;
        this._height = this._myFont.getHeight() + 5;
        this._max = max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int draw(Graphics g2, int x, int y) {
        StringBuffer stringBuffer = this._text;
        synchronized (stringBuffer) {
            g2.setColor(0xFFFFFF);
            g2.fillRect(x, y, this._width + 2, this._height);
            g2.setColor(0x333333);
            g2.drawRoundRect(x, y, this._width + 2, this._height, 5, 5);
            g2.drawRoundRect(x - 1, y, this._width + 2 + 2, this._height, 5, 5);
            x += 3;
            StringBuffer text = new StringBuffer();
            if (this._myFont.stringWidth(this._text.toString()) + 3 > this._width) {
                for (int i = this._text.length() - 1; i >= 0; --i) {
                    if (this._myFont.stringWidth(this._text.toString().substring(i)) + 3 >= this._width) {
                        text.reverse();
                        break;
                    }
                    text.append(this._text.toString().charAt(i));
                }
            } else {
                text.append((Object)this._text);
            }
            if (this._lastBlink + 500L < System.currentTimeMillis()) {
                this._lastBlink = System.currentTimeMillis();
                boolean bl = this._blink = !this._blink;
            }
            if (this._blink) {
                g2.setColor(0, 0, 0);
                if (this._keyPressed != -999) {
                    g2.fillRect(x + this._myFont.stringWidth(text.toString().substring(0, text.length() - 1)), y + 1, this._myFont.stringWidth(text.toString().substring(text.length() - 1)), this._myFont.getHeight() - 1);
                } else {
                    g2.fillRect(x + this._myFont.stringWidth(text.toString()), y + 3, 5, this._myFont.getHeight() - 1);
                }
            }
            if (this._keyPressed != -999 && this._lastTouched + 3000L < System.currentTimeMillis()) {
                this._keyPressed = -999;
                this._lastTouched = 0L;
                this._position = 0;
            }
            g2.setColor(0);
            this._myFont.drawString(text.toString(), x, y += 3, 20, g2);
        }
        return y += this._height;
    }

    public boolean keyPressed(int keyCode) {
        block10: {
            block12: {
                block11: {
                    System.out.println("Just got " + keyCode + " here in TextCtl");
                    if (keyCode > 47 && keyCode < 58) break block10;
                    keyCode = this._myCanvas.getGameAction(keyCode);
                    if (keyCode == 2) break block11;
                    if (keyCode != -103) break block12;
                }
                if (this._text.length() > 0) {
                    this._text.deleteCharAt(this._text.length() - 1);
                    this._keyPressed = -999;
                    this._lastTouched = 0L;
                    this._position = 0;
                }
                return true;
            }
            return true;
        }
        if (this._keyPressed == (keyCode -= 48) && this._characters[keyCode].length != 1) {
            this._text.deleteCharAt(this._text.length() - 1);
            this._text.append(this._characters[keyCode][this._position++]);
            if (this._position >= this._characters[keyCode].length) {
                this._position = 0;
            }
            this._lastTouched = System.currentTimeMillis();
        } else if (this._text.length() < this._max) {
            this._position = 0;
            this._keyPressed = keyCode;
            this._text.append(this._characters[keyCode][this._position++]);
            this._lastTouched = System.currentTimeMillis();
            if (this._position >= this._characters[keyCode].length) {
                this._position = 0;
            }
        }
        if ((this._style & 0x40) != 0) {
            this._keyPressed = -999;
            this._lastTouched = 0L;
            this._position = 0;
        }
        return true;
    }

    public String getValue() {
        return this._text.toString();
    }

    public int getLength() {
        return this._text.length();
    }
}

