/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.fifa.services.parser.sax.handler;

import com.sonyericsson.fifa.data.feed.Enclosure;
import com.sonyericsson.fifa.data.feed.Feed;
import com.sonyericsson.fifa.data.feed.FeedItem;
import com.sonyericsson.fifa.services.parser.sax.contentprovider.FeedContentProvider;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssInvalidFormatException;
import com.sonyericsson.fifa.services.parser.sax.exceptions.RssItemsParsedException;
import com.sonyericsson.fifa.utils.SystemProperties;
import java.util.Calendar;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RssHandler
extends DefaultHandler
implements FeedContentProvider {
    private static final String RSS_TAG = "rss";
    private static final String RSS_CHANNEL = "channel";
    private static final String RSS_TIMETOLIVE = "ttl";
    private static final String RSS_ITEM = "item";
    private static final String ITEM_TITLE = "title";
    private static final String ITEM_DESCRIPTION = "description";
    private static final String ITEM_ENCLOSURE_NAME = "enclosure";
    private static final String ENCLOSURE_URL = "url";
    private static final String ENCLOSURE_MIME_TYPE = "type";
    private static final String ITEM_PUB_DATE = "pubDate";
    private Feed feed = null;
    private Enclosure currentEnclosure = null;
    private FeedItem currentItem = null;
    private String currentElementName;
    private String lastBuildDate;
    private String lastItemPubDate;
    private String tempLastItemPubDate;
    private boolean rssStartedCorrectly = false;
    private boolean channelFound = false;
    private boolean itemFound = false;
    private boolean enclosureFound = false;
    private int itemsToParse = 0;

    public void startElement(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        this.currentElementName = tagName;
        if (!this.rssStartedCorrectly) {
            if (RSS_TAG.equalsIgnoreCase(this.currentElementName)) {
                this.rssStartedCorrectly = true;
                this.feed = new Feed();
            } else {
                throw new RssInvalidFormatException();
            }
        }
        if (this.rssStartedCorrectly && !this.channelFound && RSS_CHANNEL.equalsIgnoreCase(this.currentElementName)) {
            this.channelFound = true;
        }
        if (this.channelFound && !this.itemFound && RSS_ITEM.equalsIgnoreCase(this.currentElementName)) {
            this.itemFound = true;
            this.parseItem();
        }
        if (this.itemFound && !this.enclosureFound && ITEM_ENCLOSURE_NAME.equalsIgnoreCase(this.currentElementName)) {
            this.parseItemEnclosure(resourceId, localName, tagName, attributes);
        }
    }

    private void parseItem() {
        this.currentItem = new FeedItem();
    }

    public void characters(char[] text, int startingIndex, int textLength) throws SAXException {
        String content = new String(text, startingIndex, textLength).trim();
        if (content.length() > 0) {
            if (RSS_TIMETOLIVE.equalsIgnoreCase(this.currentElementName)) {
                this.feed.setTimeToLive(Integer.parseInt(content));
            } else if (this.currentItem != null && this.currentElementName != null) {
                if (ITEM_TITLE.equalsIgnoreCase(this.currentElementName)) {
                    this.currentItem.setTitle(content);
                } else if (ITEM_DESCRIPTION.equalsIgnoreCase(this.currentElementName)) {
                    this.currentItem.setDescription(content);
                } else if (ITEM_PUB_DATE.equalsIgnoreCase(this.currentElementName)) {
                    if (this.lastItemPubDate == null) {
                        if (this.feed.getItems().size() == 0) {
                            this.tempLastItemPubDate = content;
                        }
                    } else {
                        Calendar currentItemPubDate = SystemProperties.getTimeCalendar(this.lastItemPubDate);
                        Calendar nextLastItemPubDate = SystemProperties.getTimeCalendar(content);
                        if (currentItemPubDate != null && nextLastItemPubDate != null) {
                            if (!this.lastItemPubDate.equals(content) && SystemProperties.compareCalendar(currentItemPubDate, nextLastItemPubDate) > 0) {
                                if (this.feed.getItems().size() == 0) {
                                    this.tempLastItemPubDate = content;
                                }
                            } else {
                                throw new RssItemsParsedException();
                            }
                        }
                    }
                }
            }
        }
    }

    public void endElement(String resourceId, String localName, String qName) throws SAXException {
        if (this.currentElementName != null) {
            if (ITEM_ENCLOSURE_NAME.equalsIgnoreCase(qName)) {
                this.currentItem.setEnclosure(this.currentEnclosure);
            } else if (RSS_ITEM.equalsIgnoreCase(qName)) {
                this.feed.addItem(this.currentItem);
                this.itemFound = false;
                this.enclosureFound = false;
                if (this.itemsToParse != 0 && this.feed.getItems().size() >= this.itemsToParse) {
                    throw new RssItemsParsedException();
                }
            }
        }
    }

    public void endDocument() throws SAXException {
        int numberOfItems;
        if (this.feed != null && (numberOfItems = this.feed.getItems().size()) > 0) {
            int itemsIndex = 0;
            while (itemsIndex < numberOfItems) {
                if (this.feed.getItems().elementAt(itemsIndex) == null) {
                    throw new SAXException("RSS bad format");
                }
                this.rssStartedCorrectly = false;
                this.channelFound = false;
                ++itemsIndex;
            }
            if (this.tempLastItemPubDate != null) {
                this.lastItemPubDate = this.tempLastItemPubDate;
                this.feed.setLastItemPubDate(this.lastItemPubDate);
            }
        }
    }

    private void parseItemEnclosure(String resourceId, String localName, String tagName, Attributes attributes) throws SAXException {
        this.currentEnclosure = new Enclosure();
        int numberOfAttributes = attributes.getLength();
        int i = 0;
        while (i < numberOfAttributes) {
            if (ENCLOSURE_URL.equalsIgnoreCase(attributes.getQName(i))) {
                String url = attributes.getValue(i);
                this.currentEnclosure.setUrl(url);
            } else if (ENCLOSURE_MIME_TYPE.equalsIgnoreCase(attributes.getQName(i))) {
                this.currentEnclosure.setMimeType(attributes.getValue(i));
            }
            ++i;
        }
    }

    public Feed getParsedFeed() {
        return this.feed;
    }

    public void setItemsToParse(int numberOfItems) {
        this.itemsToParse = numberOfItems;
    }

    public String getLastBuildDate() {
        return this.lastBuildDate;
    }

    public String getLastItemPubDate() {
        return this.lastItemPubDate;
    }

    public void setLastBuildDate(String lastBuildDate) {
        this.lastBuildDate = lastBuildDate;
    }

    public void setLastItemPubDate(String lastItemPubDate) {
        this.lastItemPubDate = lastItemPubDate;
    }
}

