#!/system/bin/sh
echo "ondemand" > /sys/devices/system/cpu/cpu0/cpufreq/scaling_governor
echo 90 > /sys/devices/system/cpu/cpu0/cpufreq/ondemand/up_threshold
echo 30 > /sys/devices/system/cpu/cpu0/cpufreq/ondemand/down_differential
echo 500000 > /sys/devices/system/cpu/cpu0/cpufreq/ondemand/sampling_rate
echo 122880 > /sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq
echo 600000 > /sys/devices/system/cpu/cpu0/cpufreq/scaling_max_freq

# Needed by radio
mkdir /data/radio
chmod 0777 /data/radio
chmod 0777 /dev/oncrpc
chmod 0777 /dev/oncrpc/*

# Symlinking /sdcard to /mnt/sdcard for compatibility
rmdir /sdcard
ln -s /mnt/sdcard /sdcard

# Symlinks for compass
ln -s /dev/akm8973_aot /dev/akm8975_aot
ln -s /dev/akm8973_daemon /dev/akm8975_daemon

chmod 0777 /data/local/tmp/

# App installing bug fix by Raikun
chown system:system /data/app
chmod 771 /data/app

# RAM Optimizations [script by Juwe11], improved by D4rKn3sSyS & Chumby_666

L="log -p i -t Ramdisk"
$L "d4: Starting RAM Optimization Script ...";
if [ -e /sys/module/lowmemorykiller/parameters/minfree ]; then
	echo "2048,3072,4096,6144,7168,8192" > /sys/module/lowmemorykiller/parameters/minfree
	$L "Optimizing LowMemoryKiller MINFREE ...";
fi

if [ -e /sys/module/lowmemorykiller/parameters/adj ]; then
	echo "0,1,2,4,8,16" > /sys/module/lowmemorykiller/parameters/adj
	$L "Optimizing LowMemoryKiller ADJ ...";
fi
if [ -e /proc/sys/vm/swappiness ]; then
	echo "32" > /proc/sys/vm/swappiness
	$L "Optimizing VM Swappiness ...";
fi

if [ -e /proc/sys/vm/vfs_cache_pressure ]; then
	echo "64" > /proc/sys/vm/vfs_cache_pressure
	$L "Optimizing VM vfs cache pressure...";
fi

if [ -e /proc/sys/vm/dirty_expire_centisecs ]; then
	echo "512" > /proc/sys/vm/dirty_expire_centisecs
	$L "Optimizing VM Dirty Expire Centisecs ...";
fi

if [ -e /proc/sys/vm/dirty_writeback_centisecs ]; then
	echo "1000" > /proc/sys/vm/dirty_writeback_centisecs
	$L "Optimizing VM Dirty Writeback Centisecs ...";
fi

if [ -e /proc/sys/vm/dirty_ratio ]; then
	echo "5" > /proc/sys/vm/dirty_ratio
	$L "Optimizing VM Dirty Ratio ...";
fi

if [ -e /proc/sys/vm/dirty_background_ratio ]; then
	echo "4" > /proc/sys/vm/dirty_background_ratio
	$L "Optimizing VM Dirty Background Ratio ...";
fi

if [ -e /proc/sys/vm/min_free_order_shift ]; then
	echo "6" > /proc/sys/vm/min_free_order_shift
	$L "Optimizing VM Min Free Order Shift ...";
fi
$L "d4: RAM Sucesfully Optimized, enjoy!";
