#!/sbin/sh
# Script for booting the /system/bin/multiboot_default option
# author: nobodyAtall @ xda 

SYSTEM=$(cat /etc/fstab |grep /system |awk {'print $1'})
SYSTEM_MOUNT=/tmp/system

mkdir $SYSTEM_MOUNT
mount $SYSTEM $SYSTEM_MOUNT
mount /sdcard/
if [ -h $SYSTEM_MOUNT/bin/multiboot_default ]
then
	umount /system
	umount /data
	umount /cache
	losetup /dev/block/loop1 $SYSTEM_MOUNT/bin/multiboot_default/system.img
	losetup /dev/block/loop2 $SYSTEM_MOUNT/bin/multiboot_default/data.img
	losetup /dev/block/loop3 $SYSTEM_MOUNT/bin/multiboot_default/cache.img
	if [ -f /sbin/e2fsck ]
	then
		/sbin/e2fsck -y /dev/block/loop1
		/sbin/e2fsck -y /dev/block/loop2
		/sbin/e2fsck -y /dev/block/loop3
	fi
	mount -t ext2 -o rw,noatime,nodiratime /dev/block/loop1 /system
	mount -t ext2 -o rw,noatime,nodiratime /dev/block/loop2 /data
	mount -t ext2 -o rw,noatime,nodiratime /dev/block/loop3 /cache
	# Handle the ramdisk / kernel
	if [ -f $SYSTEM_MOUNT/bin/multiboot_default/boot.img ]
	then
		mkdir /tmp/boot
		cp $SYSTEM_MOUNT/bin/multiboot_default/boot.img /tmp/boot/
		cd /tmp/boot/
		rm -rf ramdisk initrd.img
		abootimg -x boot.img
		mkdir ramdisk
		mv initrd.img initrd.cpio.gz
		cd ramdisk
		gunzip -c ../initrd.cpio.gz | cpio -i
		sed -i -e 's/\(mount yaffs2 mtd@\)/\# \1/' -e 's/on fs/on fs\n\tmkdir \/data\/multiboot/' init.rc
		rm -rf /init.*
		cp -pr * /
	elif [ -f $SYSTEM_MOUNT/bin/multiboot_default/ramdisk.tar ]
	then
		mkdir /tmp/boot
		cp $SYSTEM_MOUNT/bin/multiboot_default/ramdisk.tar /tmp/boot/
		cd /tmp/boot/
		rm -rf ramdisk
		mkdir ramdisk
		cd ramdisk
		tar -xf ../ramdisk.tar
		sed -i -e 's/\(mount yaffs2 mtd@\)/\# \1/' -e 's/on fs/on fs\n\tmkdir \/data\/multiboot/' init.rc
		rm -rf /init.*
		cp -pr * /
		chmod 0777 /dev -R
		chown 0.2000 /dev/oncrpc -R
	else
		rm -rf /init.*
		cp -pr /sdcard/ramdisk/* /
	fi
	umount $SYSTEM_MOUNT
	#rm -r /etc /sbin/sh
	#pkill adbd
	chroot / /init
fi

