@echo off

:MAIN
	CLS
	TITLE Kovsky ROM Kitchen -- Main Menu
	echo Kovsky ROM Kitchen -- Main Menu
	echo -------------------------------
	echo.
	echo (e) extract a rom
	echo (c) cook a rom 
	echo (f) flash a rom 
	echo (cf) cook and flash a rom
	echo (p) create a oem package (Only CABs without Setup.DLL)
	echo (w) windiff (compare files/directories)
	echo -------------------------------
	echo Adapted for the Sony Xperia By
	echo D Clarke. Thank you to those
	echo originally developed the
	echo kitchen and kept development
	echo going!
	echo.
	
	if "%VERBOSE%" EQU "TRUE" echo (v) verbose mode *OFF* -- too much info, show me less!
	IF "%VERBOSE%" NEQ "TRUE" echo (v) verbose mode *ON* -- show me more info!
	
	echo (m) more options
	echo (x) exit
	:CHOICE1
		SET CHOICE1=
		set /p CHOICE1="Please choose e, c, f, cf, p, w, b, v, m or x: "
		IF "%CHOICE1%" NEQ "cf" IF "%CHOICE1%" NEQ "CF" IF "%CHOICE1%" NEQ "b" IF "%CHOICE1%" NEQ "B" IF "%CHOICE1%" NEQ "w" IF "%CHOICE1%" NEQ "W" IF "%CHOICE1%" NEQ "P" IF "%CHOICE1%" NEQ "p" IF "%CHOICE1%" NEQ "v" IF "%CHOICE1%" NEQ "V" IF "%CHOICE1%" NEQ "m" IF "%CHOICE1%" NEQ "M" IF "%CHOICE1%" NEQ "x" IF "%CHOICE1%" NEQ "X" IF "%CHOICE1%" NEQ "e" IF "%CHOICE1%" NEQ "E" IF "%CHOICE1%" NEQ "c" IF "%CHOICE1%" NEQ "C" IF "%CHOICE1%" NEQ "f" IF "%CHOICE1%" NEQ "F" GOTO :CHOICE1
	GOTO :%CHOICE1%

:V
:VERBOSE
	CLS
	IF "%VERBOSE%" EQU "TRUE" ( 
		SET VERBOSE= 
	) ELSE (
		SET VERBOSE=TRUE
	)
GOTO :MAIN

:P
:PackageCreator
	"tools\packages creator 5.4.exe"
GOTO :MAIN

:W
:WinDiff
	"tools\windiff.exe"
GOTO :MAIN


:E
:EXTRACT
	CLS
	TITLE Kovsky ROM Kitchen -- Extraction Menu
	echo Kovsky ROM Kitchen -- Extraction Menu
	echo -------------------------------------
	echo. 
	echo (a) if you want just to extract a shipped ROM
	echo    (RUU_signed.nbh required in BaseROM folder)
	echo (b) if you want to rebuild and cook dumped ROM into flashable ROM
	echo    (RUU_signed.nbh, dumped part01.raw and part02.raw required in BaseROM folder)
	echo (m) back to the main menu
	echo (x) exit

	:E_CHOICE
		SET E_CHOICE=
		set /P E_CHOICE="Please choose a, b, m or x: "
		IF "%E_CHOICE%" NEQ "x" "%E_CHOICE%" NEQ "X" "%E_CHOICE%" NEQ "m" IF "%E_CHOICE%" NEQ "M" IF "%E_CHOICE%" NEQ "a" IF "%E_CHOICE%" NEQ "b" IF "%E_CHOICE%" NEQ "A" IF "%E_CHOICE%" NEQ "B" GOTO :E_CHOICE

	IF "%E_CHOICE%" EQU "M" GOTO :MAIN
	IF "%E_CHOICE%" EQU "m" GOTO :MAIN
	IF "%E_CHOICE%" EQU "X" GOTO :EOF
	IF "%E_CHOICE%" EQU "x" GOTO :EOF

	SET TITLE=EXTRACT - 
	call :runme :11.cleanup.bat
	call :runme :1%E_CHOICE%.ExtractNBHContent.cmd
	call :runme :2%E_CHOICE%.ExtractDumpIMGFS.cmd
	call :runme :3%E_CHOICE%.ExtractDumpXIP.cmd
	call :runme :4.CopyROMXIP.cmd
	call :runme :5.PKGTool.cmd
	call :runme :6.MoveOEMSYS.cmd
	call :runme :7.DeleteBoot.cmd

	echo Now start cooking your ROM!
	pause

GOTO :MAIN


:C
:CF
:COOKING
:COOKING_AND_FLASH
	CLS
	TITLE Kovsky ROM Kitchen -- Cooking Menu
	echo Kovsky ROM Kitchen -- Cooking Menu
	echo -------------------------------------
	echo. 
	echo (a) if you want to use the old BuildOS.exe
	echo (b) if you want to use the new BuildOS+Package_Tools-2.7.exe
	echo (m) back to the main menu
	echo (x) exit


	:C_CHOICE
		SET C_CHOICE=
		set /P C_CHOICE="Please choose a, b, m or x: "
		IF "%C_CHOICE%" NEQ "x" "%C_CHOICE%" NEQ "X" "%C_CHOICE%" NEQ "m" IF "%C_CHOICE%" NEQ "M" IF "%C_CHOICE%" NEQ "a" IF "%C_CHOICE%" NEQ "b" IF "%C_CHOICE%" NEQ "A" IF "%C_CHOICE%" NEQ "B" GOTO :C_CHOICE

	IF "%C_CHOICE%" EQU "M" GOTO :MAIN
	IF "%C_CHOICE%" EQU "m" GOTO :MAIN
	IF "%C_CHOICE%" EQU "X" GOTO :EOF
	IF "%C_CHOICE%" EQU "x" GOTO :EOF

	CLS
	SET TITLE=COOKING - 
	call :runme :8%C_CHOICE%.BuildOS.cmd
	call :runme :9.CreateROMKovsky.bat
	call :runme :10.HTCRomTool.bat
	call :runme :12.PagePool.Changer.bat
	call :runme :11.Cleanup.bat
	IF "%CHOICE1%" NEQ "CF" IF "%CHOICE1%" NEQ "cf" (
	echo Now flash your ROM!
	pause
	) else (
	goto :flashing
	)
GOTO :MAIN


:F
:Flashing
	KovskyRUU.exe
GOTO :MAIN

:M
:More_Options
	CLS
	TITLE Kovsky ROM Kitchen -- More Options Menu
	echo Kovsky ROM Kitchen -- More Options Menu
	echo ---------------------------------------
	echo Requires RUU_signed.nbh in BaseROM folder
	echo (1a) Extract NBH Content from shipped ROM
	echo (2a) Extract IMGFS from shipped ROM
	echo (3a) Extract XIP from shipped ROM
	echo.
	echo Requires RUU_signed.nbh, dumped part01.raw and part02.raw in BaseROM folder
	echo (1b) Extract NBH Content from cooked ROM
	echo (2b) Extract IMGFS from cooked ROM
	echo (3b) Extract XIP from cooked ROM
	echo.
	echo (4) Copy ROM XIP
	echo (5) PKGTool
	echo (6) Move OEM and SYS
	echo (7) Delete Boot
	echo (8a) BuildOS
	echo (8b) BuildOS+Package_Tools-2.7
	echo (9) Create Kovsky ROM
	echo (10) HTC ROM Tool
	echo (11) Clean Up Temp files
	echo (12) PagePool Changer
	echo.
	echo (m) back to main menu
	echo (x) exit

	:M_CHOICE
		SET M_CHOICE=
		set /P M_CHOICE="Please choose 1a, 2a, 3a, 1b, 2b, 3b, 4, 5, 6, 7, 8a, 8b, 9, 10, 11, 12 or m: "
		IF "%M_CHOICE%" NEQ "x" "%M_CHOICE%" NEQ "X" "%M_CHOICE%" NEQ "m" IF "%M_CHOICE%" NEQ "M" IF "%M_CHOICE%" NEQ "1a" IF "%M_CHOICE%" NEQ "1A" IF "%M_CHOICE%" NEQ "1b" IF "%M_CHOICE%" NEQ "1B" IF "%M_CHOICE%" NEQ "2a" IF "%M_CHOICE%" NEQ "2A" IF "%M_CHOICE%" NEQ "2b" IF "%M_CHOICE%" NEQ "2B" IF "%M_CHOICE%" NEQ "3a" IF "%M_CHOICE%" NEQ "3A" IF "%M_CHOICE%" NEQ "3b" IF "%M_CHOICE%" NEQ "3B" IF "%M_CHOICE%" NEQ "4" IF "%M_CHOICE%" NEQ "5" IF "%M_CHOICE%" NEQ "6" IF "%M_CHOICE%" NEQ "7" IF "%M_CHOICE%" NEQ "8a" IF "%M_CHOICE%" NEQ "8A" IF "%M_CHOICE%" NEQ "8b" IF "%M_CHOICE%" NEQ "8B" IF "%M_CHOICE%" NEQ "9" IF "%M_CHOICE%" NEQ "10" IF "%M_CHOICE%" NEQ "11" IF "%M_CHOICE%" NEQ "12" GOTO :M_CHOICE

	IF "%M_CHOICE%" EQU "M" GOTO :MAIN
	IF "%M_CHOICE%" EQU "m" GOTO :MAIN
	IF "%M_CHOICE%" EQU "X" GOTO :EOF
	IF "%M_CHOICE%" EQU "x" GOTO :EOF

	CALL :RUNME :%M_CHOICE%
GOTO :MAIN


:X
	exit /b
GOTO :EOF


:runme
	CLS
	title %TITLE% %1
	if "%VERBOSE%" EQU "TRUE" echo on
	call %1
	echo off
	IF "%VERBOSE%" EQU "TRUE" ( 
	pause
	) else (
	sleep 3 
	)
GOTO :EOF

:1a
:1a.ExtractNBHContent.cmd
	pushd BaseROM
	..\Tools\NBHextract.exe RUU_signed.nbh

	popd
	MD Temp
	ren BaseROM\*OS.nb OS.NB
	Copy BaseROM\OS.nb Temp\OS.NB
GOTO :EOF

:1b
:1b.ExtractNBHContent.cmd
	pushd BaseROM
	..\Tools\NBHextract.exe RUU_signed.nbh
	ren *OS.nb OS.NB
	popd
	MD Temp
	pushd Temp
	Copy ..\BaseROM\OS.NB
	copy ..\BaseROM\part01.raw 
	Copy ..\BaseROM\part02.raw
	ren part01.raw xip.bin
	ren part02.raw imgfs.bin
	popd
GOTO :EOF

:2a
:2a.ExtractDumpIMGFS.cmd
	echo Please wait for this script to finish after you see "Done!".
	echo Don't close it, but press enter to continue!
	echo ------------------------------------------------------------
	pushd Temp
	..\Tools\NBSplit.exe -kaiser OS.NB
	..\Tools\ImgfsFromNb.exe OS.NB.Payload imgfs.bin
	..\Tools\ImgfsToDump.exe imgfs.bin >log_dump.txt
	..\sleep 3
	ren dump dump_imgfs
	popd
GOTO :EOF

:2b
:2b.ExtractDumpIMGFS.cmd
	echo Working, please wait...
	pushd Temp
	..\Tools\ImgfsToDump.exe imgfs.bin >log_dump.txt
	..\sleep 3
	ren dump dump_imgfs
	popd
GOTO :EOF

:3a
:3a.ExtractDumpXIP.cmd
	pushd Temp
	..\tools\RomMaster.exe -x -w 5 -b 0x320000 OS.nb.payload -o xip.bin
	mkdir XIP
	..\tools\dumprom xip.bin -5 -d XIP
	..\sleep 3
	ren dump dump_xip
	cd XIP
	REM Access is Denied workaround
		dir ..\dump_xip /A:D /B >tempxipmoduleslist.tmp
		..\..\tools\preparexipdel.vbs tempxipmoduleslist.tmp tempxipmoduleslist.bat
		start /b /wait tempxipmoduleslist.bat
		del tempxipmoduleslist.tmp
		del tempxipmoduleslist.bat
	REM Access is Denied workaround
	copy /Y *.* ..\dump_xip
	attrib -s -h -r -a *.* /s /d 
	del *.* /q
	cd ..
	rd XIP
	popd
GOTO :EOF

:3b
:3b.ExtractDumpXIP.cmd
	pushd Temp
	mkdir XIP
	..\tools\dumprom xip.bin -5 -d XIP
	..\sleep 3
	ren dump dump_xip
	cd XIP
	REM Access is Denied workaround
		dir ..\dump_xip /A:D /B >tempxipmoduleslist.tmp
		..\..\tools\preparexipdel.vbs tempxipmoduleslist.tmp tempxipmoduleslist.bat
		start /b /wait tempxipmoduleslist.bat
		del tempxipmoduleslist.tmp
		del tempxipmoduleslist.bat
	REM Access is Denied workaround
	copy /Y *.* ..\dump_xip
	attrib -s -h -r -a *.* /s /d 
	del *.* /q
	cd ..
	rd XIP
	popd
GOTO :EOF

:4
:4.CopyROMXIP.cmd
	xcopy Temp\dump_xip Temp\dump_imgfs /e /y
	Rem Copy boot.rgu to ROM\XIP
	md ROM
	pushd ROM
	Copy ..\BaseROM\OS.NB OS.NB /y
	md XIP
	cd XIP
	Copy ..\..\temp\dump_xip\boot.rgu /y
	popd
GOTO :EOF

:5
:5.PKGTool.cmd
	tools\PKGTool.exe Temp\dump_imgfs
GOTO :EOF

:6
:6.MoveOEMSYS.cmd
	move Temp\dump_imgfs\OEM
	move Temp\dump_imgfs\SYS
	rd temp\dump_imgfs
GOTO :EOF

:7
:7.DeleteBoot.cmd
		sleep 1
		echo Ignore any errors while deleting files!
		del OEM\OEMXIPKernel\*.* /q /s
		del OEM\Langdb\*.* /q /s
		del SYS\MSXIPKernel\*.* /q /s
		del SYS\MSXIPKernelLTK\*.* /q /s
		del SYS\WinCENLS_WWE\*.* /q /s

		sleep 3
		rd OEM\OEMXIPKernel /q /s
		rd OEM\Langdb /q /s
		rd SYS\MSXIPKernel /q /s
		rd SYS\MSXIPKernelLTK /q /s
		rd SYS\WinCENLS_WWE /q /s

GOTO :EOF

:8a
:8a.BuildOS.cmd
	buildos 
	G'Reloc.exe -doit -dump
GOTO :EOF

:8b
:8b.BuildOS.cmd
	buildos+package_tools-2.7.exe
	del s000-old\*.* /q /s
	del s000-new\*.* /q /s
	rd s000-old /q /s
	rd s000-new /q /s
GOTO :EOF

:9
:9.CreateROMKovsky.bat

	copy ROM\OS.nb temp\OS.nb

	pushd temp
	
	..\TOOLS\NBSplit -kaiser OS.nb
	Rem rename os.nb.extra os-new.nb.extra
	..\TOOLS\ImgfsFromNb OS.nb.payload imgfs.bin
	Pause
	..\TOOLS\ImgfsFromDump imgfs.bin imgfs-new.bin
	..\TOOLS\ImgfsToNb imgfs-new.bin os.nb.payload os-new.nb.payload -bigstoragemove
	..\TOOLS\NBMerge -kaiser os-new.nb 

	move os-new.nb ..

	echo Ignore any errors while deleting files!
	
Rem	del boot.hv
Rem	del boot.rgu
Rem	del imgfs-new.bin
Rem	del imgfs.bin
Rem	del os-new.nb.payload
Rem	del OS.nb
Rem	del OS.nb.extra
Rem	del OS.nb.payload

	popd
GOTO :EOF

:10
:10.HTCRomTool.bat
cls
echo -= HTC ROM TOOL =-
echo Click "Build!"
echo In ROM builder tab choose Device: Kovsky
echo Click ... in OS: and choose os-new.nb
echo Click Build ROM and choose filename RUU_signed.nbh
tools\htcrt.exe

GOTO :EOF

:11
:11.Cleanup.bat
	if exist baserom\os.nb del baserom\os.nb
	if exist baserom\0*.* del baserom\0*.*

	
	if exist temp (
		attrib -s -h -r -a temp\*.* /s /d 
		del temp\*.* /s /q
		sleep 3
		rd temp /s /q
	)
GOTO :EOF

:12
:12.PagePool.Changer.bat

	tools\xvi32\xvi32.exe RUU_signed.nbh
GOTO :EOF	

:EOF
Exit