/*
 * Decompiled with CFR 0.152.
 */
package accuweather;

import accuweather.AccuParser;
import accuweather.AccuRMS;
import accuweather.AccuweatherMain;
import accuweather.AppPreferences;
import accuweather.AppStartManager;
import accuweather.BackNavMgr;
import accuweather.DataUtility;
import accuweather.FCastDataHolder;
import accuweather.ImageWidgetForm;
import accuweather.LocationManager;
import accuweather.Locations;
import accuweather.PreferencesManager;
import accuweather.UpgradeForm;
import accuweather.WeatherForecastForm;
import com.emb.controller.GenericController;
import com.emb.form.GenericWidgetForm;
import com.emb.form.StatusWidgetForm;
import com.emb.handler.DataParser;
import com.emb.handler.HttpHandler;
import com.emb.handler.StoreManager;
import com.emb.holder.BaseHolder;
import com.emb.holder.BinaryHolder;
import com.emb.holder.ImageHolder;
import com.emb.holder.MenuHolder;
import com.emb.holder.TextHolder;
import com.emb.widget.ImageWidget;
import com.emb.widget.Menu;
import com.emb.widget.RadioWidget;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDletStateChangeException;

public class AccuController
extends GenericController {
    public static AccuController controller;
    public static PreferencesManager preferences_Manager;
    public LocationManager locationMgr;
    public BackNavMgr backNavMgr;
    Image[] splsImg = null;
    public AccuRMS accuRMS;
    public AppStartManager appStrtMgr;
    int prev_SW_CUR_ID = 0;
    Vector dataVect = null;
    static boolean newpopup;
    public static boolean partnerFlg;
    int resumeApp = 0;
    boolean deleteFlag = false;
    public static boolean flg;
    boolean locFlg = false;
    String[] tmpArr = null;
    BaseHolder holder = null;
    TextHolder textHolder = null;
    ImageHolder imageHolder = null;
    MenuHolder menuHolder = null;
    MenuHolder popupHolder = null;
    BinaryHolder binHolder = null;
    FCastDataHolder fcHolder = null;
    String intLoc = "";
    UpgradeForm sf;
    public int prevScr_Id;
    public static AppPreferences preferences;
    public static Locations locations;
    StringBuffer sbuf = null;
    String errmsg = "";
    String dynHcText = "";

    public AccuController(Display display) {
        this.display = display;
        controller = this;
        preferences = new AppPreferences();
        locations = new Locations();
        this.parser = AccuParser.getInstance();
    }

    public static AccuController getInstance(Display display) {
        if (controller == null) {
            new AccuController(display);
        } else {
            AccuController.controller.display = display;
        }
        return controller;
    }

    public void handleAppCycleEvent(int n) {
        switch (n) {
            case 1: {
                if (this.resumeApp == 1) {
                    this.handleBackEvt();
                    this.resumeApp = 0;
                } else {
                    BackNavMgr.getInstance().clearStack();
                    DataUtility.tickerMsg = null;
                    this.appStrtMgr = new AppStartManager(this);
                    this.appStrtMgr.handleStartup();
                    this.locationMgr = new LocationManager();
                    this.locationMgr.loadLocation(AccuRMS.getDefaultLocation());
                    this.appStrtMgr = null;
                    DataUtility.tickerMsg = null;
                }
                DataUtility.location_scr_paused = 0;
                break;
            }
            case 2: {
                Vector<BaseHolder> vector = null;
                if (CUR_SCREEN_ID >= 2000) {
                    vector = new Vector<BaseHolder>(2);
                    if (this.fcHolder != null) {
                        vector.addElement(this.fcHolder);
                    }
                    if (this.textHolder != null) {
                        vector.addElement(new TextHolder(this.textHolder));
                    }
                    if (this.imageHolder != null) {
                        vector.addElement(new ImageHolder(this.imageHolder));
                    }
                    if (this.menuHolder != null) {
                        vector.addElement(new MenuHolder(this.menuHolder));
                    }
                    if (this.popupHolder != null) {
                        vector.addElement(new MenuHolder(this.popupHolder));
                    }
                    this.fcHolder = null;
                    this.textHolder = null;
                    this.popupHolder = null;
                }
                BackNavMgr.getInstance().pushScreen(CUR_SCREEN_ID, vector);
                vector = null;
                this.resumeApp = 1;
                DataUtility.location_scr_paused = 1;
                break;
            }
            case 3: {
                GenericWidgetForm.getInstance().removeTicker();
                try {
                    AccuweatherMain.instance.destroyApp(true);
                    break;
                }
                catch (MIDletStateChangeException mIDletStateChangeException) {
                    // empty catch block
                }
            }
        }
    }

    public void handleError(int n, String string) {
        this.prevScr_Id = n;
        this.popupHolder = DataUtility.getPopupCommand(1003);
        this.handleDisplayText(1003, null, string, this.popupHolder);
    }

    public static void handleDeviceBackKeyEvt() {
        if (CUR_SCREEN_ID == 1000 || CUR_SCREEN_ID == 1004) {
            AccuweatherMain.quitApp();
            return;
        }
        controller.handleBackEvt();
    }

    public static void handleMenuFireEvt() {
    }

    public void handleEvents(int n) {
        if (this.sf != null) {
            DataUtility.removeCommands(this.sf);
        }
        String[] stringArray = null;
        CUR_SCREEN_ID = n;
        if (n < 2000) {
            this.menuHolder = null;
            this.popupHolder = null;
            this.menuHolder = DataUtility.getMenu(n);
            this.popupHolder = DataUtility.getPopupCommand(n);
            stringArray = DataUtility.getScreenInfoText(n);
        }
        switch (n) {
            case 1004: {
                this.appStrtMgr = new AppStartManager(this);
                this.appStrtMgr.showSplashScr();
                break;
            }
            case 1000: {
                this.locFlg = false;
                DataUtility.location_scr_value = 2;
                DataUtility.imgVec.removeAllElements();
                System.gc();
                BackNavMgr.getInstance().clearStack();
                this.prev_SW_CUR_ID = 0;
                BackNavMgr.getInstance().pushScreen(1000, null);
                DataUtility.tickerMsg = AccuRMS.getTickerTxt();
                this.handleDisplayMenu(this.menuHolder, 1000, this.popupHolder);
                this.menuHolder = null;
                this.popupHolder = null;
                partnerFlg = true;
                break;
            }
            case 1001: {
                this.handleDisplayText(1001, (String)stringArray[0], (String)stringArray[1], DataUtility.getPopupCommand(1001));
                break;
            }
            case 1005: 
            case 1016: 
            case 1070: {
                this.handleDisplayMenu(this.menuHolder, n, this.popupHolder);
                break;
            }
            case 1009: {
                this.locFlg = true;
                DataUtility.location_scr_value = 1;
                BackNavMgr.getInstance().clearStack();
                System.gc();
                BackNavMgr.getInstance().pushScreen(1000, null);
                this.handleDisplayMenu(this.menuHolder, 1009, this.popupHolder);
                break;
            }
            case 1002: 
            case 1015: 
            case 1017: 
            case 1018: 
            case 1020: 
            case 1022: 
            case 1025: 
            case 1026: 
            case 3001: {
                this.handleDisplayGenericFormScreen(n, (String)stringArray[0], this.popupHolder);
                break;
            }
            case 1006: 
            case 1007: 
            case 1027: 
            case 1052: 
            case 1053: {
                this.handleDisplayText(n, (String)stringArray[0], (String)stringArray[1], this.popupHolder);
                break;
            }
            case 1013: {
                this.locationMgr = new LocationManager();
                this.handleDisplayMenu(this.locationMgr.populateAllLocation(), 1013, this.popupHolder);
                this.locationMgr = null;
                break;
            }
            case 1050: 
            case 1051: 
            case 1060: 
            case 1061: 
            case 1062: 
            case 1074: {
                this.handleDisplayText(n, (String)stringArray[0], (String)stringArray[1], this.popupHolder);
                break;
            }
            case 1010: 
            case 1071: 
            case 1072: 
            case 1073: {
                UpgradeForm.changePos = 0;
                this.handleUpgradeScreens(n, (String)stringArray[0], (String)stringArray[1], this.popupHolder);
                break;
            }
            default: {
                this.handleDisplayMenu(this.menuHolder, n, this.popupHolder);
            }
        }
    }

    public void handleUpgradeScreens(int n, String string, String string2, MenuHolder menuHolder) {
        if (genWdgFrm != null) {
            DataUtility.removeCommands(genWdgFrm);
        }
        this.sf = UpgradeForm.getInstance();
        DataUtility.removeCommands(this.sf);
        this.sf.setTitle(string);
        this.sf.setHeaderImage(DataUtility.getAccuHeaderImage());
        try {
            if (n == 1071) {
                this.sf.setPageDetails(Image.createImage((String)"/satellite.png"), string2);
            } else if (n == 1010) {
                this.sf.setPageDetails(Image.createImage((String)"/weather-map.png"), string2);
            } else if (n == 1073) {
                if (AccuController.preferences.langPref == 0) {
                    this.sf.setPageDetails(Image.createImage((String)"/10-day-en.png"), string2);
                } else if (AccuController.preferences.langPref == 1) {
                    this.sf.setPageDetails(Image.createImage((String)"/10-day-sp.png"), string2);
                } else if (AccuController.preferences.langPref == 3) {
                    this.sf.setPageDetails(Image.createImage((String)"/10-day-fr.png"), string2);
                } else if (AccuController.preferences.langPref == 2) {
                    this.sf.setPageDetails(Image.createImage((String)"/10-day-ge.png"), string2);
                } else if (AccuController.preferences.langPref == 4) {
                    this.sf.setPageDetails(Image.createImage((String)"/10-day-italian.png"), string2);
                }
            } else if (n == 1072) {
                if (AccuController.preferences.langPref == 0) {
                    this.sf.setPageDetails(Image.createImage((String)"/hourly-small.png"), string2);
                } else if (AccuController.preferences.langPref == 1) {
                    this.sf.setPageDetails(Image.createImage((String)"/hourly-sp.png"), string2);
                } else if (AccuController.preferences.langPref == 3) {
                    this.sf.setPageDetails(Image.createImage((String)"/hourly-fr.png"), string2);
                } else if (AccuController.preferences.langPref == 2) {
                    this.sf.setPageDetails(Image.createImage((String)"/hourly-ge.png"), string2);
                } else if (AccuController.preferences.langPref == 4) {
                    this.sf.setPageDetails(Image.createImage((String)"/hourly-it.png"), string2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.sf.repaint();
        this.display.setCurrent((Displayable)this.sf);
        DataUtility.removeCommands(this.sf);
        DataUtility.addCommands((Displayable)this.sf, n, menuHolder);
        this.nextScreen(this.sf, n);
    }

    public void commandAction(Command command, Displayable displayable) {
        String string = command.getLabel().toLowerCase().trim();
        if (command == DataUtility.cmdCANCEL) {
            HttpHandler.close = true;
            StatusWidgetForm.instance.removeCommand(DataUtility.cmdCANCEL);
            if (HttpHandler.th != null && HttpHandler.th.isAlive()) {
                try {
                    HttpHandler.th.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.handleBackEvt();
            return;
        }
        if (command == ImageWidget.showKey) {
            ImageWidgetForm.toggleKeyImg();
            return;
        }
        int n = this.getCommandId(string);
        if (n == 0) {
            this.handleCommandEvents(string);
        } else {
            this.handleCommandEvents(n);
        }
        if (n == 23 || n == 25) {
            DataUtility.location_scr_value = this.locFlg ? 1 : 2;
        }
    }

    public int getCommandId(String string) {
        int n = 0;
        if (string.equals("accept") || string.equals("aceptar") || string.equals("accepter") || string.equals("annehmen") || string.equals("accetta")) {
            n = 17;
        } else if (string.equals("decline") || string.equals("rehusar") || string.equals("ablehnen") || string.equals("refuser") || string.equals("declina")) {
            n = 18;
        } else if (string.equals("ok") || string.equals("ok") || string.equals("ok") || string.equals("o.k.") || string.equals("ok")) {
            n = 12;
        } else if (string.equals("select") || string.equals("elegir") || string.equals("choisir") || string.equals("ausw\u00e4hlen") || string.equals("scegli")) {
            n = 10;
        } else if (string.equals("save") || string.equals("guardar") || string.equals("garder") || string.equals("speichern") || string.equals("salva") || string.equals("enregistrer")) {
            n = 19;
        } else if (string.equals("cancel") || string.equals("cancelar") || string.equals("annuler") || string.equals("abbrechen") || string.equals("annulla")) {
            n = 13;
        } else if (string.equals("yes") || string.equals("s\u00ed") || string.equals("ja") || string.equals("oui") || string.equals("s\u00ec")) {
            n = 20;
        } else if (string.equals("home") || string.equals("inicio") || string.equals("menu principal") || string.equals("startseite") || string.equals("inizio") || string.equals("origine")) {
            n = 15;
        } else if (string.equals("exit") || string.equals("salir") || string.equals("sortir") || string.equals("beenden") || string.equals("esci") || string.equals("quitter")) {
            n = 22;
        } else if ((string.equals("set location") || string.equals("estab. ciudad") || string.equals("ort festlegen") || string.equals("choix emplac") || string.equals("imp. luogo")) && CUR_SCREEN_ID == 1013) {
            n = 23;
        } else if (string.equals("add") || string.equals("agr localidad") || string.equals("hinzuf\u00fcgen") || string.equals("ajter emplac.") || string.equals("agg. luogo")) {
            n = 24;
        } else if (string.equals("edit") || string.equals("editar") || string.equals("editer") || string.equals("bearbeiten") || string.equals("edita")) {
            n = 26;
        } else if (string.equals("delete") || string.equals("borrar") || string.equals("supprimer") || string.equals("l\u00f6schen") || string.equals("cancella")) {
            n = 25;
        } else if (string.equals("back") || string.equals("volver") || string.equals("pr\u00e9c\u00e9dent") || string.equals("zur\u00fcck") || string.equals("torna")) {
            n = 11;
        } else if (string.equals("help") || string.equals("inicio de ayuda")) {
            n = 1055;
        } else if (string.equals("skip") || string.equals("skip") || string.equals("skip") || string.equals("skip") || string.equals("skip")) {
            n = 61;
        } else if (string.equals("no") || string.equals("no") || string.equals("nein") || string.equals("non")) {
            n = 21;
        } else if (string.equals("purchase") || string.equals("comprar") || string.equals("acheter") || string.equals("erwerb") || string.equals("comprare")) {
            n = 62;
        }
        return n;
    }

    public void handleCommandEvents(String string) {
        String string2 = null;
        int n = -1;
        int n2 = 0;
        if (this.popupHolder != null && this.popupHolder.getPosition(string) != -1) {
            n = this.popupHolder.getPosition(string);
            string2 = this.popupHolder.sData[n];
            n2 = this.popupHolder.getScreenId();
        } else {
            n = this.menuHolder.getPosition(string);
            string2 = this.menuHolder.sData[n];
            n2 = this.menuHolder.getScreenId();
        }
        if (string.equals("play") || string.equals("animar") || string.equals("animation") || string.equals("abspielen")) {
            this.handlePlayEvt(n2, string2);
        } else if (string.equals("stop") || string.equals("parar") || string.equals("arr\u00eat") || string.equals("arr\u00eater")) {
            this.handleStopEvt();
        } else if (string.equals("days") || string.equals("d\u00edas") || string.equals("jours") || string.equals("tage") || string.equals("giorni")) {
            this.handleDaysEvt(n2, string2);
        } else if (string.trim().equals("view image") || string.trim().equals("imagen view")) {
            Vector<BaseHolder> vector = new Vector<BaseHolder>();
            if (this.textHolder != null) {
                vector.addElement(new TextHolder(this.textHolder));
            }
            if (this.menuHolder != null) {
                vector.addElement(new MenuHolder(this.menuHolder));
            }
            BackNavMgr.getInstance().pushScreen(CUR_SCREEN_ID, vector);
            vector = null;
            this.handleDynamicEvt(n2, string2);
        } else if (string.trim().equals("go") || string.trim().equals("ir") || string.trim().equals("gehen zu") || string.trim().equals("zu") || string.trim().equals("aller") || string.trim().equals("vai")) {
            if (string2 != null) {
                try {
                    AccuweatherMain.instance.platformRequest(string2);
                    this.handleAppCycleEvent(3);
                }
                catch (Exception exception) {}
            }
        } else {
            this.handleDynamicEvt(n2, string2);
        }
    }

    public void handleCommandEvents(int n) {
        Vector vector = null;
        vector = this.getHolders(CUR_SCREEN_ID);
        if (n != 11 && n != 13 && CUR_SCREEN_ID != 1003) {
            BackNavMgr.getInstance().pushScreen(CUR_SCREEN_ID, vector);
        }
        vector = null;
        int n2 = CUR_SCREEN_ID;
        switch (n) {
            case 10: {
                this.handleSelectEvt(n2);
                break;
            }
            case 11: {
                if (CUR_SCREEN_ID == 3021) {
                    this.handleStopEvt();
                    break;
                }
                this.handleBackEvt();
                break;
            }
            case 28: {
                this.handleOkEvt(n2);
                break;
            }
            case 25: {
                this.handleDeleteEvt(n2);
                break;
            }
            case 62: {
                this.handlePurchaseEvt(n2);
                break;
            }
            case 26: {
                this.handleEditEvt(n2);
                break;
            }
            case 61: {
                this.handleSkip(n2);
                break;
            }
            case 20: {
                this.handleYesEvt(n2);
                break;
            }
            case 21: {
                this.handleNoEvt(n2);
                break;
            }
            case 22: {
                AccuweatherMain.quitApp();
                break;
            }
            case 24: {
                this.handleAddLocationEvt(n2);
                break;
            }
            case 19: {
                this.handleSaveEvt(n2);
                break;
            }
            case 12: {
                this.handleOkEvt(n2);
                break;
            }
            case 13: {
                this.handleCancelEvt(n2);
                break;
            }
            case 15: {
                this.handleEvents(1000);
                break;
            }
            case 17: {
                this.handleAcceptEvt(n2);
                break;
            }
            case 58: {
                this.handleOkEvt(n2);
                break;
            }
            case 18: {
                this.handleDeclineEvt(n2);
                break;
            }
            case 23: {
                this.handleSetDefaultEvt(n2);
            }
        }
    }

    public void handleDaysEvt(int n, String string) {
        Vector<BaseHolder> vector = new Vector<BaseHolder>();
        vector.addElement(new ImageHolder(this.imageHolder));
        vector.addElement(new MenuHolder(this.menuHolder));
        this.menuHolder = MenuHolder.getMenuInstance();
        BackNavMgr.getInstance().pushScreen(CUR_SCREEN_ID, vector);
        vector = null;
        this.prev_SW_CUR_ID = CUR_SCREEN_ID;
        String[] stringArray = DataParser.tokenizer(string, "|");
        this.menuHolder.setTitle(DataUtility.getFilterText("Days|D\u00edas|Tage|Jours|Giorni"));
        int n2 = stringArray.length;
        this.menuHolder.setSize(n2);
        for (int i = 0; i < n2; ++i) {
            String[] stringArray2 = DataParser.tokenizer(stringArray[i] + "$", "$");
            if (stringArray2[0] == null) {
                stringArray2[0] = "-1";
            }
            if (stringArray2[1] == null) {
                stringArray2[1] = "";
            }
            if (stringArray2[2] == null) {
                stringArray2[2] = "-1";
            }
            if (stringArray2[3] == null) {
                stringArray2[3] = "";
            }
            this.menuHolder.addItem(Integer.parseInt(stringArray2[0]), stringArray2[1], Integer.parseInt(stringArray2[2]), stringArray2[3]);
        }
        this.handleDisplayMenu(this.menuHolder, 1024, DataUtility.getPopupCommand(1024));
        this.menuHolder = null;
    }

    public Vector getHolders(int n) {
        Vector<BaseHolder> vector = new Vector<BaseHolder>();
        switch (n) {
            case 3010: 
            case 3011: {
                vector.addElement(this.fcHolder);
                vector.addElement(new MenuHolder(this.menuHolder));
                break;
            }
            case 1071: {
                break;
            }
            case 3000: 
            case 3001: 
            case 3002: 
            case 3003: {
                vector.addElement(new MenuHolder(this.menuHolder));
                vector.addElement(new MenuHolder(this.popupHolder));
            }
        }
        return vector;
    }

    public void handleDynamicEvt(int n, String string) {
        if (n == 1071) {
            Vector<BaseHolder> vector = new Vector<BaseHolder>(2);
            vector.addElement(new ImageHolder(this.imageHolder));
            vector.addElement(new MenuHolder(this.menuHolder));
            this.prev_SW_CUR_ID = CUR_SCREEN_ID;
            BackNavMgr.getInstance().pushScreen(CUR_SCREEN_ID, vector);
            vector = null;
        }
        this.prepareHTTPRequest(n, string);
    }

    public void handlePlayEvt(int n, String string) {
        Vector<BaseHolder> vector = new Vector<BaseHolder>();
        Vector<BaseHolder> vector2 = new Vector<BaseHolder>();
        if (DataUtility.imgVec == null || DataUtility.imgVec.size() == 0) {
            vector.addElement(new ImageHolder(this.imageHolder));
            vector.addElement(new MenuHolder(this.menuHolder));
            DataUtility.imgVec.addElement(vector);
            vector = null;
        }
        if (CUR_SCREEN_ID != 3021) {
            vector2.addElement(new ImageHolder(this.imageHolder));
            vector2.addElement(new MenuHolder(this.menuHolder));
            BackNavMgr.getInstance().pushScreen(CUR_SCREEN_ID, vector2);
            vector2 = null;
        }
        if (DataUtility.imgVec.size() > 1) {
            Vector vector3 = null;
            vector3 = (Vector)DataUtility.imgVec.elementAt(1);
            this.imageHolder = (ImageHolder)vector3.elementAt(0);
            this.menuHolder = (MenuHolder)vector3.elementAt(1);
            this.handleDisplayImage(n, this.imageHolder.img, null, this.imageHolder.engine_id, this.imageHolder.panDir, this.imageHolder.heading, this.menuHolder);
            vector3 = null;
        } else {
            this.prepareHTTPRequest(n, string);
        }
    }

    public void handleStopEvt() {
        Vector<BaseHolder> vector = new Vector<BaseHolder>();
        if (DataUtility.imgVec == null || DataUtility.imgVec.size() == 1) {
            vector.addElement(new ImageHolder(this.imageHolder));
            vector.addElement(new MenuHolder(this.menuHolder));
            DataUtility.imgVec.addElement(vector);
        }
        vector = null;
        CUR_SCREEN_ID = 3021;
        this.handleBackEvt();
    }

    public void handleDeleteEvt(int n) {
        switch (n) {
            case 1013: {
                Menu menu = (Menu)AccuController.genWdgFrm.widgetArray.elementAt(0);
                this.tmpArr = DataParser.tokenizer(menu.getSelectedData(), "|");
                int n2 = menu.getSelectedId();
                if (n2 == 0) {
                    this.handleError(1013, DataUtility.getFilterText(DataUtility.deleteLocation));
                    break;
                }
                this.handleEvents(1062);
                return;
            }
        }
    }

    public void handleDeleteLoc(int n) {
        switch (n) {
            case 1062: {
                DataUtility.RMSlocation = Integer.parseInt(this.tmpArr[11]);
                AccuRMS.deleteLocation(DataUtility.RMSlocation);
                BackNavMgr.getInstance().popScreen();
                n = BackNavMgr.getInstance().getCurrentScreenID();
                this.handleEvents(1013);
            }
        }
    }

    public void handleNoEvt(int n) {
        int n2 = 0;
        switch (n) {
            case 1062: {
                BackNavMgr.getInstance().popScreen();
                n2 = BackNavMgr.getInstance().getCurrentScreenID();
                this.handleEvents(1013);
            }
        }
    }

    public void handleYesEvt(int n) {
        switch (n) {
            case 1062: {
                this.handleDeleteLoc(n);
            }
        }
    }

    public void handlePurchaseEvt(int n) {
        switch (n) {
            case 1074: {
                if (AccuweatherMain.purchase_url == null) break;
                try {
                    AccuweatherMain.instance.platformRequest(AccuweatherMain.purchase_url);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void handleBackEvt() {
        Vector vector;
        this.holder = null;
        this.textHolder = null;
        this.binHolder = null;
        this.fcHolder = null;
        Vector vector2 = null;
        int n = 0;
        BackNavMgr.getInstance().showStack();
        int n2 = BackNavMgr.getInstance().getCurrentScreenID();
        if (n2 == 0) {
            this.handleAppCycleEvent(3);
            return;
        }
        if (n2 == 1004) {
            BackNavMgr.getInstance().popScreen();
        }
        if (n2 == 1006) {
            n2 = BackNavMgr.getInstance().getCurrentScreenID();
            if (!(CUR_SCREEN_ID == 1013 && CUR_SCREEN_ID != 1007 || DataUtility.location_scr_value != 1 && DataUtility.location_scr_value != 2)) {
                this.handleEvents(1013);
                return;
            }
        }
        if (this.prevScr_Id == 1013 && CUR_SCREEN_ID == 1003) {
            this.handleEvents(1013);
            return;
        }
        if (DataUtility.location_scr_paused == 0 && CUR_SCREEN_ID == 1013) {
            if (DataUtility.location_scr_value == 1) {
                this.handleEvents(1009);
                return;
            }
            if (DataUtility.location_scr_value == 2) {
                this.handleEvents(1000);
                return;
            }
        }
        if (n2 == 1003) {
            BackNavMgr.getInstance().popScreen();
        }
        vector2 = BackNavMgr.getInstance().popScreen();
        n = (Integer)vector2.elementAt(0);
        if (CUR_SCREEN_ID == 3021 && DataUtility.imgVec.size() == 1) {
            vector = new Vector();
            vector.addElement(new ImageHolder(this.imageHolder));
            vector.addElement(new MenuHolder(this.menuHolder));
            DataUtility.imgVec.addElement(vector);
            vector = null;
        }
        if (CUR_SCREEN_ID == 1062) {
            vector = (Vector)vector2.elementAt(1);
            this.handleSwitchBackEvt(n, vector);
            vector = null;
            return;
        }
        if (n == n2 && n > 2000) {
            vector = (Vector)vector2.elementAt(1);
            this.handleSwitchBackEvt(n, vector);
            vector = null;
            return;
        }
        this.handleEvents(n);
        vector2 = null;
    }

    public void handleSwitchBackEvt(int n, Vector vector) {
        if (vector != null) {
            switch (n) {
                case 3010: 
                case 3011: {
                    this.fcHolder = (FCastDataHolder)vector.elementAt(0);
                    this.menuHolder = (MenuHolder)vector.elementAt(1);
                    if (this.menuHolder == null) {
                        this.menuHolder = DataUtility.getPopupCommand(n);
                    }
                    this.handleDisplayForecast(n, this.fcHolder.icon, this.fcHolder.header1, this.fcHolder.header2, this.fcHolder.bdyText, this.menuHolder);
                    break;
                }
                case 1071: 
                case 3021: 
                case 3025: 
                case 3026: 
                case 3027: 
                case 3028: 
                case 3029: {
                    this.imageHolder = (ImageHolder)vector.elementAt(0);
                    this.menuHolder = (MenuHolder)vector.elementAt(1);
                    this.handleDisplayImage(n, this.imageHolder.img, null, this.imageHolder.engine_id, this.imageHolder.panDir, this.imageHolder.heading, this.menuHolder);
                    break;
                }
                case 3000: 
                case 3001: 
                case 3002: 
                case 3003: {
                    this.menuHolder = (MenuHolder)vector.elementAt(0);
                    this.popupHolder = (MenuHolder)vector.elementAt(1);
                    this.handleDisplayMenu(this.menuHolder, n, this.popupHolder);
                    break;
                }
                case 1062: {
                    this.textHolder = (TextHolder)vector.elementAt(0);
                    this.menuHolder = (MenuHolder)vector.elementAt(1);
                    this.handleDisplayText(n, this.textHolder.heading, this.textHolder.text, this.menuHolder);
                }
            }
        }
        vector = null;
    }

    public void handleEditEvt(int n) {
    }

    public void handleAddLocationEvt(int n) {
        boolean bl = false;
        switch (n) {
            case 1013: {
                if (LocationManager.getNoOfLocation() < DataUtility.maxNoOfLoc) {
                    this.handleEvents(1005);
                    break;
                }
                this.handleError(n, DataUtility.getFilterText(DataUtility.addLocationMsg));
            }
        }
    }

    public void handleSkip(int n) {
        PreferencesManager preferencesManager = new PreferencesManager();
        preferencesManager.getDefaultStartupSettings();
        preferencesManager = null;
        if (LocationManager.getNoOfLocation() >= 1) {
            BackNavMgr.getInstance().pushScreenID(1000);
            controller.handleEvents(1000);
        } else {
            controller.handleEvents(1005);
        }
    }

    public void handleAcceptEvt(int n) {
        switch (n) {
            case 1001: {
                try {
                    StoreManager.saveRecord("accept", "1".getBytes("UTF-8"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.appStrtMgr = new AppStartManager(this);
                this.appStrtMgr.showSplashScr();
            }
        }
    }

    public void handleDeclineEvt(int n) {
        switch (n) {
            case 1001: {
                this.handleAppCycleEvent(3);
            }
        }
    }

    public void handleSaveEvt(int n) {
        Object var2_2 = null;
        switch (n) {
            case 1015: {
                DataUtility.cmdCANCEL = null;
                ImageWidget.showKey = null;
            }
            case 1017: 
            case 1018: 
            case 1020: 
            case 1025: 
            case 1026: {
                RadioWidget radioWidget = (RadioWidget)AccuController.genWdgFrm.widgetArray.elementAt(0);
                int n2 = radioWidget.selIndex;
                int n3 = 0;
                switch (n) {
                    case 1020: {
                        n3 = 1;
                        break;
                    }
                    case 1026: {
                        n3 = 2;
                        break;
                    }
                    case 1017: {
                        n3 = 3;
                        break;
                    }
                    case 1018: {
                        n3 = 4;
                        break;
                    }
                    case 1015: {
                        n3 = 5;
                        break;
                    }
                    case 1025: {
                        n3 = 6;
                    }
                }
                if (n2 >= 0) {
                    preferences_Manager = new PreferencesManager();
                    preferences_Manager.setPrefernces(n3, n2);
                    preferences_Manager = null;
                }
                BackNavMgr.getInstance().popScreen();
                BackNavMgr.getInstance().popScreen();
                DataUtility.loadMenuFromRes(AccuController.preferences.langPref);
                this.handleEvents(1009);
            }
        }
    }

    public void handleCancelEvt(int n) {
        switch (n) {
            case 1002: {
                this.handleAppCycleEvent(3);
                break;
            }
            case 3001: {
                this.handleBackEvt();
                break;
            }
            default: {
                this.handleBackEvt();
            }
        }
    }

    public void handleSetDefaultEvt(int n) {
        switch (n) {
            case 1013: {
                Menu menu = (Menu)AccuController.genWdgFrm.widgetArray.elementAt(0);
                int n2 = menu.getSelectedId();
                if (n2 == 0) break;
                String[] stringArray = DataParser.tokenizer(menu.getSelectedData(), "|");
                AccuRMS.setDefaultLocation(Integer.parseInt(stringArray[11]));
                this.locationMgr = new LocationManager();
                this.locationMgr.loadLocation(AccuRMS.getDefaultLocation());
                DataUtility.location_scr_value = 3;
                this.handleBackEvt();
                BackNavMgr.getInstance().showStack();
            }
        }
    }

    public void handleOkEvt(int n) {
        switch (n) {
            case 2099: {
                BackNavMgr.getInstance().popScreen();
            }
            case 1003: {
                this.handleBackEvt();
                break;
            }
            case 1051: {
                if (LocationManager.getNoOfLocation() >= 1) {
                    this.handleEvents(1000);
                    break;
                }
                this.handleEvents(1005);
                break;
            }
            case 1006: {
                PreferencesManager preferencesManager = new PreferencesManager();
                preferencesManager.loadPreferences();
                String[] stringArray = DataParser.tokenizer(DataUtility.newLocation, "|");
                int n2 = AccuRMS.addLocation(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7], stringArray[8], stringArray[9], stringArray[10]);
                if (n2 == 2) {
                    if (LocationManager.getNoOfLocation() <= 1) {
                        this.handleEvents(1000);
                        break;
                    }
                    this.handleEvents(1013);
                    break;
                }
                if (n2 == 0) {
                    if (AccuController.preferences.langPref == 0) {
                        DataUtility.dupLocData = stringArray[2] + ", " + stringArray[1];
                    } else if (AccuController.preferences.langPref == 1) {
                        DataUtility.dupLocData = stringArray[4] + ", " + stringArray[3];
                    } else if (AccuController.preferences.langPref == 2) {
                        DataUtility.dupLocData = stringArray[6] + ", " + stringArray[5];
                    } else if (AccuController.preferences.langPref == 3) {
                        DataUtility.dupLocData = stringArray[8] + ", " + stringArray[7];
                    } else if (AccuController.preferences.langPref == 4) {
                        DataUtility.dupLocData = stringArray[10] + ", " + stringArray[9];
                    }
                    this.handleEvents(1007);
                    break;
                }
                if (n2 == 1) {
                    if (AccuController.preferences.langPref == 0) {
                        DataUtility.dupLocData = stringArray[2] + ", " + stringArray[1];
                    } else if (AccuController.preferences.langPref == 1) {
                        DataUtility.dupLocData = stringArray[4] + ", " + stringArray[3];
                    } else if (AccuController.preferences.langPref == 2) {
                        DataUtility.dupLocData = stringArray[6] + ", " + stringArray[5];
                    } else if (AccuController.preferences.langPref == 3) {
                        DataUtility.dupLocData = stringArray[8] + ", " + stringArray[7];
                    } else if (AccuController.preferences.langPref == 4) {
                        DataUtility.dupLocData = stringArray[10] + ", " + stringArray[9];
                    }
                    this.handleEvents(1052);
                    break;
                }
                if (n2 != 3) break;
                if (AccuController.preferences.langPref == 0) {
                    DataUtility.dupLocData = stringArray[2] + ", " + stringArray[1];
                } else if (AccuController.preferences.langPref == 1) {
                    DataUtility.dupLocData = stringArray[4] + ", " + stringArray[3];
                } else if (AccuController.preferences.langPref == 2) {
                    DataUtility.dupLocData = stringArray[6] + ", " + stringArray[5];
                } else if (AccuController.preferences.langPref == 3) {
                    DataUtility.dupLocData = stringArray[8] + ", " + stringArray[7];
                } else if (AccuController.preferences.langPref == 4) {
                    DataUtility.dupLocData = stringArray[10] + ", " + stringArray[9];
                }
                this.handleEvents(1053);
            }
        }
    }

    public void handleSelectEvt(int n) {
        if (n == 1013) {
            BackNavMgr.getInstance().popScreen();
        }
        if (n == 1013) {
            return;
        }
        Menu menu = null;
        String string = null;
        int n2 = 0;
        if (n == 1016) {
            PreferencesManager preferencesManager = new PreferencesManager();
            preferencesManager.getDefaultStartupSettings();
            preferencesManager = null;
            menu = (Menu)AccuController.genWdgFrm.widgetArray.elementAt(0);
            String string2 = menu.getSelectedData();
            int n3 = Integer.parseInt(string2);
            if (string2 != null) {
                AccuRMS.setLanguage(n3);
            } else {
                System.out.println("invalied language");
            }
            string2 = null;
            this.handleEvents(1001);
            menu = null;
            return;
        }
        if (AccuController.genWdgFrm.widgetArray.elementAt(0) instanceof Menu) {
            menu = (Menu)AccuController.genWdgFrm.widgetArray.elementAt(0);
        }
        if (menu != null) {
            n = menu.getSelectedId();
            n2 = menu.getSelectedActionId();
            string = menu.getSelectedData();
            this.intLoc = DataUtility.location;
        }
        if (n == 1016) {
            n = 1015;
        }
        if (n2 == 1) {
            this.prepareHTTPRequest(n, string);
        } else if (n2 == 2 || n2 == 3) {
            if (n == 1050) {
                AccuweatherMain.quitApp();
                return;
            }
            this.handleEvents(n);
        } else if (n2 == 6) {
            PreferencesManager preferencesManager = new PreferencesManager();
            preferencesManager.loadPreferences();
            String[] stringArray = DataParser.tokenizer(string, "|");
            DataUtility.newLocation = string;
            if (AccuController.preferences.langPref == 0) {
                DataUtility.dupLocData = stringArray[2] + ", " + stringArray[1];
            } else if (AccuController.preferences.langPref == 1) {
                DataUtility.dupLocData = stringArray[4] + ", " + stringArray[3];
            } else if (AccuController.preferences.langPref == 2) {
                DataUtility.dupLocData = stringArray[6] + ", " + stringArray[5];
            } else if (AccuController.preferences.langPref == 3) {
                DataUtility.dupLocData = stringArray[8] + ", " + stringArray[7];
            } else if (AccuController.preferences.langPref == 4) {
                DataUtility.dupLocData = stringArray[10] + ", " + stringArray[9];
            }
            this.handleEvents(1006);
            stringArray = null;
            string = null;
        } else if (n2 == 10) {
            this.handleAppCycleEvent(3);
            return;
        }
    }

    public void handleDisplayForecast(int n, Image[] imageArray, String[] stringArray, String[] stringArray2, String[] stringArray3, MenuHolder menuHolder) {
        WeatherForecastForm weatherForecastForm = DataUtility.addFCastForm();
        GenericWidgetForm.getInstance().removeTicker();
        if (imgWidgetFrm != null) {
            DataUtility.removeCommands(imgWidgetFrm);
        }
        if (genWdgFrm != null) {
            DataUtility.removeCommands(genWdgFrm);
        }
        weatherForecastForm.setFormData(imageArray, stringArray, stringArray2, stringArray3);
        if (weatherForecastForm != null) {
            weatherForecastForm.tw.colorFlg = n == 3011 || n == 3010;
        }
        DataUtility.removeCommands(genWdgFrm);
        weatherForecastForm.setHeaderImage(DataUtility.getAccuHeaderImage());
        weatherForecastForm.setTitle(null);
        DataUtility.addCommands((Displayable)weatherForecastForm, n, menuHolder);
        this.nextScreen(weatherForecastForm, n);
    }

    public void handleHttpResponse(Vector vector) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        this.holder = null;
        this.textHolder = null;
        this.imageHolder = null;
        this.menuHolder = null;
        this.popupHolder = null;
        this.binHolder = null;
        this.fcHolder = null;
        StatusWidgetForm.instance.removeCommand(DataUtility.cmdCANCEL);
        if (vector != null) {
            this.dataVect = null;
            for (int i = 0; i < vector.size(); ++i) {
                this.holder = (BaseHolder)vector.elementAt(i);
                if (this.holder instanceof TextHolder) {
                    this.textHolder = (TextHolder)this.holder;
                    n2 = this.holder.curr_acid;
                    continue;
                }
                if (this.holder instanceof ImageHolder) {
                    this.imageHolder = (ImageHolder)this.holder;
                    n2 = this.holder.curr_acid;
                    continue;
                }
                if (this.holder instanceof MenuHolder) {
                    if (this.holder.curr_acid == 4) {
                        this.popupHolder = (MenuHolder)this.holder;
                        continue;
                    }
                    if (this.holder.curr_acid == 12) {
                        this.menuHolder = (MenuHolder)this.holder;
                        n2 = this.holder.curr_acid;
                        this.dynHcText = (String)vector.elementAt(1);
                        ++i;
                        continue;
                    }
                    this.menuHolder = (MenuHolder)this.holder;
                    n2 = this.holder.curr_acid;
                    continue;
                }
                if (this.holder instanceof BinaryHolder) {
                    this.binHolder = (BinaryHolder)this.holder;
                    n2 = this.holder.curr_acid;
                    continue;
                }
                if (!(this.holder instanceof FCastDataHolder)) continue;
                this.fcHolder = (FCastDataHolder)this.holder;
                n2 = this.holder.curr_acid;
            }
            if (this.menuHolder == null && this.popupHolder != null) {
                this.menuHolder = this.popupHolder;
                this.popupHolder = null;
            }
            n = this.holder.dataType;
            n3 = this.holder.getScreenId();
            if (n == 1071 && this.imageHolder != null) {
                DataUtility.imgVec.removeAllElements();
                System.gc();
            }
            switch (n2) {
                case 10: {
                    if (this.fcHolder == null) break;
                    this.intLoc = DataUtility.location;
                    this.handleDisplayForecast(n3, this.fcHolder.icon, this.fcHolder.header1, this.fcHolder.header2, this.fcHolder.bdyText, this.menuHolder);
                    this.popSwitchScr();
                    break;
                }
                case 13: {
                    if (this.fcHolder == null) break;
                    this.intLoc = DataUtility.location;
                    this.handleDisplayForecast(n3, this.fcHolder.icon, this.fcHolder.header1, this.fcHolder.header2, this.fcHolder.bdyText, this.menuHolder);
                    this.popSwitchScr();
                    break;
                }
                case 3: {
                    if (this.imageHolder == null) break;
                    if (this.imageHolder.key_src == 0) {
                        String string = "";
                        if (this.imageHolder.scr_id == 3025 || this.imageHolder.scr_id == 3026) {
                            string = AccuController.preferences.tempPref == 0 ? "/tempc.png" : "/tempf.png";
                        }
                        if (this.imageHolder.scr_id == 3029) {
                            string = "/uv.png";
                        }
                        if (this.imageHolder.scr_id == 3027) {
                            string = AccuController.preferences.otherPref == 1 ? "/precipen.png" : "/precipmetric.png";
                        }
                        if (this.imageHolder.scr_id == 3028) {
                            string = AccuController.preferences.windPref == 2 ? "/windms.png" : (AccuController.preferences.windPref == 1 ? "/windmi.png" : "/windkm.png");
                        }
                        if (string != null && string.trim().length() > 0) {
                            try {
                                this.imageHolder.img[0] = Image.createImage((String)string);
                            }
                            catch (Exception exception) {
                                this.imageHolder.img[0] = null;
                            }
                        } else {
                            this.imageHolder.img[0] = null;
                        }
                        string = null;
                    }
                    if (n3 == 3021) {
                        Image[] imageArray = null;
                        if (this.imageHolder.dataType == 3021 && DataUtility.imgVec != null && DataUtility.imgVec.size() >= 1) {
                            int n4;
                            ImageHolder imageHolder = null;
                            Vector vector2 = (Vector)DataUtility.imgVec.elementAt(0);
                            for (n4 = 0; n4 < vector2.size(); ++n4) {
                                if (!(vector2.elementAt(n4) instanceof ImageHolder)) continue;
                                imageHolder = (ImageHolder)vector2.elementAt(n4);
                                break;
                            }
                            vector2 = null;
                            imageArray = new Image[this.imageHolder.img.length + 1];
                            for (n4 = 0; n4 < this.imageHolder.img.length; ++n4) {
                                imageArray[n4] = this.imageHolder.img[n4];
                            }
                            imageArray[this.imageHolder.img.length] = imageHolder.img[2];
                            this.imageHolder.img = imageArray;
                        } else {
                            imageArray = this.imageHolder.img;
                        }
                        this.handleDisplayImage(n3, imageArray, null, this.imageHolder.engine_id, "0000", this.imageHolder.heading, this.menuHolder);
                        if (n3 != 3021) {
                            this.popSwitchScr();
                        }
                        imageArray = null;
                        break;
                    }
                    this.handleDisplayImage(n3, this.imageHolder.img, null, this.imageHolder.engine_id, this.imageHolder.panDir, this.imageHolder.heading, this.menuHolder);
                    this.popSwitchScr();
                    break;
                }
                case 2: {
                    if (this.textHolder == null) break;
                    if (this.deleteFlag) {
                        AccuRMS.deleteLocation(DataUtility.RMSlocation);
                        this.handleBackEvt();
                        return;
                    }
                    this.handleDisplayText(n3, this.textHolder.heading, this.textHolder.text, this.menuHolder);
                    break;
                }
                case 1: {
                    if (this.menuHolder == null) break;
                    this.handleDisplayMenu(this.menuHolder, n3, this.popupHolder);
                    this.popSwitchScr();
                    break;
                }
                case 12: {
                    if (this.menuHolder == null) break;
                    this.handleDisplayMenu(this.menuHolder, n3, this.popupHolder);
                }
            }
        }
        vector = null;
    }

    public void prepareHTTPRequest(int n, String string) {
        Runtime.getRuntime().gc();
        this.sbuf = new StringBuffer();
        switch (n) {
            case 1002: {
                this.sbuf.append("data_type=3000");
                this.sbuf.append(PreferencesManager.getPrefParameters());
                if (string == null) break;
                this.sbuf.append(string);
                break;
            }
            case 3001: {
                this.sbuf.append("data_type=3001");
                this.sbuf.append(PreferencesManager.getPrefParameters());
                if (string == null) break;
                this.sbuf.append(string);
                break;
            }
            default: {
                if (string != null) {
                    this.sbuf = new StringBuffer(PreferencesManager.getPrefParameters());
                }
                this.sbuf.append(string);
            }
        }
        string = null;
        this.executeHTTPRequest(this.sbuf, AccuweatherMain.SERVER_URL, this.display);
    }

    public void popSwitchScr() {
        BackNavMgr.getInstance().showStack();
        if (this.prev_SW_CUR_ID != 0 && BackNavMgr.scrStack.search(new Integer(this.prev_SW_CUR_ID)) != -1) {
            int n;
            do {
                n = BackNavMgr.getInstance().getCurrentScreenID();
                BackNavMgr.getInstance().popScreen();
                BackNavMgr.getInstance().showStack();
            } while (n != this.prev_SW_CUR_ID && !BackNavMgr.scrStack.empty());
            Vector vector = BackNavMgr.getInstance().getCurScrData();
            if (vector != null && vector.size() > 0) {
                CUR_SCREEN_ID = (Integer)vector.elementAt(0);
            }
            this.prev_SW_CUR_ID = 0;
            vector = null;
        }
        System.gc();
    }

    static {
        newpopup = false;
        partnerFlg = false;
        flg = false;
        preferences = null;
        locations = null;
    }
}

