/*
 * Decompiled with CFR 0.152.
 */
package accuweather;

import accuweather.AccuController;
import accuweather.AccuRMS;
import accuweather.DataUtility;
import accuweather.FCastDataHolder;
import com.emb.handler.DataParser;
import com.emb.handler.HttpHandler;
import com.emb.holder.BinaryHolder;
import com.emb.holder.ImageHolder;
import com.emb.holder.MenuHolder;
import com.emb.holder.TextHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class AccuParser
extends DataParser {
    public static final int FCAST = 10;
    public static final int PASSIVE_ACTION = 11;
    public static final int HURRICANE_LIST = 12;
    public static AccuParser instance = null;
    public static final int THREEDAYFCAST = 13;
    private FCastDataHolder fcData = null;
    private boolean newpopup = false;

    private AccuParser() {
        instance = this;
    }

    public static AccuParser getInstance() {
        if (instance == null) {
            new AccuParser();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector parseData(DataInputStream dataInputStream) {
        Vector<Object> vector = new Vector<Object>(4, 5);
        MenuHolder menuHolder = null;
        TextHolder textHolder = null;
        ImageHolder imageHolder = null;
        FCastDataHolder fCastDataHolder = null;
        BinaryHolder binaryHolder = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = "";
        String[] stringArray = null;
        String string2 = "";
        try {
            if (dataInputStream == null) {
                Vector vector2 = null;
                return vector2;
            }
            this.handleVersionControlData(dataInputStream);
            n = dataInputStream.readInt();
            block15: for (int i = 0; i < n; ++i) {
                string = dataInputStream.readUTF();
                stringArray = AccuParser.tokenizer(string, "#");
                string = null;
                if (stringArray != null && stringArray[0] != null) {
                    n3 = Integer.parseInt(stringArray[0]);
                }
                if (stringArray != null && stringArray[1] != null) {
                    n2 = Integer.parseInt(stringArray[1]);
                }
                if (stringArray != null && stringArray[2] != null) {
                    n4 = Integer.parseInt(stringArray[2]);
                }
                if (stringArray != null && stringArray[3] != null) {
                    string2 = stringArray[3];
                }
                if (stringArray != null && stringArray.length > 4 && stringArray[4] != null) {
                    n5 = Integer.parseInt(stringArray[4]);
                }
                switch (n2) {
                    case 1: 
                    case 4: {
                        if (this.newpopup) {
                            menuHolder = new MenuHolder(this.parseMenuData(dataInputStream, n4, string2, n2));
                            this.newpopup = false;
                        } else {
                            menuHolder = this.parseMenuData(dataInputStream, n4, string2, n2);
                        }
                        menuHolder.setCurrAcid(n2);
                        menuHolder.setDataType(n3);
                        menuHolder.setScreenId(n5);
                        vector.addElement(menuHolder);
                        menuHolder = null;
                        continue block15;
                    }
                    case 2: {
                        textHolder = this.parseTextData(dataInputStream, n4, string2);
                        textHolder.setCurrAcid(2);
                        textHolder.setDataType(n3);
                        textHolder.setScreenId(n5);
                        vector.addElement(textHolder);
                        textHolder = null;
                        continue block15;
                    }
                    case 3: {
                        String string3 = dataInputStream.readUTF();
                        imageHolder = this.parseImageData(dataInputStream, n4, string2);
                        imageHolder.setCurrAcid(3);
                        imageHolder.setDataType(n3);
                        imageHolder.setScreenId(n5);
                        String[] stringArray2 = DataParser.tokenizer(string3, "#");
                        imageHolder.key_src = Integer.parseInt(stringArray2[0]);
                        vector.addElement(imageHolder);
                        imageHolder = null;
                        string3 = null;
                        continue block15;
                    }
                    case 10: {
                        DataUtility.location = dataInputStream.readUTF();
                        fCastDataHolder = this.parseFcastData(dataInputStream, n4);
                        fCastDataHolder.setCurrAcid(10);
                        fCastDataHolder.setDataType(n3);
                        fCastDataHolder.setScreenId(n5);
                        vector.addElement(fCastDataHolder);
                        fCastDataHolder = null;
                        continue block15;
                    }
                    case 13: {
                        DataUtility.location = dataInputStream.readUTF();
                        fCastDataHolder = this.parseFcastData(dataInputStream, n4);
                        fCastDataHolder.setCurrAcid(13);
                        fCastDataHolder.setDataType(n3);
                        fCastDataHolder.setScreenId(n5);
                        vector.addElement(fCastDataHolder);
                        fCastDataHolder = null;
                        continue block15;
                    }
                    case 11: {
                        if (n3 == 200 || n3 == 202) {
                            textHolder = this.parseTextData(dataInputStream, n4, string2);
                            textHolder.setCurrAcid(11);
                            textHolder.setDataType(n3);
                            textHolder.setScreenId(n5);
                            vector.addElement(textHolder);
                            textHolder = null;
                            continue block15;
                        }
                        if (n3 == 204) {
                            String string4 = dataInputStream.readUTF();
                            binaryHolder = this.parseBinaryData(dataInputStream, n4);
                            binaryHolder.verno = string4;
                            binaryHolder.setCurrAcid(11);
                            binaryHolder.setDataType(n3);
                            binaryHolder.setScreenId(n5);
                            vector.addElement(binaryHolder);
                            binaryHolder = null;
                            string4 = null;
                            continue block15;
                        }
                        if (n3 != 300) continue block15;
                        DataUtility.black_out_start = dataInputStream.readUTF();
                        DataUtility.black_out_end = dataInputStream.readUTF();
                        binaryHolder = new BinaryHolder();
                        binaryHolder.setCurrAcid(11);
                        binaryHolder.setDataType(n3);
                        binaryHolder.setScreenId(n5);
                        vector.addElement(binaryHolder);
                        binaryHolder = null;
                        continue block15;
                    }
                    case 12: {
                        menuHolder = this.parseMenuData(dataInputStream, n4, string2, 1);
                        menuHolder.setCurrAcid(n2);
                        menuHolder.setDataType(n3);
                        menuHolder.setScreenId(n5);
                        vector.addElement(menuHolder);
                        vector.addElement(dataInputStream.readUTF());
                        menuHolder = null;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AccuController.controller.handleError(HttpHandler.PREV_ID, "An error occured please try again later");
            Vector vector3 = null;
            return vector3;
        }
        finally {
            menuHolder = null;
            textHolder = null;
            imageHolder = null;
            fCastDataHolder = null;
        }
        return vector;
    }

    public FCastDataHolder parseFcastData(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = 0;
        byte[] byArray = null;
        String string = "";
        if (this.fcData == null) {
            this.fcData = new FCastDataHolder();
        }
        this.fcData.setSize(n);
        for (int i = 0; i < n; ++i) {
            this.fcData.header1[i] = string = dataInputStream.readUTF();
            this.fcData.header2[i] = string = dataInputStream.readUTF();
            this.fcData.bdyText[i] = string = dataInputStream.readUTF();
            n2 = dataInputStream.readInt();
            if (n2 <= 0) continue;
            byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            this.fcData.icon[i] = Image.createImage((byte[])byArray, (int)0, (int)n2);
        }
        return this.fcData;
    }

    public void handleVersionControlData(DataInputStream dataInputStream) throws IOException {
        String string = "";
        if (dataInputStream == null) {
            return;
        }
        string = dataInputStream.readUTF();
        if (AccuRMS.getAccuXID() == null && string != null && string.trim().length() > 0) {
            AccuRMS.storeAccuXID(string);
        }
        String string2 = dataInputStream.readUTF();
        String string3 = dataInputStream.readUTF();
        AccuRMS.storeTicker(string2, string3);
        string2 = null;
        string3 = null;
        string = null;
    }
}

