/*
 * Decompiled with CFR 0.152.
 */
package accuweather;

import accuweather.AccuController;
import accuweather.AccuRMS;
import accuweather.DataUtility;
import accuweather.Locations;
import com.emb.handler.DataParser;
import com.emb.handler.StoreManager;
import com.emb.holder.MenuHolder;
import java.util.Vector;

public class LocationManager {
    public static final int VALID_DATA = 0;
    public static final int ALL_EMPTY = 1;
    public static final int INVALID_ZIP = 2;
    public static final int INVALID_POST = 3;
    public static final int INVALID_CITY = 4;
    public static final int DUPLICATE_DATA = 5;
    public static Locations locObj = new Locations();
    public static Locations inputObj = new Locations();

    public MenuHolder populateAllLocation() {
        MenuHolder menuHolder = MenuHolder.getMenuInstance();
        Vector vector = null;
        try {
            vector = AccuRMS.getAllLocations();
            if (vector != null) {
                int n = vector.size() - 1;
                menuHolder.setSize(n);
                menuHolder.setTitle(DataUtility.getFilterText("Locations|Ciudades|St\u00e4dte|Emplacements|Luoghi"));
                int n2 = AccuRMS.getDefaultLocation();
                if (n2 == -1) {
                    AccuRMS.setDefaultLocation(1);
                    n2 = 1;
                }
                menuHolder.addItem(1, "*", 0, "");
                for (int i = 1; i < vector.size(); ++i) {
                    String[] stringArray = DataParser.tokenizer((String)vector.elementAt(i), "|");
                    if (AccuController.preferences.langPref == 0) {
                        if (i == n2) {
                            menuHolder.addItemAt(0, 0, "*" + stringArray[2] + ", " + stringArray[1], 0, (String)vector.elementAt(i) + "|" + i);
                            continue;
                        }
                        menuHolder.addItem(i, stringArray[2] + ", " + stringArray[1], 0, (String)vector.elementAt(i) + "|" + i);
                        continue;
                    }
                    if (AccuController.preferences.langPref == 1) {
                        if (i == n2) {
                            menuHolder.addItemAt(0, 0, "*" + stringArray[4] + ", " + stringArray[3], 0, (String)vector.elementAt(i) + "|" + i);
                            continue;
                        }
                        menuHolder.addItem(i, stringArray[4] + ", " + stringArray[3], 0, (String)vector.elementAt(i) + "|" + i);
                        continue;
                    }
                    if (AccuController.preferences.langPref == 2) {
                        if (i == n2) {
                            menuHolder.addItemAt(0, 0, "*" + stringArray[6] + ", " + stringArray[5], 0, (String)vector.elementAt(i) + "|" + i);
                            continue;
                        }
                        menuHolder.addItem(i, stringArray[6] + ", " + stringArray[5], 0, (String)vector.elementAt(i) + "|" + i);
                        continue;
                    }
                    if (AccuController.preferences.langPref == 3) {
                        if (i == n2) {
                            menuHolder.addItemAt(0, 0, "*" + stringArray[8] + ", " + stringArray[7], 0, (String)vector.elementAt(i) + "|" + i);
                            continue;
                        }
                        menuHolder.addItem(i, stringArray[8] + ", " + stringArray[7], 0, (String)vector.elementAt(i) + "|" + i);
                        continue;
                    }
                    if (AccuController.preferences.langPref != 4) continue;
                    if (i == n2) {
                        menuHolder.addItemAt(0, 0, "*" + stringArray[10] + ", " + stringArray[9], 0, (String)vector.elementAt(i) + "|" + i);
                        continue;
                    }
                    menuHolder.addItem(i, stringArray[10] + ", " + stringArray[9], 0, (String)vector.elementAt(i) + "|" + i);
                }
                return menuHolder;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static int getNoOfLocation() {
        try {
            if (StoreManager.isRSExists("locations")) {
                return StoreManager.getNumRecords("locations") - 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public void loadLocation(int n) {
        String[] stringArray = null;
        try {
            stringArray = AccuRMS.getLocationInfo(n + 1);
            if (stringArray != null) {
                AccuController.locations.region_code = stringArray[0];
                if (AccuController.preferences.langPref == 0) {
                    AccuController.locations.country = stringArray[1];
                    AccuController.locations.city = stringArray[2];
                } else if (AccuController.preferences.langPref == 1) {
                    AccuController.locations.country_sp = stringArray[3];
                    AccuController.locations.city_sp = stringArray[4];
                } else if (AccuController.preferences.langPref == 2) {
                    AccuController.locations.country_de = stringArray[5];
                    AccuController.locations.city_de = stringArray[6];
                } else if (AccuController.preferences.langPref == 3) {
                    AccuController.locations.country_fr = stringArray[7];
                    AccuController.locations.city_fr = stringArray[8];
                } else if (AccuController.preferences.langPref == 4) {
                    AccuController.locations.country_it = stringArray[9];
                    AccuController.locations.city_it = stringArray[10];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadDefaultLocation() {
        try {
            this.loadLocation(AccuRMS.getDefaultLocation());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean getInputStatus() {
        return LocationManager.inputObj.region_code != null && LocationManager.inputObj.region_code.trim().length() != 0 || LocationManager.inputObj.city != null && LocationManager.inputObj.city.trim().length() != 0 || LocationManager.inputObj.country != null && LocationManager.inputObj.country.trim().length() != 0 || LocationManager.inputObj.city_sp != null && LocationManager.inputObj.city_sp.trim().length() != 0 || LocationManager.inputObj.country_sp != null && LocationManager.inputObj.country_sp.trim().length() != 0 || LocationManager.inputObj.city_de != null && LocationManager.inputObj.city_de.trim().length() != 0 || LocationManager.inputObj.country_de != null && LocationManager.inputObj.country_de.trim().length() != 0 || LocationManager.inputObj.city_fr != null && LocationManager.inputObj.city_fr.trim().length() != 0 || LocationManager.inputObj.country_fr != null && LocationManager.inputObj.country_fr.trim().length() != 0 || LocationManager.inputObj.city_it != null && LocationManager.inputObj.city_it.trim().length() != 0 || LocationManager.inputObj.country_it != null && LocationManager.inputObj.country_it.trim().length() != 0;
    }
}

