/*
 * Decompiled with CFR 0.152.
 */
package com.emb.widget;

import accuweather.DataUtility;
import com.emb.widget.Widget;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Menu
extends Widget {
    public int HDR_TXT_BG_CLR = 13158;
    public int HDR_TXT_CLR = 16773970;
    public int MENU_CLR = 13158;
    public int SEP_CLR = 0xFFFFFF;
    public int HDR_SEP_CLR = 13158;
    public int SEL_ITEM_CLR = 0;
    public int SCR_BAR_CLR = 0x2FFFFF;
    public int SCRL_CLR = 0x800000;
    public int ITEM_CLR = 16769891;
    public int SEL_ITM_BG_CLR = 0xFFFFFF;
    public int ITM_BG_CLR = 6514175;
    public int TICKER_STEP = 2;
    protected String header;
    protected Vector itemId = new Vector(10, 5);
    public Vector itemName = new Vector(10, 5);
    protected Vector actionId = new Vector(10, 5);
    protected Vector data = new Vector(10, 5);
    protected int selectedIdex = 0;
    public Font fnt;
    protected Font hFnt;
    protected int fh;
    protected Image iScroll;
    protected Image iMsup;
    protected Image iMsdown;
    protected Image menuArrow;
    int charWidth;
    int noofHchar;
    int noItemDis;
    public static boolean MENU_ON_BACKGROUND = false;
    public static int TICKER_STATUS = 0;
    public static final int TICKER_RUNNING = 1;
    public static final int TICKER_STOP = 0;
    public static Menu instance = null;
    int elemStart = 0;
    MenuTicker task;
    Timer timer = null;
    int scrollTxtPos;
    static boolean arrow = false;
    public static final Command SELECT_COMMAND = new Command("", 1, 0);
    public static final Command NUMKEYS_COMMAND = new Command("", 1, 0);

    public static Menu getInstance(int n, int n2, int n3, int n4, Canvas canvas) {
        if (instance == null) {
            new Menu(n, n2, n3, n4, canvas);
        } else {
            instance.setXPosition(n);
            instance.setYPosition(n2);
            instance.setWidth(n3 - 5);
            instance.setHeight(n4);
            Menu.instance.selectedIdex = 0;
        }
        return instance;
    }

    private Menu(int n, int n2, int n3, int n4, Canvas canvas) {
        this.createResources();
        this.charWidth = this.hFnt.stringWidth("W");
        this.fh = this.fnt.getHeight();
        this.width = n3 - 5;
        this.height = n4 - 5;
        this.setXPosition(n);
        this.setYPosition(n2);
        this.can = canvas;
        this.selectedIdex = 0;
        instance = this;
    }

    public void createResources() {
        try {
            this.fnt = DataUtility.FONT;
            this.hFnt = DataUtility.TFONT;
            if (this.iMsup == null) {
                this.iMsup = Image.createImage((String)"/msup.png");
            }
            if (this.iMsdown == null) {
                this.iMsdown = Image.createImage((String)"/msdown.png");
            }
            if (this.menuArrow == null) {
                this.menuArrow = Image.createImage((String)"/menu_arrow.png");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHeader(String string) {
        this.header = string;
    }

    public void setItemName(int n, String string) {
        this.itemName.setElementAt(string, n);
    }

    public String getItemName(int n) {
        return (String)this.itemName.elementAt(n);
    }

    public void setMenuData(int[] nArray, String[] stringArray, int[] nArray2, String[] stringArray2, String string) {
        String string2 = "";
        String string3 = "";
        this.elemStart = 0;
        if (stringArray != null) {
            this.itemId.removeAllElements();
            this.itemName.removeAllElements();
            this.actionId.removeAllElements();
            this.data.removeAllElements();
            this.setHeader(string);
            this.height = stringArray.length * this.fh < this.height / this.fh ? stringArray.length * this.fh : (this.height -= this.fh);
            for (int i = 0; i < stringArray.length; ++i) {
                int n = nArray == null ? -1 : nArray[i];
                string2 = stringArray == null ? "" : stringArray[i];
                int n2 = nArray2 == null ? -1 : nArray2[i];
                string3 = stringArray2 == null ? "" : stringArray2[i];
                this.addItem(n, string2, n2, string3);
                n = -1;
                string2 = "";
                n2 = -1;
                string3 = "";
            }
        }
    }

    public void addItem(int n, String string, int n2, String string2) {
        this.itemId.addElement(new Integer(n));
        this.itemName.addElement(string);
        this.actionId.addElement(new Integer(n2));
        this.data.addElement(string2);
    }

    public void addItem(int n, int n2, String string, int n3, String string2) {
        this.itemId.insertElementAt(new Integer(n2), n);
        this.itemName.insertElementAt(string, n);
        this.actionId.insertElementAt(new Integer(n3), n);
        this.data.insertElementAt(string2, n);
    }

    public int getSelectedId() {
        return (Integer)this.itemId.elementAt(this.selectedIdex);
    }

    public String getSelectedName() {
        return (String)this.itemName.elementAt(this.selectedIdex);
    }

    public int getSelectedActionId() {
        return (Integer)this.actionId.elementAt(this.selectedIdex);
    }

    public String getSelectedData() {
        return (String)this.data.elementAt(this.selectedIdex);
    }

    public void setSelectedItem(int n) {
        if (n >= 0 && n < this.itemId.size()) {
            this.selectedIdex = n;
        }
    }

    public void setHeaderFont(Font font) {
        this.hFnt = font;
    }

    public void setItemFont(Font font) {
        this.fnt = font;
    }

    public void drawHeader(Graphics graphics) {
        if (this.header != null && this.header.trim().length() > 0) {
            graphics.setFont(this.hFnt);
            int n = this.hFnt.stringWidth(this.header);
            int n2 = 0;
            n2 = n <= this.width ? (this.width - n) / 2 : 0;
            if (!MENU_ON_BACKGROUND) {
                graphics.setColor(this.HDR_TXT_BG_CLR);
                graphics.fillRect(this.x_origin, this.y_origin, this.width, this.fh + 1);
            }
            graphics.setColor(this.SEP_CLR);
            if (!MENU_ON_BACKGROUND) {
                graphics.drawLine(this.x_origin + 1, this.y_origin + this.fh + 1, this.x_origin + this.width - 2, this.y_origin + this.fh + 1);
            }
            graphics.setColor(this.HDR_TXT_CLR);
            graphics.drawString(this.header, this.x_origin + n2, this.y_origin + 1, 20);
        }
    }

    public void show(Graphics graphics) {
        try {
            if (this.fnt != null) {
                this.fh = this.fnt.getHeight() + 1;
            }
            this.noofHchar = (this.width - 5) / this.charWidth;
            this.noItemDis = this.height / this.fh;
            this.drawHeader(graphics);
            this.paintList(graphics);
            this.drawScroll(graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paintItem(Graphics graphics, int n, int n2, String string, boolean bl, boolean bl2) {
        int n3 = 0;
        String string2 = "";
        graphics.setFont(this.fnt);
        if (this.itemName.size() > this.noItemDis) {
            n3 = 3;
        }
        graphics.setGrayScale(255);
        if (!MENU_ON_BACKGROUND) {
            graphics.setColor(this.SEP_CLR);
            graphics.fillRoundRect(n - 1, n2 - 2, this.width + 1, this.fh + 2, 2, 1);
        }
        if (bl) {
            graphics.setColor(this.SEL_ITM_BG_CLR);
            graphics.fillRoundRect(n, n2, this.width - n3, this.fh, 2, 1);
            graphics.setColor(this.SEL_ITEM_CLR);
        } else {
            if (!MENU_ON_BACKGROUND) {
                graphics.setColor(this.ITM_BG_CLR);
                graphics.fillRoundRect(n, n2, this.width - n3, this.fh + 2, 2, 1);
            }
            graphics.setColor(this.ITEM_CLR);
        }
        int n4 = this.fnt.stringWidth(string);
        if (bl2 && this.menuArrow != null) {
            n4 += this.menuArrow.getWidth();
        }
        if (bl) {
            // empty if block
        }
        if (n4 + (this.can.getWidth() - this.width - this.getXPosition()) > this.width && bl) {
            string2 = this.getStrip(string, this.width - 12, this.scrollTxtPos);
            if (string2.length() == 0) {
                this.scrollTxtPos = 0;
            }
            if (TICKER_STATUS == 0) {
                this.startTicker();
            }
            if (bl2 && this.menuArrow != null) {
                graphics.drawImage(this.menuArrow, n, n2 + 3, 0);
                graphics.drawString(this.getStrip(string, this.width, this.scrollTxtPos), this.menuArrow.getWidth() + n + 2, n2, 20);
            } else {
                graphics.drawString(this.getStrip(string, this.width, this.scrollTxtPos), n + 2, n2, 20);
            }
        } else if (n4 >= this.width - this.getXPosition()) {
            if (bl2 && this.menuArrow != null) {
                graphics.drawImage(this.menuArrow, n, n2 + 3, 0);
                graphics.drawString(this.getStrip(string, this.width, 0), this.menuArrow.getWidth() + n + 2, n2, 20);
            } else {
                graphics.drawString(this.getStrip(string, this.width, 0), n + 2, n2, 20);
            }
        } else if (bl2 && this.menuArrow != null) {
            graphics.drawImage(this.menuArrow, n, n2 + 3, 0);
            graphics.drawString(string, this.menuArrow.getWidth() + n + 2, n2, 20);
        } else {
            graphics.drawString(string, n + 2, n2, 20);
        }
        if (MENU_ON_BACKGROUND) {
            graphics.setColor(this.SEP_CLR);
            graphics.drawLine(n + 1, n2, this.width - 2, n2);
        }
    }

    public void paintList(Graphics graphics) {
        int n = this.y_origin + 3;
        boolean bl = false;
        int n2 = 0;
        for (int i = this.elemStart; i < this.itemName.size() && n2 < this.noItemDis; ++i) {
            ++n2;
            bl = i == this.selectedIdex;
            if (i >= 0) {
                n += this.fh;
            }
            arrow = this.actionId != null && this.actionId.size() > i && (Integer)this.itemId.elementAt(i) != 1000 && (Integer)this.actionId.elementAt(i) == 2;
            if (i >= this.itemName.size() || i < 0) continue;
            this.paintItem(graphics, this.x_origin, n, (String)this.itemName.elementAt(i), bl, arrow);
        }
        graphics.setColor(this.SEP_CLR);
        graphics.drawLine(this.x_origin - 1, n + this.fh, this.x_origin + this.width - 1, n + this.fh);
    }

    public void drawScroll(Graphics graphics) {
        if (this.itemName.size() > this.noItemDis) {
            graphics.setColor(this.SCR_BAR_CLR);
            graphics.drawImage(this.iMsup, this.x_origin + this.width - 5, this.y_origin + this.fh, 20);
            graphics.fillRoundRect(this.x_origin + this.width - 4, this.y_origin + this.iMsup.getHeight() + this.fh, 4, this.noItemDis * this.fh, 2, 3);
            graphics.drawImage(this.iMsdown, this.x_origin + this.width - 5, this.y_origin + this.noItemDis * this.fh + this.fh, 20);
            int n = (this.noItemDis * this.fh - this.iMsup.getHeight() - this.iMsdown.getHeight()) / this.itemName.size();
            int n2 = (this.noItemDis * this.fh - this.iMsup.getHeight() - this.iMsdown.getHeight()) % this.itemName.size();
            int n3 = n;
            n = this.selectedIdex * n + this.fh - 2;
            graphics.setColor(this.SCRL_CLR);
            graphics.fillRect(this.x_origin + this.width - 3, this.y_origin + this.iMsup.getHeight() + n + 2, 2, n3 + n2 + 4);
        }
    }

    public void startTicker() {
        if (this.task == null) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.task = new MenuTicker();
            this.timer.schedule((TimerTask)this.task, 0L, 30L);
            TICKER_STATUS = 1;
        }
    }

    public void stopTicker() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.timer != null) {
            this.timer = null;
        }
        TICKER_STATUS = 0;
    }

    public void keyReleased(int n) {
        this.stopTicker();
        if (n < 0) {
            n = this.can.getGameAction(n);
        }
        switch (n) {
            case 1: {
                if ((this.selectedIdex == this.elemStart || this.selectedIdex - this.elemStart > this.noItemDis) && this.elemStart > 0) {
                    --this.elemStart;
                }
                if (this.selectedIdex > 0) {
                    --this.selectedIdex;
                    break;
                }
                if (this.selectedIdex != 0) break;
                this.selectedIdex = this.itemName.size() - 1;
                this.elemStart = this.itemName.size() - this.noItemDis;
                if (this.elemStart >= 0) break;
                this.elemStart = 0;
                break;
            }
            case 6: {
                if (this.selectedIdex >= this.noItemDis - 1 && this.itemName.size() - this.elemStart > this.noItemDis) {
                    ++this.elemStart;
                }
                if (this.selectedIdex < this.itemName.size() - 1) {
                    ++this.selectedIdex;
                    break;
                }
                if (this.selectedIdex != this.itemName.size() - 1) break;
                this.selectedIdex = 0;
                this.elemStart = 0;
            }
        }
        this.scrollTxtPos = 0;
    }

    public String getStrip(String string, int n, int n2) {
        int n3 = string.length();
        String string2 = "";
        int n4 = n;
        do {
            string2 = string.substring(n2, n3);
            n4 = this.fnt.stringWidth(string2);
            if (arrow && this.menuArrow != null) {
                n4 += this.menuArrow.getWidth() + 3;
            }
            --n3;
        } while (n4 >= n);
        if (string2.length() <= 0) {
            string2 = string;
        }
        return string2;
    }

    public boolean isKeyEvtRequired(int n) {
        boolean bl = true;
        if (n < 0) {
            n = this.can.getGameAction(n);
        }
        if (this.inFocus) {
            switch (n) {
                case 1: 
                case 6: 
                case 8: {
                    bl = true;
                    break;
                }
                case 2: 
                case 5: {
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private class MenuTicker
    extends TimerTask {
        String item = "";

        private MenuTicker() {
        }

        public void run() {
            try {
                if (Menu.this.itemName == null || Menu.this.itemName.size() == 0) {
                    return;
                }
                this.item = (String)Menu.this.itemName.elementAt(Menu.this.selectedIdex);
                int n = Menu.this.fnt.stringWidth(this.item);
                if (arrow && Menu.this.menuArrow != null) {
                    n += Menu.this.menuArrow.getWidth() + 3;
                }
                if (n + (Menu.this.can.getWidth() - Menu.this.width - Menu.this.getXPosition()) >= Menu.this.width) {
                    String string = Menu.this.getStrip(this.item, Menu.this.width, Menu.this.scrollTxtPos);
                    int n2 = Menu.this.fnt.stringWidth(string);
                    if (arrow && Menu.this.menuArrow != null) {
                        n2 += Menu.this.menuArrow.getWidth() + 3;
                    }
                    Menu.this.scrollTxtPos = n2 + (Menu.this.can.getWidth() - Menu.this.width + Menu.this.getXPosition()) < Menu.this.width ? 0 : ++Menu.this.scrollTxtPos;
                    Thread.sleep(500L);
                }
                Menu.this.can.repaint();
                Menu.this.can.serviceRepaints();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

