/*
 * Decompiled with CFR 0.152.
 */
package com.emb.widget;

import accuweather.DataUtility;
import com.emb.handler.DataParser;
import com.emb.widget.Widget;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextWindow
extends Widget {
    private String headerTxt;
    private String footerTxt;
    private String txt;
    public Font fnt = null;
    public Font headFnt = null;
    public Font footFnt = null;
    public int scrollSize = 1;
    public int bgClr = 0xD9D9D9;
    public int bordClr = 13158;
    public int fgClr = 0;
    private Vector sVec = null;
    private int noPages = -1;
    private int fSpace = 0;
    private int hSpace = 0;
    private int txtSpace = 1;
    private int scrollWidth = 3;
    private int scrollHeight = 10;
    private static int LINE_SPACING = 1;
    public int pageIndex = 0;
    private int noLines = -1;
    private int slide = 0;
    public boolean colorFlg = false;
    int centerYPos = -1;
    private int slidePos = 0;
    private int markingLines = 1;
    private int markedLines = 1;

    public TextWindow() {
    }

    public TextWindow(Canvas canvas) {
        this.fnt = DataUtility.FONT;
        this.headFnt = DataUtility.TFONT;
        this.footFnt = DataUtility.FONT;
        this.x_origin = 10;
        this.y_origin = 10;
        this.width = canvas.getWidth() - this.x_origin - this.y_origin - 8;
        this.height = canvas.getHeight() - this.x_origin - this.y_origin - 8;
    }

    public TextWindow(int n, int n2, int n3, int n4) {
        this.x_origin = n;
        this.y_origin = n2;
        this.fnt = DataUtility.FONT;
        this.headFnt = DataUtility.TFONT;
        this.footFnt = DataUtility.FONT;
        this.width = n3;
        this.height = n4;
    }

    public void setText(String string) {
        this.formatDisplayArea();
        this.markingLines = 1;
        this.txt = string + "\n";
        this.sVec = this.splitText(this.txt, this.width);
        this.noPages = this.calculatePageSize(this.sVec.size());
        if (this.scrollSize > this.noLines) {
            this.scrollSize = this.noLines;
            this.noPages = this.calculatePageSize(this.sVec.size());
        }
        if (this.sVec.size() / this.noLines < 1) {
            this.noPages = 1;
            this.scrollSize = this.noLines;
        }
    }

    public void setHeader(String string) {
        Vector vector = null;
        this.hSpace = 0;
        if (string == null || string.trim().length() < 1) {
            this.headerTxt = "";
            return;
        }
        this.headerTxt = string;
        if (this.fnt.stringWidth(this.headerTxt) > this.width) {
            vector = new Vector();
            vector = this.splitText(this.headerTxt, this.width);
            String string2 = (String)vector.elementAt(0);
            this.headerTxt = string2.substring(0, string2.length() - 3);
            this.headerTxt = this.headerTxt + "...";
        }
        this.hSpace = this.fnt.getHeight();
    }

    public void setFooter(String string) {
        Vector vector = null;
        this.fSpace = 0;
        if (string == null || string.trim().length() < 1) {
            this.footerTxt = "";
            return;
        }
        this.footerTxt = string;
        if (this.fnt.stringWidth(this.footerTxt) > this.width) {
            vector = new Vector();
            vector = this.splitText(this.footerTxt, this.width);
            String string2 = (String)vector.elementAt(0);
            this.footerTxt = string2.substring(0, string2.length() - 3);
            this.footerTxt = this.footerTxt + "...";
        }
        this.fSpace = this.fnt.getHeight();
    }

    public void setBGColor(int n) {
        this.bgClr = n;
    }

    public void show(Graphics graphics) {
        if (graphics != null) {
            int n;
            graphics.setFont(this.fnt);
            graphics.setColor(this.bordClr);
            graphics.drawRoundRect(this.x_origin, this.y_origin, this.width, this.height, 5, 5);
            graphics.setColor(this.bordClr);
            graphics.drawRect(this.x_origin, this.y_origin, this.width, this.height);
            graphics.setColor(this.bgClr);
            graphics.fillRect(this.x_origin + LINE_SPACING, this.y_origin + LINE_SPACING, this.width - LINE_SPACING, this.height - LINE_SPACING);
            graphics.setColor(this.fgClr);
            int n2 = -1;
            n2 = this.centerYPos != -1 ? this.centerYPos : this.y_origin + 2;
            int n3 = this.x_origin + LINE_SPACING;
            this.fnt = graphics.getFont();
            if (this.headerTxt != null && this.headerTxt.length() > 0) {
                graphics.setFont(this.headFnt);
                graphics.drawString(this.headerTxt, this.width / 2 + this.x_origin, n2, 0x10 | 1);
                n2 += this.fnt.getHeight();
            }
            int n4 = this.pageIndex * this.scrollSize;
            graphics.setFont(this.fnt);
            for (n = 0; n < this.noLines; ++n) {
                if (n + n4 >= this.markedLines && n + n4 <= this.markingLines && this.colorFlg) {
                    graphics.setColor(0xFF0000);
                } else {
                    graphics.setColor(this.fgClr);
                }
                if (n + n4 < this.sVec.size()) {
                    if (this.centerYPos == -1) {
                        graphics.drawString((String)this.sVec.elementAt(n + n4), n3 + 1, n2, 0);
                    } else {
                        graphics.drawString((String)this.sVec.elementAt(n + n4), this.width / 2 + this.x_origin, n2, 0x10 | 1);
                    }
                }
                n2 += this.fnt.getHeight() + LINE_SPACING;
            }
            graphics.setColor(this.fgClr);
            if (this.noPages > 1) {
                this.slidePos = this.pageIndex + 1 >= this.noPages ? this.height - this.fSpace - this.hSpace - this.slide + this.hSpace + this.y_origin : this.slide * this.pageIndex + this.hSpace + this.y_origin;
                graphics.drawRect(this.x_origin + this.width - 3, this.hSpace + this.y_origin, this.scrollWidth, this.height - this.fSpace - this.hSpace);
                graphics.fillRect(this.x_origin + this.width - 3, this.slidePos, this.scrollWidth, this.slide);
            }
            if (this.footerTxt != null && this.footerTxt.length() > 0) {
                n = (this.width - this.footFnt.stringWidth(this.footerTxt)) / 2;
                n = n < 0 ? this.x_origin : (n += this.x_origin);
                graphics.setFont(this.footFnt);
                graphics.setColor(this.bordClr);
                graphics.drawLine(this.x_origin + 1, this.height + this.y_origin - this.footFnt.getHeight() - 2, this.x_origin + this.width - 1, this.height + this.y_origin - this.footFnt.getHeight() - 2);
                graphics.setColor(0xAFFFFF);
                graphics.fillRect(this.x_origin + 2, this.height + this.y_origin - this.footFnt.getHeight(), this.width - 2, this.footFnt.getHeight());
                graphics.setColor(0);
                graphics.drawString(this.footerTxt, n, this.height + this.y_origin - this.footFnt.getHeight(), 0);
            }
        }
    }

    public Vector splitText(String string, int n) {
        n -= 7;
        Vector<String> vector = null;
        String[] stringArray = DataParser.tokenizer(string, "\n");
        if (stringArray != null && stringArray.length > 0) {
            vector = new Vector<String>(5);
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == 2) {
                    this.markingLines = vector.size() - 1;
                }
                String string2 = stringArray[i];
                if (i == 0) {
                    this.markedLines = this.fnt.stringWidth(string2) < n ? 1 : 2;
                }
                if (this.fnt.stringWidth(string2) > n) {
                    this.markingLines = 2;
                    String[] stringArray2 = DataParser.tokenizer(string2, " ");
                    if (stringArray2 != null && stringArray2.length > 0) {
                        if (stringArray2.length == 1) {
                            if (this.fnt.stringWidth(stringArray2[0]) > n) {
                                this.splitAndAddWord(vector, stringArray2[0], n);
                            } else {
                                vector.addElement(stringArray2[0] + " ");
                            }
                        } else {
                            StringBuffer stringBuffer = null;
                            int n2 = 0;
                            while (n2 < stringArray2.length) {
                                if (this.fnt.stringWidth(stringArray2[n2]) > n) {
                                    this.splitAndAddWord(vector, stringArray2[n2], n);
                                    ++n2;
                                } else {
                                    if (stringArray2[n2].length() > 0) {
                                        vector.addElement(stringArray2[n2].trim() + " ");
                                    }
                                    ++n2;
                                }
                                if (vector.size() > 0) {
                                    stringBuffer = new StringBuffer((String)vector.lastElement());
                                }
                                while (n2 < stringArray2.length && stringBuffer != null && this.fnt.stringWidth(stringBuffer.toString()) + this.fnt.stringWidth(stringArray2[n2]) < n) {
                                    stringBuffer.append(" " + stringArray2[n2]);
                                    ++n2;
                                }
                                if (stringBuffer != null && stringBuffer.length() > 0) {
                                    vector.removeElementAt(vector.size() - 1);
                                    vector.addElement(stringBuffer.toString() + " ");
                                }
                                stringBuffer = null;
                            }
                        }
                    }
                    stringArray2 = null;
                    continue;
                }
                if (this.colorFlg) {
                    vector.addElement(string2.trim());
                    continue;
                }
                vector.addElement(string2);
            }
        }
        stringArray = null;
        string = null;
        return vector;
    }

    private void splitAndAddWord(Vector vector, String string, int n) {
        while (this.fnt.stringWidth(string) > n) {
            int n2 = this.splitWord(string, n - 8);
            String string2 = string.substring(0, n2) + "-";
            if (string.equals("http://www.accuweather.com/global/eula.")) {
                string2 = string.substring(0, n2);
            }
            vector.addElement(string2);
            string = string.substring(n2, string.length());
        }
        if (string != null && string.length() > 0) {
            vector.addElement(string + " ");
        }
    }

    private int splitWord(String string, int n) {
        int n2 = 0;
        if (this.fnt.stringWidth(string) < n) {
            n2 = string.length();
            string = null;
        } else {
            StringBuffer stringBuffer = new StringBuffer(string);
            while (this.fnt.stringWidth(stringBuffer.toString()) > n) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            n2 = stringBuffer.length();
            string = null;
            stringBuffer = null;
        }
        return n2;
    }

    private int splitWord(String string) {
        return this.splitWord(string, this.width);
    }

    private int calculatePageSize(int n) {
        int n2 = 0;
        this.slide = 0;
        int n3 = this.height - this.fSpace - this.hSpace;
        int n4 = this.fnt.getHeight() + 2;
        this.noLines = n3 / n4;
        if (this.hSpace != 0 && this.fSpace == 0) {
            --this.noLines;
        }
        if ((n2 = n / this.scrollSize) > 1) {
            n2 /= 2;
        }
        if (n3 % n4 != 0) {
            ++this.noLines;
        }
        if (n % this.scrollSize != 0) {
            ++n2;
        }
        if (this.hSpace == 0 && this.fSpace == 0) {
            --this.noLines;
        }
        if (this.scrollSize == 1) {
            n2 = n - this.noLines + 1;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        this.slide += (this.height - this.fSpace - this.hSpace) / n2;
        if ((this.height - this.fSpace - this.hSpace) % n2 != 0) {
            ++this.slide;
        }
        if (this.hSpace == 0 && this.fSpace != 0) {
            this.height -= 2;
        }
        if (this.hSpace == 0 && this.fSpace == 0) {
            this.height -= 2;
        }
        if (this.hSpace == 0 || this.fSpace == 0) {
            --this.slide;
        }
        return n2;
    }

    private void formatDisplayArea() {
        this.hSpace = this.headerTxt != null && this.headerTxt.trim().length() > 0 ? this.fnt.getHeight() : 0;
        this.fSpace = this.footerTxt != null && this.footerTxt.length() > 0 ? this.fnt.getHeight() : 0;
    }

    public void keyReleased(int n) {
        if (n < 0) {
            n = this.can.getGameAction(n);
        }
        if (this.inFocus) {
            switch (n) {
                case 1: {
                    if (this.pageIndex - 1 < 0) break;
                    --this.pageIndex;
                    break;
                }
                case 6: {
                    if (this.pageIndex + 1 >= this.noPages) break;
                    ++this.pageIndex;
                }
            }
        }
    }

    public void setVerticallyCenter() {
        this.centerYPos = this.y_origin + (this.height - this.fnt.getHeight() * 3 - this.fnt.getHeight() * this.sVec.size()) / 2;
        if (this.centerYPos < this.y_origin) {
            this.centerYPos = this.y_origin;
        }
    }

    public boolean isKeyEvtRequired(int n) {
        boolean bl = true;
        if (n < 0) {
            n = this.can.getGameAction(n);
        }
        if (this.inFocus) {
            switch (n) {
                case 1: {
                    if (this.pageIndex <= 0) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 6: {
                    if (this.pageIndex >= this.noPages - 1) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    break;
                }
                case 2: 
                case 5: {
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public String stringReplace(String string, String string2, String string3) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        int n2 = string2.length();
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n != -1) {
            stringBuffer.append(cArray, n3, n - n3);
            stringBuffer.append(string3);
            n3 = n + n2;
            n = string.indexOf(string2, n3);
        }
        stringBuffer.append(cArray, n3, cArray.length - n3);
        return stringBuffer.toString();
    }
}

