/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.controller;

import com.sonyericsson.audiopostcard.controller.Controller;
import com.sonyericsson.audiopostcard.model.InteractionModel;
import com.sonyericsson.audiopostcard.view.KeySetInterface;
import com.sonyericsson.ui.TextId;
import com.sonyericsson.ui.UIAlert;
import com.sonyericsson.ui.UIList;
import com.sonyericsson.ui.UIListHighlightChangedListener;
import com.sonyericsson.ui.UIListStateChangedListener;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.MediaException;

public class InputControl
implements KeySetInterface,
CommandListener,
UIListStateChangedListener,
UIListHighlightChangedListener {
    private final InteractionModel model;
    private final Controller controller;
    private Command backCommand;
    private Command addVoiceCommand;
    private Command sendCommand;
    private Command shortSendCommand;
    private Command stopCommand;
    private Command replayCommand;
    private Command rerecordCommand;
    private Command yesCommand;
    private Command noCommand;
    private Command okCommand;
    private Command cancelCommand;
    private Command cameraOptionInfoCommand;
    private Command nightmodeCommand;
    private Command selftimerCommand;
    private Command effectsCommand;
    private Command selectCommand;

    public InputControl(Controller controller, InteractionModel model) {
        this.model = model;
        this.controller = controller;
    }

    public void initialize() {
        this.backCommand = new Command(TextId.getString((int)3318), 2, 3);
        this.addVoiceCommand = new Command(TextId.getString((int)5808), 1, 1);
        this.sendCommand = new Command(TextId.getString((int)3469), 1, 2);
        this.shortSendCommand = new Command(TextId.getString((int)3469), 1, 2);
        this.stopCommand = new Command(TextId.getString((int)3477), 1, 1);
        this.replayCommand = new Command(TextId.getString((int)5814), 1, 5);
        this.rerecordCommand = new Command(TextId.getString((int)5815), 1, 5);
        this.yesCommand = new Command(TextId.getString((int)3493), 1, 5);
        this.noCommand = new Command(TextId.getString((int)3423), 1, 5);
        this.okCommand = new Command(TextId.getString((int)3428), 4, 1);
        this.cancelCommand = new Command(TextId.getString((int)3325), 3, 2);
        this.nightmodeCommand = new Command(TextId.getString((int)884), 1, 5);
        this.selftimerCommand = new Command(TextId.getString((int)917), 1, 5);
        this.effectsCommand = new Command(TextId.getString((int)712), 1, 5);
        this.cameraOptionInfoCommand = new Command(TextId.getString((int)3383), 1, 2);
        this.selectCommand = new Command(TextId.getString((int)699), 4, 1);
    }

    public void setUpStartState() throws IllegalStateException, MediaException {
        this.model.setupStartState();
    }

    public void commandAction(Command comm, Displayable disp) {
        boolean handled = false;
        if (this.controller.isApplicationPaused()) {
            handled = true;
        }
        if (!handled) {
            handled = this.handleGeneralCommand(comm);
        }
        if (!handled) {
            handled = this.handleMessagingCommand(comm);
        }
        if (!handled) {
            handled = this.handleMediaCommand(comm);
        }
        if (!handled) {
            handled = this.handleCameraCommand(comm);
        }
        if (!handled) {
            // empty if block
        }
    }

    private boolean handleMessagingCommand(Command comm) {
        boolean handled = true;
        if (comm.equals(this.sendCommand)) {
            this.handleCommand(2);
        } else if (comm.equals(this.shortSendCommand)) {
            this.handleCommand(3);
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean handleMediaCommand(Command comm) {
        boolean handled = true;
        if (comm.equals(this.addVoiceCommand)) {
            this.handleCommand(1);
        } else if (comm.equals(this.stopCommand)) {
            this.handleCommand(4);
        } else if (comm.equals(this.replayCommand)) {
            this.handleCommand(5);
        } else if (comm.equals(this.rerecordCommand)) {
            this.handleCommand(6);
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean handleGeneralCommand(Command comm) {
        boolean handled = true;
        if (comm.equals(this.backCommand)) {
            this.handleCommand(0);
        } else if (comm.equals(this.yesCommand)) {
            this.handleCommand(7);
        } else if (comm.equals(this.noCommand)) {
            this.handleCommand(8);
        } else if (comm.equals(this.okCommand)) {
            this.handleCommand(10);
        } else if (comm.equals(this.cancelCommand)) {
            this.handleCommand(11);
        } else if (comm.equals(this.selectCommand)) {
            this.handleCommand(9);
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean handleCameraCommand(Command comm) {
        boolean handled = true;
        if (comm.equals(this.nightmodeCommand)) {
            this.handleCommand(12);
        } else if (comm.equals(this.selftimerCommand)) {
            this.handleCommand(13);
        } else if (comm.equals(this.effectsCommand)) {
            this.handleCommand(14);
        } else if (comm.equals(this.cameraOptionInfoCommand)) {
            this.handleCommand(15);
        } else {
            handled = false;
        }
        return handled;
    }

    public void listStateChanged(UIList list) {
        this.model.performCameraOption(list);
        this.model.hideCameraList(true);
        try {
            this.model.revertState();
        }
        catch (IllegalStateException e) {
            this.shutdown();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void listHighlightChanged(UIList list) {
        this.model.updateCameraList(list);
    }

    public Command translateKeyToCommand(int keyType) {
        Command command = null;
        switch (keyType) {
            case 0: {
                command = this.backCommand;
                break;
            }
            case 1: {
                command = this.addVoiceCommand;
                break;
            }
            case 2: {
                command = this.sendCommand;
                break;
            }
            case 3: {
                command = this.shortSendCommand;
                break;
            }
            case 4: {
                command = this.stopCommand;
                break;
            }
            case 5: {
                command = this.replayCommand;
                break;
            }
            case 6: {
                command = this.rerecordCommand;
                break;
            }
            case 7: {
                command = this.yesCommand;
                break;
            }
            case 8: {
                command = this.noCommand;
                break;
            }
            case 9: {
                command = this.selectCommand;
                break;
            }
            case 11: {
                command = this.cancelCommand;
                break;
            }
            case 12: {
                command = this.nightmodeCommand;
                break;
            }
            case 13: {
                command = this.selftimerCommand;
                break;
            }
            case 14: {
                command = this.effectsCommand;
                break;
            }
            case 15: {
                command = this.cameraOptionInfoCommand;
                break;
            }
            case 10: {
                command = this.okCommand;
                break;
            }
        }
        return command;
    }

    public void handleKey(int keyCode) {
        switch (keyCode) {
            case 8: {
                this.handleCommand(16);
                break;
            }
            case 9: {
                this.handleCommand(17);
                break;
            }
            case 0: {
                this.handleCommand(18);
                break;
            }
            case 1: {
                this.handleCommand(19);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
        }
    }

    public void handleKeyPressed(int keyCode) {
        if (!this.controller.isApplicationPaused()) {
            this.handleKey(keyCode);
        }
    }

    public void handleCommand(int command) {
        if (this.model.isValidCommand(command) || this.model.isValidSpecialKey(command)) {
            this.handleCommandInNewThread(command);
        }
    }

    private void handleCommandInNewThread(int command) {
        Thread handler = new Thread(){
            int keyCode;

            public void run() {
                try {
                    InputControl.this.model.handleCommand(this.keyCode);
                    if (InputControl.this.model.isShutdown()) {
                        InputControl.this.shutdown();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public Thread setArgs(int keyArgument) {
                this.keyCode = keyArgument;
                return this;
            }
        }.setArgs(command);
        handler.start();
    }

    public boolean requestExit() {
        boolean doExit = this.model.requestExit();
        return doExit;
    }

    public boolean confirmExit() {
        boolean doExit = false;
        if (this.model.isDirectExitPermitted()) {
            doExit = true;
        } else {
            this.model.pause();
            boolean audioRecorded = this.model.isContentCreated();
            doExit = this.askUserIfExitRequested(audioRecorded);
            this.model.resume();
        }
        return doExit;
    }

    private boolean askUserIfExitRequested(boolean audioRecorded) {
        ExitDialogHandler exitDialogHandler = new ExitDialogHandler();
        int[] commands = exitDialogHandler.getExitDialogCommands();
        int textMessage = audioRecorded ? 5812 : 6079;
        String message = TextId.getString((int)textMessage);
        UIAlert alert = new UIAlert(message, 4);
        int index = 0;
        while (index < commands.length) {
            alert.addCommand(this.translateKeyToCommand(commands[index]));
            ++index;
        }
        alert.setCommandListener((CommandListener)exitDialogHandler);
        Displayable previousDisplayable = this.controller.getDisplay().getCurrent();
        this.controller.getDisplay().setCurrent((Displayable)alert);
        boolean doExit = exitDialogHandler.isExitRequested();
        this.controller.getDisplay().setCurrent(previousDisplayable);
        return doExit;
    }

    private void shutdown() {
        if (this.controller != null) {
            this.controller.shutdown();
        }
    }

    public void pause() {
        this.model.pause();
    }

    public void resume() {
        this.model.resume();
    }

    public void cancelCloseAfterTransfers() {
        this.model.cancelCloseAfterTransfers();
    }

    private class ExitDialogHandler
    implements CommandListener {
        private int selectedCommand = 0;
        private boolean isSelected = false;
        private final int[] commands = new int[]{10, 11};

        private ExitDialogHandler() {
        }

        public void commandAction(Command command, Displayable displayable) {
            int index = 0;
            while (index < this.commands.length) {
                if (InputControl.this.translateKeyToCommand(this.commands[index]) == command) {
                    this.selectedCommand = this.commands[index];
                    this.isSelected = true;
                    break;
                }
                ++index;
            }
        }

        public int[] getExitDialogCommands() {
            return this.commands;
        }

        public boolean isExitRequested() {
            while (!this.isSelected) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.selectedCommand == 10;
        }
    }
}

