/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.ActionManagerListener;
import com.sonyericsson.audiopostcard.model.CommandHandler;
import com.sonyericsson.audiopostcard.model.FreezeMode;
import com.sonyericsson.audiopostcard.model.ModelInterface;
import com.sonyericsson.audiopostcard.model.ModelListenerInterface;
import com.sonyericsson.audiopostcard.model.PresentationManager;
import com.sonyericsson.audiopostcard.model.SendMode;
import com.sonyericsson.audiopostcard.model.StateHandler;
import com.sonyericsson.audiopostcard.model.ViewFinderMode;
import com.sonyericsson.ui.UIList;
import javax.microedition.media.MediaException;

class ActionManager
implements ActionManagerListener {
    private final PresentationManager presentationManager = new PresentationManager();
    private final StateHandler stateHandler = new StateHandler();
    private final ViewFinderMode viewFinderMode = new ViewFinderMode(this, this.presentationManager, this.stateHandler);
    private final FreezeMode freezeMode = new FreezeMode(this.presentationManager, this.stateHandler, this);
    private final SendMode sendMode = new SendMode(this.presentationManager, this.stateHandler);
    private boolean busyHandlingKey = false;
    private boolean closeAfterTransfers = false;

    public void pauseResources() {
        this.freezeMode.pause();
        this.viewFinderMode.pause();
    }

    public void resumeResources() {
        if (this.closeAfterTransfers) {
            this.stopWaitingForTransfers();
        }
        this.freezeMode.resume();
        this.viewFinderMode.resume();
        this.presentationManager.requestUpdateViews();
    }

    public boolean isShutdown() {
        return this.stateHandler.getState() == 0;
    }

    public boolean isDirectExitPermitted() {
        return this.stateHandler.isDirectExitPermitted();
    }

    public boolean isAudioRecorded() {
        return this.stateHandler.isAudioRecorded();
    }

    public void initializeVideo() {
        this.viewFinderMode.prepareVideoFeed();
    }

    public void setupLoadingState() {
        this.viewFinderMode.reset();
        this.presentationManager.reset();
        this.stateHandler.setInitialScreenShown(true);
        this.presentationManager.showPanel(false);
        this.presentationManager.showVideoPanel(false);
        this.presentationManager.showImage(null, true);
    }

    public void setupStartState() throws MediaException {
        boolean state = true;
        this.stateHandler.setFrameIndex(0);
        this.initializeVideo();
        this.transit(1);
    }

    public ModelInterface getModelInterface() {
        return this.presentationManager;
    }

    public void addView(ModelListenerInterface viewInterface) {
        this.presentationManager.addView(viewInterface);
    }

    public void setContactInfo(String contactPhoneNbr, String contactName, String contactImageUrl) {
        this.stateHandler.setContactPhoneNbr(contactPhoneNbr);
        this.stateHandler.setContactName(contactName);
        this.stateHandler.setContactImageUrl(contactImageUrl);
    }

    public void performCameraOption(UIList cameraList) {
        this.viewFinderMode.performCameraOption(cameraList);
    }

    public void hideCameraList(boolean doViewUpdate) {
        this.viewFinderMode.hideCameraList(doViewUpdate);
    }

    public void updateCameraList(UIList cameraList) {
        this.viewFinderMode.updateCameraList(cameraList);
    }

    public void shutdown(boolean requested) {
        if (!requested) {
            // empty if block
        }
        try {
            this.viewFinderMode.shutdown();
        }
        catch (MediaException mediaException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.freezeMode.shutdown();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        this.stateHandler.setState(0);
    }

    public boolean requestExit() {
        boolean doExit = this.minimizeAndWaitForShutdown();
        if (doExit) {
            this.shutdown(true);
        }
        return doExit;
    }

    /*
     * Exception decompiling
     */
    public void handleCommand(int key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isValidCommand(int command) {
        int[] commandSet = null;
        switch (this.stateHandler.getState()) {
            case 1: {
                commandSet = CommandHandler.COMMANDS_VIEWFINDER;
                break;
            }
            case 2: {
                commandSet = CommandHandler.COMMANDS_ADD_VOICE_OR_SEND;
                break;
            }
            case 3: {
                commandSet = CommandHandler.COMMANDS_RECORD_VOICE;
                break;
            }
            case 6: {
                commandSet = CommandHandler.COMMANDS_PLAY_VOICE;
                break;
            }
            case 7: {
                commandSet = CommandHandler.COMMANDS_DISCARD_REC_PROMPT;
                break;
            }
            case 4: {
                commandSet = CommandHandler.COMMANDS_SEND_AUDIO_VIDEO;
                break;
            }
            case 5: {
                commandSet = CommandHandler.COMMANDS_SEND_MMS;
                break;
            }
            case 8: {
                commandSet = CommandHandler.COMMANDS_CAMERA_OPTIONS;
            }
        }
        return this.isValidOption(command, commandSet);
    }

    public boolean isValidSpecialKey(int key) {
        int[] specialKeys = null;
        switch (this.stateHandler.getState()) {
            case 1: {
                specialKeys = CommandHandler.SPECIAL_KEYS_VIEWFINDER;
                break;
            }
            case 2: {
                specialKeys = CommandHandler.SPECIAL_KEYS_ADD_VOICE_OR_SEND;
                break;
            }
            case 3: {
                specialKeys = CommandHandler.SPECIAL_KEYS_RECORD_VOICE;
                break;
            }
            case 6: {
                specialKeys = CommandHandler.SPECIAL_KEYS_PLAY_VOICE;
                break;
            }
            case 7: {
                specialKeys = CommandHandler.SPECIAL_KEYS_DISCARD_REC_PROMPT;
                break;
            }
            case 4: {
                specialKeys = CommandHandler.SPECIAL_KEYS_SEND_AUDIO_VIDEO;
                break;
            }
            case 5: {
                specialKeys = CommandHandler.SPECIAL_KEYS_SEND_MMS;
                break;
            }
            case 8: {
                specialKeys = CommandHandler.SPECIAL_KEYS_CAMERA_OPTIONS;
            }
        }
        return this.isValidOption(key, specialKeys);
    }

    private boolean isValidOption(int option, int[] optionSet) {
        boolean isValid = false;
        if (optionSet != null) {
            int index = 0;
            while (index < optionSet.length) {
                if (option == optionSet[index]) {
                    isValid = true;
                    break;
                }
                ++index;
            }
        }
        return isValid;
    }

    private void handleKey(int key) throws MediaException, IllegalStateException, OutOfMemoryError {
        switch (this.stateHandler.getState()) {
            case 1: {
                this.viewFinderMode.handleKeyViewFinder(key);
                break;
            }
            case 2: {
                this.freezeMode.handleKeyAddVoiceOrSend(key);
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.freezeMode.handleKeyDiscardRecPrompt(key);
                break;
            }
            case 4: {
                this.freezeMode.handleKeySendAudioVideo(key);
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                this.viewFinderMode.handleKeyCameraOptions(key);
            }
        }
    }

    private void handleKeyWhileBusy(int key) throws MediaException {
        switch (this.stateHandler.getState()) {
            case 1: {
                if (16 != key && 17 != key) break;
                this.viewFinderMode.stopTimerIfActive();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.freezeMode.handleKeyRecordVoice(key);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.freezeMode.handleKeyPlayVoice(key);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
    }

    public void handleState() {
        switch (this.stateHandler.getState()) {
            case 1: {
                this.viewFinderMode.handleStateViewfinder();
                break;
            }
            case 2: {
                this.freezeMode.handleStateAddVoiceOrSend();
                break;
            }
            case 3: {
                this.freezeMode.handleStateRecordVoice();
                break;
            }
            case 6: {
                this.freezeMode.handleStatePlayVoice();
                break;
            }
            case 7: {
                this.freezeMode.handleStateDiscardRecPrompt();
                break;
            }
            case 4: {
                this.freezeMode.handleStateSendAudioVideo();
                break;
            }
            case 5: {
                this.sendMode.handleStateSendMMS();
                break;
            }
        }
    }

    public synchronized void transit(int newState) throws IllegalStateException, MediaException {
        int currentState = this.stateHandler.getState();
        if (newState == currentState) {
            // empty if block
        }
        this.stateHandler.setLastState(currentState);
        if (!this.presentationManager.isTextTimeoutActive() && !this.presentationManager.isTextPersistent()) {
            this.presentationManager.hideText(false);
        }
        this.presentationManager.removeKeys(true);
        this.stateHandler.setState(newState);
        this.addKeys(newState, true);
        this.handleState();
    }

    public void revertState() throws MediaException {
        this.transit(this.stateHandler.getLastState());
    }

    public void addKeys(int currentState, boolean doViewUpdate) throws IllegalArgumentException {
        int[] commandSet = this.getKeySet(currentState);
        if (commandSet == null) {
            throw new IllegalArgumentException();
        }
        this.presentationManager.addKeys(commandSet, doViewUpdate);
    }

    private int[] getKeySet(int state) {
        int[] commandSet = null;
        switch (state) {
            case 1: {
                commandSet = CommandHandler.COMMANDS_VIEWFINDER;
                break;
            }
            case 2: {
                commandSet = CommandHandler.COMMANDS_ADD_VOICE_OR_SEND;
                break;
            }
            case 3: {
                commandSet = CommandHandler.COMMANDS_RECORD_VOICE;
                break;
            }
            case 6: {
                commandSet = CommandHandler.COMMANDS_PLAY_VOICE;
                break;
            }
            case 7: {
                commandSet = CommandHandler.COMMANDS_DISCARD_REC_PROMPT;
                break;
            }
            case 4: {
                commandSet = CommandHandler.COMMANDS_SEND_AUDIO_VIDEO;
                break;
            }
            case 5: {
                commandSet = CommandHandler.COMMANDS_SEND_MMS;
                break;
            }
            case 8: {
                commandSet = CommandHandler.COMMANDS_CAMERA_OPTIONS;
            }
        }
        return commandSet;
    }

    private boolean isBusy() {
        return this.presentationManager.isTextTimeoutActive();
    }

    public boolean minimizeAndWaitForShutdown() {
        boolean requestExit = true;
        this.closeAfterTransfers = true;
        this.presentationManager.hide(true);
        long endTime = System.currentTimeMillis() + 300000L;
        while (this.closeAfterTransfers && this.stateHandler.getNbrOfPendingTransfers() > 0 && System.currentTimeMillis() < endTime) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.stateHandler.getNbrOfPendingTransfers() == 0) {
            // empty if block
        }
        if (!(requestExit = this.closeAfterTransfers)) {
            // empty if block
        }
        if (!this.closeAfterTransfers || this.stateHandler.getNbrOfPendingTransfers() > 0) {
            // empty if block
        }
        return requestExit;
    }

    public void stopWaitingForTransfers() {
        this.closeAfterTransfers = false;
    }

    public boolean isPendingMMS() {
        return this.stateHandler.getNbrOfPendingTransfers() > 0;
    }

    public void cancelCloseAfterTransfers() {
        if (this.closeAfterTransfers) {
            this.stopWaitingForTransfers();
        }
    }
}

