/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.AudioHandler;
import com.sonyericsson.audiopostcard.model.FileHandler;
import javax.microedition.media.MediaException;

class AudioFramework {
    private AudioHandler audioHandler = new AudioHandler();
    public static final int AUDIO_AMR = 0;
    public static final int AUDIO_WAV = 1;
    public static final int AUDIO_3GP = 2;

    public void shutdown() throws MediaException {
        this.audioHandler.shutdown();
    }

    public void pause() {
        this.audioHandler.pause();
    }

    public void resume() {
        this.audioHandler.resume();
    }

    public void prepareAudioCapture() throws MediaException {
        if (2 != this.audioHandler.getType() || !this.audioHandler.isCreated()) {
            this.audioHandler.shutdown();
            try {
                this.audioHandler.createRecorder();
            }
            catch (IllegalStateException e) {
                throw new MediaException();
            }
        }
        this.audioHandler.prepare();
    }

    public void prepareAudioPlayback() throws MediaException {
        if (1 != this.audioHandler.getType() || !this.audioHandler.isCreated()) {
            this.audioHandler.shutdown();
            try {
                this.audioHandler.createPlayer();
            }
            catch (IllegalStateException e) {
                throw new MediaException();
            }
        }
        this.audioHandler.prepare();
    }

    private void commitCapturedAudio() throws MediaException, OutOfMemoryError {
        try {
            this.audioHandler.stop(true);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public long playCapturedAudio() throws IllegalStateException, MediaException, SecurityException {
        this.prepareAudioPlayback();
        this.audioHandler.play();
        return this.audioHandler.getRecordedTimeMs();
    }

    public void captureAudio() throws IllegalStateException, MediaException, SecurityException {
        this.prepareAudioCapture();
        this.audioHandler.record();
    }

    public void handleStopPlayback() throws IllegalStateException, MediaException, OutOfMemoryError {
        this.audioHandler.stop(true);
    }

    public void handleStopRecord(boolean keepAudio) throws IllegalStateException, MediaException, OutOfMemoryError {
        if (keepAudio) {
            this.commitCapturedAudio();
        } else {
            this.audioHandler.stop(false);
        }
    }

    public void loadAudioFromFile(String soundFile, int type) throws MediaException {
        byte[] cameraSound = FileHandler.readData(soundFile);
        if (cameraSound == null) {
            throw new MediaException();
        }
        this.loadAudio(cameraSound, type);
    }

    public void loadAudio(byte[] audioData, int type) throws IllegalStateException, MediaException {
        this.audioHandler.createPlayer(audioData, type);
        this.audioHandler.prepare();
    }

    public void play() throws IllegalStateException, MediaException, SecurityException {
        this.audioHandler.play();
    }

    public void stop(boolean keepAudio) throws IllegalStateException, MediaException, OutOfMemoryError {
        this.audioHandler.stop(keepAudio);
    }

    public byte[] getAudioData() {
        return this.audioHandler.getAudioData();
    }

    public long getMediaTimeMs() {
        return this.audioHandler.getMediaTimeMs();
    }

    public boolean isStopRequested() {
        return this.audioHandler.isStopRequested();
    }

    public long getRecordedTimeMs() {
        return this.audioHandler.getRecordedTimeMs();
    }

    public boolean isRecording() {
        return this.audioHandler.isRecordingAudio();
    }

    public boolean isPlaying() {
        return this.audioHandler.isPlayingAudio();
    }
}

