/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.log.DebugLog;
import com.sonyericsson.audiopostcard.util.SettingsManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.RecordControl;

class AudioHandler
implements PlayerListener {
    private Player player;
    private RecordControl recorder;
    private ByteArrayOutputStream audioOutStream;
    private ByteArrayInputStream audioInStream;
    private byte[] audioData;
    private long recordedTimeMs = 0L;
    private long recorderStartTimeMs = 0L;
    private boolean recordingStarted = false;
    private boolean recordingEnded = false;
    private boolean stopRequested = false;
    public static final int AUDIO_AMR = 0;
    public static final int AUDIO_WAV = 1;
    public static final int AUDIO_3GP = 2;
    public static final int TYPE_NOT_SET = 0;
    public static final int TYPE_PLAYER = 1;
    public static final int TYPE_RECORDER = 2;
    private static final int STATE_VOID = 0;
    private static final int STATE_CREATED = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_RUNNING = 3;
    private static final int STATE_STOPPED = 4;
    private static final int STATE_ERROR = 5;
    private int state;
    private int type;
    private final Object audioContentLock;
    private final Object pauseResumeLock;

    public AudioHandler() {
        this.setState(0);
        this.type = 0;
        this.audioContentLock = new Object();
        this.pauseResumeLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.pauseResumeLock;
        synchronized (object) {
            try {
                if (3 == this.state) {
                    this.stop(true);
                }
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }

    public void resume() {
    }

    public void createPlayer() throws IllegalStateException, MediaException {
        String audioType = SettingsManager.getAudioType();
        this.create(1, audioType);
    }

    public void createPlayer(byte[] data, int audioFormat) throws IllegalStateException, MediaException {
        String audioType;
        this.audioData = data;
        if (audioFormat == 0) {
            audioType = "amr";
        } else if (audioFormat == 1) {
            audioType = "wav";
        } else if (audioFormat == 2) {
            audioType = "3gp";
        } else {
            throw new MediaException();
        }
        this.create(1, audioType);
    }

    public void createRecorder() throws IllegalStateException, MediaException {
        String audioType = SettingsManager.getAudioType();
        this.create(2, audioType);
    }

    public void reset() throws MediaException, IllegalStateException {
        if (3 == this.state) {
            this.stop(true);
        }
        if (this.state != 0) {
            this.player.deallocate();
        }
        this.setState(1);
    }

    public int getType() {
        return this.type;
    }

    public boolean isCreated() {
        return this.state != 0;
    }

    private void setState(int state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAudioInStream() {
        try {
            Object object = this.audioContentLock;
            synchronized (object) {
                if (this.audioInStream != null) {
                    this.audioInStream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void create(int type, String audioType) throws IllegalStateException, MediaException {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        this.type = type;
        if (2 == type) {
            this.createRecorderFromLocator(audioType);
        } else if (1 == type) {
            this.createPlayerFromLocator(audioType);
        } else {
            throw new MediaException();
        }
        this.player.addPlayerListener((PlayerListener)this);
        this.setState(1);
    }

    private void createPlayerFromLocator(String audioType) throws MediaException {
        if (this.audioData == null) {
            throw new MediaException();
        }
        if (audioType.length() == 0) {
            throw new MediaException();
        }
        String locator = "audio/" + audioType;
        this.createFromLocator(locator, this.audioData);
    }

    private void createRecorderFromLocator(String audioType) throws MediaException {
        String locator = "capture://audio";
        if (audioType.length() > 0) {
            locator = String.valueOf(locator) + "?encoding=" + audioType;
        }
        this.createFromLocator(locator, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromLocator(String locator, byte[] audioData) throws MediaException {
        block8: {
            try {
                if (audioData == null) {
                    this.player = Manager.createPlayer((String)locator);
                    break block8;
                }
                this.closeAudioInStream();
                Object object = this.audioContentLock;
                synchronized (object) {
                    this.audioInStream = new ByteArrayInputStream(audioData);
                    this.player = Manager.createPlayer((InputStream)this.audioInStream, (String)locator);
                }
            }
            catch (IOException e) {
                throw new MediaException();
            }
            catch (IllegalArgumentException e) {
                throw new MediaException();
            }
            catch (SecurityException e) {
                throw new MediaException();
            }
        }
    }

    public void prepare() throws MediaException {
        if (2 == this.state) {
            return;
        }
        if (1 != this.state) {
            this.reset();
        }
        this.player.realize();
        this.player.prefetch();
        if (2 == this.type) {
            this.recorder = (RecordControl)this.player.getControl("RecordControl");
            if (this.recorder == null) {
                throw new MediaException();
            }
        } else {
            DebugLog.info("AudioHandler.prepare(): Resetting media time.");
            this.player.setMediaTime(0L);
        }
        this.setState(2);
    }

    public void play() throws IllegalStateException, MediaException, SecurityException {
        if (1 != this.type) {
            throw new IllegalStateException();
        }
        if (3 == this.state) {
            return;
        }
        if (2 != this.state && 4 != this.state) {
            throw new IllegalStateException();
        }
        this.player.start();
        this.setState(3);
    }

    public void record() throws IllegalStateException, MediaException {
        if (2 != this.type) {
            throw new IllegalStateException();
        }
        if (3 == this.state) {
            return;
        }
        if (2 != this.state && 4 != this.state) {
            throw new IllegalStateException();
        }
        this.recordingStarted = false;
        this.recordingEnded = false;
        this.audioData = null;
        this.audioOutStream = new ByteArrayOutputStream();
        this.recorder.setRecordStream((OutputStream)this.audioOutStream);
        this.recorder.startRecord();
        this.recorderStartTimeMs = this.player.getMediaTime() / 1000L;
        this.player.start();
        while (!this.recordingStarted && this.state != 5) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.setState(3);
    }

    public synchronized void stop(boolean keepAudio) throws IllegalStateException, MediaException, OutOfMemoryError {
        if (4 == this.state) {
            return;
        }
        if (3 != this.state) {
            throw new IllegalStateException();
        }
        try {
            this.stopRequested = false;
            this.player.stop();
            if (2 == this.type) {
                this.stopRecorder(keepAudio);
            } else {
                this.player.setMediaTime(0L);
            }
            this.setState(4);
        }
        catch (IOException e) {
            this.setState(5);
            throw new MediaException();
        }
    }

    private void stopRecorder(boolean keepAudio) throws IOException {
        if (keepAudio) {
            this.recorder.stopRecord();
            long durationMs = this.player.getMediaTime() / 1000L - this.recorderStartTimeMs;
            this.recorder.commit();
            this.setRecordedTimeMs(durationMs);
            this.audioData = this.audioOutStream.toByteArray();
        } else {
            this.recorder.reset();
            this.setRecordedTimeMs(0L);
        }
    }

    private void setRecordedTimeMs(long time) {
        this.recordedTimeMs = time;
    }

    public long getRecordedTimeMs() {
        long timeMs = 2 == this.type && this.isRecordingAudio() ? this.player.getMediaTime() / 1000L - this.recorderStartTimeMs : this.recordedTimeMs;
        return timeMs;
    }

    public long getMediaTimeMs() {
        long timeMs = 1 != this.type ? 0L : this.player.getMediaTime() / 1000L;
        return timeMs;
    }

    public boolean isRecordingAudio() {
        boolean recordingActive = 2 != this.type ? false : 3 == this.state && 400 == this.player.getState() && this.recordingStarted && !this.recordingEnded;
        return recordingActive;
    }

    public boolean isPlayingAudio() {
        boolean playingActive = 1 != this.type ? false : 3 == this.state && 400 == this.player.getState();
        return playingActive;
    }

    public boolean isPlayerStopped() {
        return 300 == this.player.getState() || this.state == 5;
    }

    public byte[] getAudioData() {
        if (2 == this.type && 3 == this.state) {
            return null;
        }
        return this.audioData;
    }

    public synchronized void stopRequested() {
        if (3 == this.state) {
            this.stopRequested = true;
        }
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public synchronized void shutdown() throws MediaException {
        if (3 == this.state) {
            this.stop(false);
        }
        if (this.state != 0) {
            this.player.close();
        }
        this.closeAudioInStream();
        this.setState(0);
        this.type = 0;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (!event.equalsIgnoreCase("closed")) {
            if (event.equalsIgnoreCase("deviceUnavailable")) {
                this.pause();
            } else if (event.equalsIgnoreCase("deviceAvailable")) {
                this.resume();
            } else if (event.equalsIgnoreCase("endOfMedia")) {
                this.setState(4);
            } else if (event.equalsIgnoreCase("error")) {
                this.setState(5);
            } else if (!event.equalsIgnoreCase("started") && !event.equalsIgnoreCase("stopped")) {
                if (event.equalsIgnoreCase("recordStarted")) {
                    this.recordingStarted = true;
                } else if (event.equalsIgnoreCase("recordStopped")) {
                    this.recordingEnded = true;
                } else if (event.equalsIgnoreCase("recordError")) {
                    this.recordingEnded = true;
                    this.setState(5);
                }
            }
        }
    }
}

