/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.PresentationManager;
import com.sonyericsson.ui.TextId;
import com.sonyericsson.ui.UIList;

class CameraOptionsHandler {
    private PresentationManager presentationManager;
    public int cameraOption;
    private UIList cameraList;
    private int imageEffectMode;
    private boolean timerEnabled;
    private boolean timerActive;
    private boolean nightModeActive;

    public CameraOptionsHandler(PresentationManager presentationManager) {
        this.presentationManager = presentationManager;
        this.imageEffectMode = 0;
        this.timerEnabled = false;
    }

    public void reset() {
        this.timerEnabled = false;
        this.setTimerActive(false);
        this.nightModeActive = false;
    }

    void handleCameraOption() {
        int[] options = null;
        int selected = 0;
        String title = null;
        int[] commands = null;
        boolean validOption = true;
        switch (this.cameraOption) {
            case 13: {
                title = TextId.getString((int)917);
                options = new int[]{7057, 7173};
                if (this.timerEnabled) {
                    selected = 1;
                }
                commands = new int[1];
                break;
            }
            case 12: {
                title = TextId.getString((int)884);
                options = new int[]{7057, 7173};
                if (this.nightModeActive) {
                    selected = 1;
                }
                commands = this.getCommandsForNightMode(selected);
                break;
            }
            case 14: {
                title = TextId.getString((int)712);
                options = new int[]{7057, 727, 728};
                selected = this.imageEffectMode;
                int[] nArray = new int[2];
                nArray[1] = 15;
                commands = nArray;
                break;
            }
            default: {
                validOption = false;
            }
        }
        if (validOption) {
            this.presentationManager.showCameraList(title, options, commands, selected, true);
        }
    }

    void performCameraOption(UIList cameraList) {
        String title = cameraList.getTitle();
        int selected = cameraList.getSelectedIndex();
        if (title.compareTo(TextId.getString((int)884)) == 0) {
            switch (selected) {
                case 0: {
                    this.nightModeActive = false;
                    break;
                }
                case 1: {
                    this.nightModeActive = true;
                    break;
                }
            }
        } else if (title.compareTo(TextId.getString((int)917)) == 0) {
            switch (selected) {
                case 0: {
                    this.timerEnabled = false;
                    break;
                }
                case 1: {
                    this.timerEnabled = true;
                    break;
                }
            }
        } else if (title.compareTo(TextId.getString((int)712)) == 0) {
            switch (selected) {
                case 0: {
                    this.imageEffectMode = 0;
                    break;
                }
                case 1: {
                    this.imageEffectMode = 1;
                    break;
                }
                case 2: {
                    this.imageEffectMode = 2;
                    break;
                }
            }
        }
    }

    void hideCameraList(boolean doViewUpdate) {
        this.presentationManager.hideCameraList(doViewUpdate);
    }

    void showCameraOptionInfo() {
        int highLighted = this.cameraList.getHighlightIndex();
        String title = this.cameraList.getTitle();
        String message = "";
        if (title.compareTo(TextId.getString((int)884)) == 0) {
            message = TextId.getString((int)883);
        } else if (title.compareTo(TextId.getString((int)712)) == 0) {
            switch (highLighted) {
                case 0: {
                    message = TextId.getString((int)705);
                    break;
                }
                case 1: {
                    message = TextId.getString((int)703);
                    break;
                }
                case 2: {
                    message = TextId.getString((int)704);
                }
            }
        }
        this.presentationManager.showDialogInfo(new String[]{message}, false, true);
    }

    void updateCameraList(UIList cameraList) {
        if (this.cameraOption == 12) {
            int[] commands = this.getCommandsForNightMode(cameraList.getHighlightIndex());
            this.presentationManager.showCameraList(null, null, commands, cameraList.getHighlightIndex(), false);
            this.presentationManager.modifyCameraList(true, true);
        }
        this.cameraList = cameraList;
    }

    private int[] getCommandsForNightMode(int item) {
        int[] commands = null;
        if (item == 0) {
            commands = new int[1];
        } else {
            int[] nArray = new int[2];
            nArray[1] = 15;
            commands = nArray;
        }
        return commands;
    }

    void stopTimerIfActive() {
        if (this.isTimerEnabled() && this.isTimerActive()) {
            this.setTimerActive(false);
        }
    }

    public synchronized boolean isTimerActive() {
        return this.timerActive;
    }

    public synchronized void setTimerActive(boolean timerActive) {
        this.timerActive = timerActive;
    }

    boolean isTimerEnabled() {
        return this.timerEnabled;
    }

    boolean isNightModeActive() {
        return this.nightModeActive;
    }

    int getImageEffectMode() {
        return this.imageEffectMode;
    }

    void setCameraOptionCommand(int cameraOption) {
        this.cameraOption = cameraOption;
    }
}

