/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.FileHandler;
import com.sonyericsson.audiopostcard.model.ImageHandler;
import com.sonyericsson.audiopostcard.util.SettingsManager;
import com.sonyericsson.ui.TextId;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.imageeffect.OverlayControl;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

class FrameHandler {
    private static byte[] largeImageData = null;
    private static byte[] scaledImageData = null;
    static /* synthetic */ Class class$0;

    FrameHandler() {
    }

    public static int getNoOfFrames() {
        int content = 0;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            InputStream is = clazz.getResourceAsStream("/noofframes.txt");
            StringBuffer noOfFrames = new StringBuffer();
            while (is != null && (content = is.read()) != -1) {
                noOfFrames.append((char)content);
            }
            content = Integer.parseInt(noOfFrames.toString());
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return content;
    }

    public static Image loadLargeFrame(String filename) throws IOException {
        Image image = Image.createImage((String)("/frames_large/" + filename));
        return image;
    }

    public static byte[] addJpegImageWithSmallFrame(byte[] imageData, String overlayImageFilename) throws MediaException, IOException {
        Image frame = FrameHandler.loadSmallFrame(overlayImageFilename);
        return FrameHandler.addJpegImageWithFrame(imageData, frame, 100);
    }

    public static byte[] addJpegImageWithLargeFrame(byte[] imageData, String overlayImageFilename) throws MediaException, IOException {
        Image frame = FrameHandler.loadLargeFrame(overlayImageFilename);
        return FrameHandler.addJpegImageWithFrame(imageData, frame, 95);
    }

    private static byte[] addJpegImageWithFrame(byte[] imageData, Image frame, int pictureQuality) throws MediaException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MediaProcessor mp = GlobalManager.createMediaProcessor((String)"image/jpeg");
        mp.setInput((InputStream)in, imageData.length);
        ImageFormatControl fc = (ImageFormatControl)mp.getControl("javax.microedition.amms.control.ImageFormatControl");
        fc.setFormat("image/jpeg");
        fc.setParameter("quality", pictureQuality);
        fc.setMetadataOverride(false);
        OverlayControl ol = (OverlayControl)mp.getControl("javax.microedition.amms.control.imageeffect.OverlayControl");
        ol.insertImage((Object)frame, 0, 0, 0);
        ol.setEnabled(true);
        mp.setOutput((OutputStream)out);
        mp.complete();
        return out.toByteArray();
    }

    public static Image loadSmallFrame(String filename) throws IOException {
        Image image = Image.createImage((String)("/frames_small/" + filename));
        return image;
    }

    private static void storeWithFrame(byte[] imageData, String overlayImageFilename) throws IOException, MediaException {
        byte[] largePicture = FrameHandler.addJpegImageWithLargeFrame(imageData, overlayImageFilename);
        FrameHandler.storeImage(largePicture);
    }

    private static byte[] rescaleAndAddSmallFrame(byte[] imageData, String overlayImageFilename) throws IOException, MediaException {
        byte[] scaledImageData = ImageHandler.rescaleImage(imageData, 240, 180, "image/jpeg", 100);
        byte[] imageWithFrame = FrameHandler.addJpegImageWithSmallFrame(scaledImageData, overlayImageFilename);
        return imageWithFrame;
    }

    private static void storeImage(byte[] imageData) throws IOException {
        largeImageData = imageData;
        String filenamePrefix = TextId.getString((int)5810);
        if ('?' == filenamePrefix.charAt(0)) {
            filenamePrefix = filenamePrefix.substring(1);
        }
        FileHandler.saveData(imageData, SettingsManager.getPhotoPath(), filenamePrefix, SettingsManager.getImageSuffix());
    }

    public static void saveAndRescale(byte[] imageData) throws IOException, MediaException {
        byte[] newImageData = ImageHandler.rescaleImage(imageData, 0, 0, "image/jpeg", 95);
        FrameHandler.storeImage(newImageData);
        scaledImageData = ImageHandler.rescaleImage(newImageData, 240, 180, "image/jpeg", 100);
    }

    public static void saveWithFrameAndRescale(byte[] imageData, String overlayImageFilename) throws IOException, MediaException {
        FrameHandler.storeWithFrame(imageData, overlayImageFilename);
        scaledImageData = FrameHandler.rescaleAndAddSmallFrame(imageData, overlayImageFilename);
    }

    public static byte[] getLargeImageData() {
        return largeImageData;
    }

    public static byte[] getScaledImageData() {
        return scaledImageData;
    }
}

