/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.util.SettingsManager;
import java.io.IOException;
import javax.microedition.amms.control.camera.CameraControl;
import javax.microedition.amms.control.camera.SnapshotControl;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VideoControl;

class ImageGrabber
implements PlayerListener {
    private Player grabber;
    private VideoControl videoControl;
    private CameraControl cameraControl;
    private SnapshotControl snapshotControl;
    private Object pauseResumeLock = new Object();
    private static final int STATE_VOID = 0;
    private static final int STATE_CREATED = 1;
    private static final int STATE_RUNNING = 2;
    private static final int STATE_PAUSED = 3;
    private static final int STATE_STOPPED = 4;
    private static final int STATE_ERROR = 5;
    private int state = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        Object object = this.pauseResumeLock;
        synchronized (object) {
            if (2 == this.state) {
                try {
                    this.grabber.stop();
                    this.hide();
                    this.state = 3;
                }
                catch (MediaException e) {
                    this.state = 5;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.pauseResumeLock;
        synchronized (object) {
            if (3 == this.state) {
                try {
                    this.grabber.start();
                    this.show();
                    this.state = 2;
                }
                catch (MediaException e) {
                    this.state = 5;
                }
            }
        }
    }

    public VideoControl create() throws IllegalStateException, MediaException {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        try {
            this.grabber = Manager.createPlayer((String)"capture://video");
            this.grabber.addPlayerListener((PlayerListener)this);
            this.grabber.realize();
            this.videoControl = (VideoControl)this.grabber.getControl("VideoControl");
            if (this.videoControl == null) {
                throw new MediaException();
            }
            this.state = 1;
        }
        catch (IOException e) {
            throw new MediaException();
        }
        return this.videoControl;
    }

    public void initialize() throws IllegalStateException, MediaException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        try {
            this.setUpVideo();
        }
        catch (IllegalStateException e) {
            throw new MediaException();
        }
        this.cameraControl = (CameraControl)this.grabber.getControl("javax.microedition.amms.control.camera.CameraControl");
        if (this.cameraControl == null) {
            throw new MediaException();
        }
        this.snapshotControl = (SnapshotControl)this.grabber.getControl("javax.microedition.amms.control.camera.SnapshotControl");
        if (this.snapshotControl == null) {
            // empty if block
        }
    }

    private void setUpVideo() {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        int width = 240;
        int height = 180;
        try {
            this.videoControl.setDisplayLocation(0, 41);
            this.videoControl.setDisplaySize(240, 180);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void captureVideo() throws MediaException {
        if (1 == this.state || 4 == this.state) {
            this.grabber.prefetch();
            this.grabber.start();
            this.show();
            this.state = 2;
        } else if (2 != this.state) {
            // empty if block
        }
    }

    public int increaseZoom() throws IllegalStateException {
        if (2 != this.state) {
            throw new IllegalStateException();
        }
        int zoom = 0;
        return zoom;
    }

    public int decreaseZoomLevel() throws IllegalStateException {
        if (2 != this.state) {
            throw new IllegalStateException();
        }
        int zoom = 0;
        return zoom;
    }

    public int increaseBrightness() throws IllegalStateException {
        if (2 != this.state) {
            throw new IllegalStateException();
        }
        int brightness = 0;
        return brightness;
    }

    public int decreaseBrightness() throws IllegalStateException {
        if (2 != this.state) {
            throw new IllegalStateException();
        }
        int brightness = 0;
        return brightness;
    }

    public byte[] getSnapshot() throws IllegalStateException, MediaException, SecurityException {
        byte[] imageData = null;
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        String format = SettingsManager.getImageFormat();
        imageData = this.videoControl.getSnapshot(format);
        if (imageData == null || imageData.length == 0) {
            throw new MediaException();
        }
        return imageData;
    }

    public void stopCapturing() throws MediaException, IllegalStateException {
        if (this.state != 2) {
            throw new IllegalStateException();
        }
        this.hide();
        this.grabber.stop();
        this.state = 4;
    }

    private void hide() {
        if (this.videoControl != null) {
            this.videoControl.setVisible(false);
        }
    }

    private void show() {
        if (this.videoControl != null) {
            this.videoControl.setVisible(true);
        }
    }

    public synchronized void shutdown() throws MediaException {
        if (2 == this.state) {
            this.grabber.stop();
        }
        if (this.state != 0) {
            this.grabber.close();
        }
        this.state = 0;
    }

    public void setCameraMode(String mode) {
        if (this.cameraControl != null) {
            this.cameraControl.setExposureMode(mode);
        }
    }

    public String getCameraMode() {
        String mode = "";
        if (this.cameraControl != null) {
            mode = this.cameraControl.getExposureMode();
        }
        return mode;
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (!(event.equalsIgnoreCase("closed") || event.equalsIgnoreCase("deviceUnavailable") || event.equalsIgnoreCase("deviceAvailable") || event.equalsIgnoreCase("endOfMedia"))) {
            if (event.equalsIgnoreCase("error")) {
                this.state = 5;
            } else if (event.equalsIgnoreCase("started") || event.equalsIgnoreCase("stopped")) {
                // empty if block
            }
        }
    }
}

