/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.amms.GlobalManager;
import javax.microedition.amms.MediaProcessor;
import javax.microedition.amms.control.ImageFormatControl;
import javax.microedition.amms.control.imageeffect.ImageTransformControl;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;

class ImageHandler {
    ImageHandler() {
    }

    public static byte[] rescaleImage(byte[] imageData, int width, int height, String format, int pictureQuality) throws MediaException {
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MediaProcessor mp = GlobalManager.createMediaProcessor((String)format);
        if (format.equalsIgnoreCase("image/raw")) {
            mp.setInput((Object)Image.createImage((byte[])imageData, (int)0, (int)imageData.length));
        } else {
            mp.setInput((InputStream)in, imageData.length);
        }
        ImageFormatControl fc = (ImageFormatControl)mp.getControl("javax.microedition.amms.control.ImageFormatControl");
        ImageTransformControl tc = (ImageTransformControl)mp.getControl("javax.microedition.amms.control.imageeffect.ImageTransformControl");
        fc.setFormat("image/jpeg");
        fc.setParameter("quality", pictureQuality);
        int sourceWidth = tc.getSourceWidth();
        int sourceHeight = tc.getSourceHeight();
        tc.setSourceRect(0, 0, sourceWidth, sourceHeight);
        tc.setTargetSize(width, height, 0);
        tc.setEnabled(true);
        mp.setOutput((OutputStream)out);
        mp.complete();
        return out.toByteArray();
    }

    public static Image rescaleTransparentImage(Image src, int sizeX, int sizeY) {
        int arraySize = src.getWidth() * src.getHeight();
        int[] imageData = new int[arraySize];
        int[] scaledImageData = null;
        src.getRGB(imageData, 0, src.getWidth(), 0, 0, src.getWidth(), src.getHeight());
        scaledImageData = ImageHandler.rescaleArray(imageData, src.getWidth(), src.getHeight(), sizeX, sizeY);
        Image dest = Image.createRGBImage((int[])scaledImageData, (int)sizeX, (int)sizeY, (boolean)true);
        return dest;
    }

    private static int[] rescaleArray(int[] src, int x, int y, int x2, int y2) {
        int[] dest = new int[x2 * y2];
        int ratioY = 1024 * y / y2;
        int ratioX = 1024 * x / x2;
        int yy = 0;
        while (yy < y2) {
            int dy = yy * ratioY >> 10;
            int xx = 0;
            while (xx < x2) {
                int dx = xx * ratioX >> 10;
                dest[x2 * yy + xx] = src[x * dy + dx];
                ++xx;
            }
            ++yy;
        }
        return dest;
    }
}

