/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.ActionManager;
import com.sonyericsson.audiopostcard.model.ModelInterface;
import com.sonyericsson.audiopostcard.model.ModelListenerInterface;
import com.sonyericsson.ui.UIList;
import javax.microedition.media.MediaException;

public class InteractionModel {
    private ActionManager actionManager = new ActionManager();
    private boolean initializedScreen = false;

    public void initialize() {
    }

    public void setContactInfo(String contactPhoneNbr, String contactName, String contactImageUrl) {
        this.actionManager.setContactInfo(contactPhoneNbr, contactName, contactImageUrl);
    }

    public ModelInterface getModelInterface() {
        return this.actionManager.getModelInterface();
    }

    public void addView(ModelListenerInterface viewInterface) {
        this.actionManager.addView(viewInterface);
        this.initializedScreen = true;
    }

    public void pause() {
        this.actionManager.pauseResources();
    }

    public void resume() {
        this.actionManager.resumeResources();
    }

    public void setupLoadingState() {
        this.actionManager.setupLoadingState();
    }

    public boolean isShutdown() {
        return this.actionManager.isShutdown();
    }

    public boolean requestExit() {
        return this.actionManager.requestExit();
    }

    public boolean isDirectExitPermitted() {
        return this.actionManager.isDirectExitPermitted();
    }

    public boolean isContentCreated() {
        return this.actionManager.isAudioRecorded();
    }

    public void setupStartState() throws IllegalArgumentException, IllegalStateException, MediaException {
        if (!this.initializedScreen) {
            throw new IllegalStateException();
        }
        this.actionManager.setupStartState();
    }

    public void revertState() throws IllegalStateException, MediaException {
        this.actionManager.revertState();
    }

    public void performCameraOption(UIList cameraList) {
        this.actionManager.performCameraOption(cameraList);
    }

    public void hideCameraList(boolean doViewUpdate) {
        this.actionManager.hideCameraList(doViewUpdate);
    }

    public void updateCameraList(UIList cameraList) {
        this.actionManager.updateCameraList(cameraList);
    }

    public void handleCommand(int key) {
        this.actionManager.handleCommand(key);
    }

    public boolean isValidCommand(int command) {
        return this.actionManager.isValidCommand(command);
    }

    public boolean isValidSpecialKey(int key) {
        return this.actionManager.isValidSpecialKey(key);
    }

    public boolean isPendingMMS() {
        return this.actionManager.isPendingMMS();
    }

    public void cancelCloseAfterTransfers() {
        this.actionManager.cancelCloseAfterTransfers();
    }
}

