/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.MMSHandler;
import com.sonyericsson.audiopostcard.model.PictureHandler;
import com.sonyericsson.audiopostcard.model.PresentationManager;
import com.sonyericsson.audiopostcard.model.SendStateInterface;
import com.sonyericsson.ui.TextId;
import javax.microedition.lcdui.Image;
import javax.wireless.messaging.SizeExceededException;

class SendMode {
    private PresentationManager presentationManager;
    private SendStateInterface stateHandler;

    public SendMode(PresentationManager presentationManager, SendStateInterface stateHandler) {
        this.presentationManager = presentationManager;
        this.stateHandler = stateHandler;
    }

    void handleStateSendMMS() throws IllegalStateException {
        if (this.stateHandler.getLargeImage() == null) {
            throw new IllegalStateException();
        }
        Image contactImage = this.stateHandler.getContactImage();
        if (contactImage == null) {
            String url = this.stateHandler.getContactImageUrl();
            contactImage = PictureHandler.getContactPicture(url);
        }
        this.sendMMSInNewThread();
        String[] pictureText = new String[]{TextId.getString((int)5816), this.stateHandler.getContactName()};
        this.presentationManager.setExitAfterDialogEnabled(true);
        this.presentationManager.showDialog(pictureText, contactImage, true, true);
    }

    private void sendMMSInNewThread() {
        new Thread(){

            public void run() {
                block4: {
                    try {
                        SendMode.this.stateHandler.increaseNbrOfPendingTransfers();
                        byte[] imageData = SendMode.this.stateHandler.getLargeImage();
                        byte[] audioData = SendMode.this.stateHandler.getAudioData();
                        if (audioData != null && imageData.length + audioData.length <= 296960) {
                            MMSHandler.sendMMS(SendMode.this.stateHandler.getContactPhoneNbr(), imageData, audioData, SendMode.this.stateHandler.getRecordedTimeMs());
                            break block4;
                        }
                        if (imageData.length <= 296960) {
                            MMSHandler.sendMMS(SendMode.this.stateHandler.getContactPhoneNbr(), imageData, null, 0L);
                            break block4;
                        }
                        throw new SizeExceededException("");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                SendMode.this.stateHandler.decreaseNbrOfPendingTransfers();
            }
        }.start();
    }
}

