/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.model;

import com.sonyericsson.audiopostcard.model.ActionManagerListener;
import com.sonyericsson.audiopostcard.model.AudioFramework;
import com.sonyericsson.audiopostcard.model.CameraOptionsHandler;
import com.sonyericsson.audiopostcard.model.CommandHandler;
import com.sonyericsson.audiopostcard.model.FrameHandler;
import com.sonyericsson.audiopostcard.model.ImageGrabber;
import com.sonyericsson.audiopostcard.model.PictureHandler;
import com.sonyericsson.audiopostcard.model.PresentationManager;
import com.sonyericsson.audiopostcard.model.ViewFinderStateInterface;
import com.sonyericsson.ui.TextId;
import com.sonyericsson.ui.UIList;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.VideoControl;

class ViewFinderMode {
    private ActionManagerListener actionManagerListener;
    private ImageGrabber imageGrabber;
    private PresentationManager presentationManager;
    private ViewFinderStateInterface stateHandler;
    private CameraOptionsHandler optionsHandler;

    public ViewFinderMode(ActionManagerListener actionManagerListener, PresentationManager presentationManager, ViewFinderStateInterface stateHandler) {
        this.actionManagerListener = actionManagerListener;
        this.imageGrabber = new ImageGrabber();
        this.presentationManager = presentationManager;
        this.stateHandler = stateHandler;
        this.optionsHandler = new CameraOptionsHandler(presentationManager);
        this.createVideo();
        stateHandler.setEndFrame(FrameHandler.getNoOfFrames());
    }

    public void shutdown() throws MediaException {
        this.presentationManager.minimizeRequested = true;
        this.presentationManager.requestUpdateViews();
        if (this.imageGrabber != null) {
            this.imageGrabber.shutdown();
        }
    }

    public void pause() {
        this.imageGrabber.pause();
    }

    public void resume() {
        this.imageGrabber.resume();
    }

    public void reset() {
        this.optionsHandler.reset();
    }

    public void stopTimerIfActive() {
        this.optionsHandler.stopTimerIfActive();
    }

    public void prepareVideoFeed() throws IllegalStateException {
        if (this.imageGrabber == null) {
            throw new IllegalStateException();
        }
        try {
            this.imageGrabber.shutdown();
            VideoControl videoControl = this.imageGrabber.create();
            this.presentationManager.updateVideoControl(videoControl, true);
            this.imageGrabber.initialize();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void createVideo() {
        try {
            if (this.imageGrabber != null) {
                this.imageGrabber.shutdown();
            }
        }
        catch (MediaException mediaException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.imageGrabber = new ImageGrabber();
    }

    public void performCameraOption(UIList cameraList) {
        this.optionsHandler.performCameraOption(cameraList);
        if (this.optionsHandler.isNightModeActive()) {
            this.imageGrabber.setCameraMode("Night mode");
        } else {
            this.imageGrabber.setCameraMode("Auto");
        }
    }

    public void hideCameraList(boolean doViewUpdate) {
        this.optionsHandler.hideCameraList(doViewUpdate);
    }

    public void updateCameraList(UIList cameraList) {
        this.optionsHandler.updateCameraList(cameraList);
    }

    void handleStateViewfinder() {
        this.presentationManager.setSnapshotWaitScreenVisible(false, false);
        if (!this.presentationManager.isImageVisible()) {
            this.presentationManager.showVideoPanel(false);
        }
        if (this.stateHandler.getFrameIndex() > 0) {
            this.presentationManager.selectFrame(this.stateHandler.getFrameIndex());
        }
        if (this.stateHandler.isInitialScreenShown()) {
            this.stateHandler.setInitialScreenShown(false);
        } else {
            this.presentationManager.showPanel(false);
            this.presentationManager.showImage(null, false);
        }
        this.presentationManager.showArrows(false);
        this.presentationManager.setNightModeIconVisible(this.optionsHandler.isNightModeActive(), false);
        this.presentationManager.setTimerIconVisible(this.optionsHandler.isTimerEnabled(), true);
        try {
            this.imageGrabber.captureVideo();
            this.presentationManager.hideVideoPanel(true);
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    void handleKeyViewFinder(int key) throws MediaException {
        if (key == 0) {
            this.actionManagerListener.shutdown(true);
        } else if (9 == key) {
            this.presentationManager.removeKeys(false);
            this.presentationManager.hideArrows(true);
            if (!this.handleTimer()) {
                int nextState = 2;
                try {
                    this.getSnapshot();
                }
                catch (MediaException e) {
                    this.presentationManager.showDialogInfo(new String[]{TextId.getString((int)8891)}, false, true);
                    this.createVideo();
                    this.prepareVideoFeed();
                    nextState = 1;
                }
                catch (OutOfMemoryError e) {
                    this.presentationManager.showDialogInfo(new String[]{TextId.getString((int)8891)}, false, true);
                    nextState = 1;
                }
                this.actionManagerListener.transit(nextState);
            } else {
                this.presentationManager.addKeys(CommandHandler.COMMANDS_VIEWFINDER, false);
                this.presentationManager.showArrows(true);
            }
        } else if (18 == key) {
            this.previousFrame();
        } else if (19 == key) {
            this.nextFrame();
        } else if (12 == key) {
            this.presentationManager.hideArrows(false);
            this.optionsHandler.setCameraOptionCommand(12);
            this.optionsHandler.handleCameraOption();
            this.actionManagerListener.transit(8);
        } else if (14 == key) {
            this.presentationManager.hideArrows(false);
            this.optionsHandler.setCameraOptionCommand(14);
            this.optionsHandler.handleCameraOption();
            this.actionManagerListener.transit(8);
        } else if (13 == key) {
            this.presentationManager.hideArrows(false);
            this.optionsHandler.setCameraOptionCommand(13);
            this.optionsHandler.handleCameraOption();
            this.actionManagerListener.transit(8);
        }
    }

    public void getSnapshot() throws IllegalStateException, MediaException, OutOfMemoryError {
        try {
            this.presentationManager.setSnapshotWaitScreenVisible(true, true);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            byte[] imageData = this.imageGrabber.getSnapshot();
            String[] saveMessage = new String[]{TextId.getString((int)916), "", "", ""};
            this.presentationManager.showText(saveMessage, true);
            imageData = PictureHandler.addEffect(imageData, this.optionsHandler.getImageEffectMode(), 95);
            String overlayImageFilename = String.valueOf(this.stateHandler.getFrameIndex()) + ".png";
            if (this.stateHandler.getFrameIndex() > 0) {
                FrameHandler.saveWithFrameAndRescale(imageData, overlayImageFilename);
            } else {
                FrameHandler.saveAndRescale(imageData);
            }
            byte[] scaledImageData = FrameHandler.getScaledImageData();
            this.stateHandler.setLargeImage(FrameHandler.getLargeImageData());
            Image image = Image.createImage((byte[])scaledImageData, (int)0, (int)scaledImageData.length);
            this.presentationManager.hidePanel(false);
            this.presentationManager.hideArrows(false);
            this.presentationManager.hideNightModeIcon(false);
            this.presentationManager.hideTimerIcon(false);
            this.presentationManager.showFrame(null, false);
            this.presentationManager.showImage(image, false);
            try {
                this.imageGrabber.stopCapturing();
                this.presentationManager.hideText(false);
                this.presentationManager.setSnapshotWaitScreenVisible(false, true);
            }
            catch (MediaException e) {
                this.prepareVideoFeed();
                throw new MediaException();
            }
        }
        catch (IllegalArgumentException e) {
            throw new MediaException();
        }
        catch (SecurityException e) {
            throw new MediaException();
        }
        catch (IOException e) {
            throw new MediaException();
        }
    }

    void handleKeyCameraOptions(int key) throws MediaException {
        if (key == 0) {
            this.optionsHandler.hideCameraList(true);
            this.actionManagerListener.transit(1);
        } else if (15 == key) {
            this.optionsHandler.showCameraOptionInfo();
        }
    }

    private boolean handleTimer() {
        boolean canceled = false;
        if (this.optionsHandler.isTimerEnabled()) {
            try {
                canceled = this.timerCountdown();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
        return canceled;
    }

    private boolean timerCountdown() throws MediaException {
        int[] TIMER_COUNTDOWN_TICKS = new int[]{5, 10};
        int[] TIMER_COUNTDOWN_INTERVAL_MS = new int[]{1000, 500};
        AudioFramework cameraSoundHandler = new AudioFramework();
        boolean isCanceled = false;
        this.optionsHandler.setTimerActive(true);
        String soundFile = "file:///tpa:/preset/system/sound/cameratimer.3gp";
        cameraSoundHandler.loadAudioFromFile(soundFile, 2);
        int index = 0;
        while (this.optionsHandler.isTimerActive() && index < TIMER_COUNTDOWN_TICKS.length) {
            int count = 0;
            while (this.optionsHandler.isTimerActive() && count < TIMER_COUNTDOWN_TICKS[index]) {
                cameraSoundHandler.play();
                try {
                    Thread.sleep(TIMER_COUNTDOWN_INTERVAL_MS[index]);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (cameraSoundHandler.isPlaying()) {
                    cameraSoundHandler.stop(false);
                }
                ++count;
            }
            ++index;
        }
        cameraSoundHandler.shutdown();
        if (!this.optionsHandler.isTimerActive()) {
            isCanceled = true;
        }
        this.optionsHandler.setTimerActive(false);
        return isCanceled;
    }

    public void nextFrame() {
        this.stateHandler.increaseFrameIndex();
        this.presentationManager.selectFrame(this.stateHandler.getFrameIndex());
    }

    public void previousFrame() {
        this.stateHandler.decreaseFrameIndex();
        this.presentationManager.selectFrame(this.stateHandler.getFrameIndex());
    }
}

