/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.audiopostcard.util;

public class SettingsManager {
    private static String imageFormat = "";
    private static String imageSuffix = "";
    private static String imageType = "";
    private static String audioFormat = "";
    private static String audioSuffix = "";
    private static String audioType = "";
    private static String photoPath = "file:///c:/pictures/";
    private static final String encodingTag = "encoding=";

    public static void initialize() {
        String encodings;
        if (System.getProperty("supports.audio.capture").equalsIgnoreCase("true")) {
            encodings = System.getProperty("audio.encodings");
            SettingsManager.parseAudioEncodings(encodings);
        }
        if (System.getProperty("supports.video.capture").equalsIgnoreCase("true")) {
            encodings = System.getProperty("video.snapshot.encodings");
            SettingsManager.parseVideoEncodings(encodings);
        }
    }

    private static void parseAudioEncodings(String encodings) {
        SettingsManager.parseEncodings(encodings, true);
    }

    private static void parseVideoEncodings(String encodings) {
        SettingsManager.parseEncodings(encodings, false);
    }

    private static void parseEncodings(String encodings, boolean audio) {
        String tag = encodingTag;
        int index = encodings.indexOf(encodingTag);
        while (index >= 0) {
            int spaceIndex = encodings.indexOf(" ");
            if (spaceIndex > 0) {
                if (audio) {
                    SettingsManager.parseAudioFormat(encodings.substring(index, spaceIndex));
                } else {
                    SettingsManager.parseVideoFormat(encodings.substring(index, spaceIndex));
                }
                encodings = encodings.substring(spaceIndex + 1);
                index = encodings.indexOf(encodingTag);
                continue;
            }
            if (audio) {
                SettingsManager.parseAudioFormat(encodings.substring(index));
            } else {
                SettingsManager.parseVideoFormat(encodings.substring(index));
            }
            index = -1;
        }
    }

    private static void parseVideoFormat(String encoding) {
        if (imageFormat.indexOf("encoding=jpeg") == -1 && encoding.indexOf("encoding=jpeg") >= 0) {
            imageFormat = encoding;
            imageSuffix = "jpeg";
            imageType = "jpeg";
        } else if (imageFormat.length() == 0) {
            imageFormat = encoding;
            int separator = encoding.indexOf("&");
            imageSuffix = separator >= 0 ? encoding.substring(encodingTag.length(), separator) : encoding.substring(encodingTag.length());
            imageType = imageSuffix;
        }
    }

    private static void parseAudioFormat(String encoding) {
        if (audioFormat.indexOf("encoding=amr") == -1 && encoding.indexOf("encoding=amr") >= 0) {
            audioFormat = encoding;
            audioSuffix = "AMR";
            audioType = "amr";
        } else if (audioFormat.length() == 0) {
            audioFormat = encoding;
            int separator = encoding.indexOf("&");
            audioSuffix = separator >= 0 ? encoding.substring(encodingTag.length(), separator) : encoding.substring(encodingTag.length());
            audioType = audioSuffix;
        }
    }

    public static String getAudioType() {
        return audioType;
    }

    public static String getImageFormat() {
        return imageFormat;
    }

    public static String getPhotoPath() {
        return photoPath;
    }

    public static String getImageSuffix() {
        return imageSuffix;
    }

    public static String getImageType() {
        return imageType;
    }
}

